/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.lib.wires;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelRotation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.util.vector.Vector3f;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.render.ModelFactory;
import pl.asie.charset.lib.render.SimpleBakedModel;
import pl.asie.charset.lib.render.SpritesheetFactory;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.lib.wires.PartWire;
import pl.asie.charset.lib.wires.WireFactory;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.lib.wires.WireUtils;

public class RendererWire
extends ModelFactory<PartWire> {
    private final ModelRotation[] ROTATIONS = new ModelRotation[]{ModelRotation.X0_Y0, ModelRotation.X180_Y0, ModelRotation.X270_Y0, ModelRotation.X270_Y180, ModelRotation.X270_Y270, ModelRotation.X270_Y90};
    private final TIntObjectMap<PartWire> stackMap = new TIntObjectHashMap();
    private final Map<WireFactory, WireSheet> sheetMap = new HashMap<WireFactory, WireSheet>();

    public RendererWire() {
        super(PartWire.PROPERTY, new ResourceLocation("charsetwires:blocks/wire_normal_particle"));
        this.addDefaultBlockTransforms();
    }

    public WireSheet getSheet(WireFactory type) {
        return this.sheetMap.get(type);
    }

    public void registerSheet(TextureMap map, WireFactory type) {
        ResourceLocation location = type.getTexturePrefix();
        String domain = location.func_110624_b();
        String path = location.func_110623_a();
        WireSheet sheet = new WireSheet();
        sheet.top = SpritesheetFactory.register(map, new ResourceLocation(domain, path + "_top"), 4, 4);
        sheet.particle = map.func_174942_a(new ResourceLocation(domain, path + "_particle"));
        sheet.edge = map.func_174942_a(new ResourceLocation(domain, path + "_edge"));
        sheet.side = map.func_174942_a(new ResourceLocation(domain, path + "_side"));
        sheet.width = (int)(type.getWidth() * 16.0f);
        sheet.height = (int)(type.getHeight() * 16.0f);
        this.sheetMap.put(type, sheet);
    }

    private boolean wc(PartWire wire, EnumFacing facing) {
        return wire.connects(facing);
    }

    private boolean isCenterEdge(PartWire wire, WireFace side) {
        return false;
    }

    private float getCL(PartWire wire, WireFace side) {
        float h = 0.0f;
        if (wire != null && this.isCenterEdge(wire, side)) {
            h = 0.0f;
        }
        if (!this.wc(wire, side.facing) && wire.getFactory() != null) {
            h = 8.0f - (float)(this.sheetMap.get((Object)wire.getFactory()).width / 2);
        }
        return side.facing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE ? 16.0f - h : h;
    }

    public void addWireFreestanding(PartWire wire, WireSheet sheet, int renderColor, List<BakedQuad> quads) {
        float min = 8.0f - (float)(sheet.width / 2);
        float max = 8.0f + (float)(sheet.width / 2);
        Vector3f minX = new Vector3f(min, this.getCL(wire, WireFace.DOWN), this.getCL(wire, WireFace.NORTH));
        Vector3f maxX = new Vector3f(min, this.getCL(wire, WireFace.UP), this.getCL(wire, WireFace.SOUTH));
        Vector3f minY = new Vector3f(this.getCL(wire, WireFace.WEST), min, this.getCL(wire, WireFace.NORTH));
        Vector3f maxY = new Vector3f(this.getCL(wire, WireFace.EAST), min, this.getCL(wire, WireFace.SOUTH));
        Vector3f minZ = new Vector3f(this.getCL(wire, WireFace.WEST), this.getCL(wire, WireFace.DOWN), min);
        Vector3f maxZ = new Vector3f(this.getCL(wire, WireFace.EAST), this.getCL(wire, WireFace.UP), min);
        int cmcX = (this.wc(wire, EnumFacing.UP) ? 8 : 0) | (this.wc(wire, EnumFacing.DOWN) ? 4 : 0) | (this.wc(wire, EnumFacing.NORTH) ? 2 : 0) | (this.wc(wire, EnumFacing.SOUTH) ? 1 : 0);
        int cmcY = (this.wc(wire, EnumFacing.NORTH) ? 4 : 0) | (this.wc(wire, EnumFacing.SOUTH) ? 8 : 0) | (this.wc(wire, EnumFacing.WEST) ? 2 : 0) | (this.wc(wire, EnumFacing.EAST) ? 1 : 0);
        int cmcZ = (this.wc(wire, EnumFacing.UP) ? 8 : 0) | (this.wc(wire, EnumFacing.DOWN) ? 4 : 0) | (this.wc(wire, EnumFacing.WEST) ? 1 : 0) | (this.wc(wire, EnumFacing.EAST) ? 2 : 0);
        for (int i = 0; i < 2; ++i) {
            quads.add(RenderUtils.BAKERY.makeBakedQuad(minX, maxX, renderColor, sheet.top[cmcX], i == 0 ? EnumFacing.WEST : EnumFacing.EAST, ModelRotation.X0_Y0, true));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(minY, maxY, renderColor, sheet.top[cmcY], i == 0 ? EnumFacing.DOWN : EnumFacing.UP, ModelRotation.X0_Y0, true));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(minZ, maxZ, renderColor, sheet.top[cmcZ], i == 0 ? EnumFacing.NORTH : EnumFacing.SOUTH, ModelRotation.X0_Y0, true));
            if (i != 0) continue;
            minX.setX(max);
            maxX.setX(max);
            minY.setY(max);
            maxY.setY(max);
            minZ.setZ(max);
            maxZ.setZ(max);
            cmcY = cmcY & 3 | (cmcY & 8) >> 1 | (cmcY & 4) << 1;
            cmcZ = cmcZ & 0xC | (cmcZ & 2) >> 1 | (cmcZ & 1) << 1;
            cmcX = cmcX & 0xC | (cmcX & 2) >> 1 | (cmcX & 1) << 1;
        }
        for (EnumFacing f : EnumFacing.field_82609_l) {
            float[] fArray;
            if (!this.wc(wire, f)) continue;
            Vector3f vector3f = new Vector3f(min, 0.0f, min);
            Vector3f vector3f2 = new Vector3f(max, 0.0f, max);
            if (f.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
                float[] fArray2 = new float[4];
                fArray2[0] = max;
                fArray2[1] = min;
                fArray2[2] = min;
                fArray = fArray2;
                fArray2[3] = max;
            } else {
                float[] fArray3 = new float[4];
                fArray3[0] = min;
                fArray3[1] = min;
                fArray3[2] = max;
                fArray = fArray3;
                fArray3[3] = max;
            }
            quads.add(RenderUtils.BAKERY.makeBakedQuad(vector3f, vector3f2, renderColor, fArray, sheet.edge, EnumFacing.DOWN, this.ROTATIONS[f.ordinal()], true));
        }
    }

    public void addCorner(PartWire wire, WireSheet sheet, EnumFacing dir, int renderColor, List<BakedQuad> quads) {
        int width = sheet.width;
        int height = sheet.height;
        ModelRotation rot = this.ROTATIONS[wire.location.ordinal()];
        float min = 8.0f - (float)(width / 2);
        float max = 8.0f + (float)(width / 2);
        float[] edgeUV = new float[]{min, 0.0f, max, height};
        float[] edgeUVFlipped = new float[]{max, 0.0f, min, height};
        if (dir == EnumFacing.NORTH) {
            float[] topUV = new float[]{min, 16 - height, max, 16.0f};
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, 0.0f, (float)(-height)), new Vector3f(max, (float)height, (float)(-height)), renderColor, edgeUVFlipped, sheet.top[15], EnumFacing.NORTH, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, (float)height, (float)(-height)), new Vector3f(max, (float)height, 0.0f), renderColor, topUV, sheet.top[15], EnumFacing.UP, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, 0.0f, (float)(-height)), new Vector3f(min, (float)height, 0.0f), renderColor, edgeUV, sheet.edge, EnumFacing.WEST, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(max, 0.0f, (float)(-height)), new Vector3f(max, (float)height, 0.0f), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.EAST, rot, false));
        } else if (dir == EnumFacing.SOUTH) {
            float[] topUV = new float[]{min, 0.0f, max, height};
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, 0.0f, (float)(16 + height)), new Vector3f(max, (float)height, (float)(16 + height)), renderColor, edgeUVFlipped, sheet.top[15], EnumFacing.SOUTH, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, (float)height, 16.0f), new Vector3f(max, (float)height, (float)(16 + height)), renderColor, topUV, sheet.top[15], EnumFacing.UP, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, 0.0f, 16.0f), new Vector3f(min, (float)height, (float)(16 + height)), renderColor, edgeUV, sheet.edge, EnumFacing.WEST, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(max, 0.0f, 16.0f), new Vector3f(max, (float)height, (float)(16 + height)), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.EAST, rot, false));
        } else if (dir == EnumFacing.WEST) {
            float[] topUV = new float[]{16 - height, min, 16.0f, max};
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(-height), (float)height, min), new Vector3f(0.0f, (float)height, max), renderColor, topUV, sheet.top[15], EnumFacing.UP, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(-height), 0.0f, min), new Vector3f((float)(-height), (float)height, max), renderColor, edgeUV, sheet.top[15], EnumFacing.WEST, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(-height), 0.0f, min), new Vector3f(0.0f, (float)height, min), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.NORTH, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(-height), 0.0f, max), new Vector3f(0.0f, (float)height, max), renderColor, edgeUV, sheet.edge, EnumFacing.SOUTH, rot, false));
        } else if (dir == EnumFacing.EAST) {
            float[] topUV = new float[]{0.0f, min, height, max};
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(16.0f, (float)height, min), new Vector3f((float)(16 + height), (float)height, max), renderColor, topUV, sheet.top[15], EnumFacing.UP, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f((float)(16 + height), 0.0f, min), new Vector3f((float)(16 + height), (float)height, max), renderColor, edgeUV, sheet.top[15], EnumFacing.EAST, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(16.0f, 0.0f, min), new Vector3f((float)(16 + height), (float)height, min), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.NORTH, rot, false));
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(16.0f, 0.0f, max), new Vector3f((float)(16 + height), (float)height, max), renderColor, edgeUV, sheet.edge, EnumFacing.SOUTH, rot, false));
        }
    }

    public void addWire(PartWire wire, WireSheet sheet, List<BakedQuad> quads) {
        int renderColor;
        WireFace side = wire.location;
        int renderColorWire = wire.getRenderColor();
        int n = renderColor = renderColorWire == -1 ? renderColorWire : 0xFF000000 | renderColorWire & 0xFF00 | (renderColorWire & 0xFF0000) >> 16 | (renderColorWire & 0xFF) << 16;
        if (side == WireFace.CENTER) {
            this.addWireFreestanding(wire, sheet, renderColor, quads);
            return;
        }
        float min = 8.0f - (float)(sheet.width / 2);
        float max = 8.0f + (float)(sheet.width / 2);
        float minH = 0.0f;
        float maxH = sheet.height;
        EnumFacing[] dirs = WireUtils.getConnectionsForRender(side);
        boolean[] connectionMatrix = new boolean[]{wire == null ? true : wire.connectsAny(dirs[0]), wire == null ? true : wire.connectsAny(dirs[1]), wire == null ? true : wire.connectsAny(dirs[2]), wire == null ? true : wire.connectsAny(dirs[3])};
        int cmc = (connectionMatrix[0] ? 8 : 0) | (connectionMatrix[1] ? 4 : 0) | (connectionMatrix[2] ? 2 : 0) | (connectionMatrix[3] ? 1 : 0);
        boolean[] cornerConnectionMatrix = new boolean[]{wire == null ? true : wire.connectsCorner(dirs[0]), wire == null ? true : wire.connectsCorner(dirs[1]), wire == null ? true : wire.connectsCorner(dirs[2]), wire == null ? true : wire.connectsCorner(dirs[3])};
        ModelRotation rot = this.ROTATIONS[side.ordinal()];
        Vector3f from = new Vector3f(min, (float)sheet.height, min);
        Vector3f to = new Vector3f(max, (float)sheet.height, max);
        if (connectionMatrix[0]) {
            from.setZ(0.0f);
        }
        if (connectionMatrix[1]) {
            to.setZ(16.0f);
        }
        if (connectionMatrix[2]) {
            from.setX(0.0f);
        }
        if (connectionMatrix[3]) {
            to.setX(16.0f);
        }
        quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, renderColor, new float[]{from.getX(), from.getZ(), to.getX(), to.getZ()}, sheet.top[cmc], EnumFacing.UP, rot, true));
        from.setY(0.0f);
        to.setY(0.0f);
        quads.add(RenderUtils.BAKERY.makeBakedQuad(from, to, renderColor, new float[]{from.getX(), from.getZ(), to.getX(), to.getZ()}, sheet.top[cmc], EnumFacing.DOWN, rot, true));
        Vector3f fromZ = new Vector3f(from.getX(), 0.0f, min);
        Vector3f toZ = new Vector3f(to.getX(), (float)sheet.height, min);
        Vector3f fromX = new Vector3f(min, 0.0f, from.getZ());
        Vector3f toX = new Vector3f(min, (float)sheet.height, to.getZ());
        boolean crossroadsX = connectionMatrix[2] && !connectionMatrix[3];
        boolean crossroadsZ = connectionMatrix[0] && !connectionMatrix[1];
        quads.add(RenderUtils.BAKERY.makeBakedQuad(fromX, toX, renderColor, new float[]{fromX.getZ(), fromX.getY(), toX.getZ(), toX.getY()}, sheet.side, EnumFacing.WEST, rot, false));
        quads.add(RenderUtils.BAKERY.makeBakedQuad(fromZ, toZ, renderColor, new float[]{toZ.getX(), fromZ.getY(), fromZ.getX(), toZ.getY()}, sheet.side, EnumFacing.NORTH, rot, false));
        fromX.setX(max);
        toX.setX(max);
        fromZ.setZ(max);
        toZ.setZ(max);
        quads.add(RenderUtils.BAKERY.makeBakedQuad(fromX, toX, renderColor, new float[]{toX.getZ(), fromX.getY(), fromX.getZ(), toX.getY()}, sheet.side, EnumFacing.EAST, rot, false));
        quads.add(RenderUtils.BAKERY.makeBakedQuad(fromZ, toZ, renderColor, new float[]{fromZ.getX(), fromZ.getY(), toZ.getX(), toZ.getY()}, sheet.side, EnumFacing.SOUTH, rot, false));
        float[] edgeUV = new float[]{min, minH, max, maxH};
        float[] edgeUVFlipped = new float[]{max, minH, min, maxH};
        if (connectionMatrix[0]) {
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, minH, 0.0f), new Vector3f(max, maxH, 0.0f), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.NORTH, rot, false));
        }
        if (connectionMatrix[1]) {
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(min, minH, 16.0f), new Vector3f(max, maxH, 16.0f), renderColor, edgeUV, sheet.edge, EnumFacing.SOUTH, rot, false));
        }
        if (connectionMatrix[2]) {
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(0.0f, minH, min), new Vector3f(0.0f, maxH, max), renderColor, edgeUV, sheet.edge, EnumFacing.WEST, rot, false));
        }
        if (connectionMatrix[3]) {
            quads.add(RenderUtils.BAKERY.makeBakedQuad(new Vector3f(16.0f, minH, min), new Vector3f(16.0f, maxH, max), renderColor, edgeUVFlipped, sheet.edge, EnumFacing.EAST, rot, false));
        }
        EnumFacing[] dirs0 = WireUtils.getConnectionsForRender(WireFace.DOWN);
        for (int i = 0; i < 4; ++i) {
            if (!cornerConnectionMatrix[i]) continue;
            this.addCorner(wire, sheet, dirs0[i], renderColor, quads);
        }
    }

    @Override
    public IBakedModel bake(PartWire wire, boolean isItem, BlockRenderLayer layer) {
        WireSheet sheet = this.sheetMap.get(wire.getFactory());
        SimpleBakedModel model = new SimpleBakedModel((IBakedModel)this);
        if (sheet != null) {
            model.setParticle(sheet.particle);
            this.addWire(wire, sheet, model.func_188616_a(null, null, 0L));
        }
        return model;
    }

    @Override
    public PartWire fromItemStack(ItemStack stack) {
        int md = stack.func_77952_i();
        if (this.stackMap.containsKey(md)) {
            return (PartWire)this.stackMap.get(md);
        }
        PartWire wire = WireManager.ITEM.fromStack(stack, EnumFacing.DOWN);
        wire.setConnectionsForItemRender();
        this.stackMap.put(md, (Object)wire);
        return wire;
    }

    public static class WireSheet {
        TextureAtlasSprite[] top;
        TextureAtlasSprite side;
        TextureAtlasSprite edge;
        TextureAtlasSprite particle;
        int width;
        int height;
    }
}

