/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.pipes.shifter;

import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import pl.asie.charset.api.pipes.IShifter;

public class ShifterImpl
implements IShifter {
    private IShifter.Mode mode;
    private EnumFacing direction;
    private int shiftDistance;
    private boolean shifting;
    private boolean hasFilter;
    private ItemStack filter;

    public ShifterImpl(IShifter.Mode mode, EnumFacing direction, int shiftDistance, boolean isShifting, boolean hasFilter, ItemStack filter) {
        this.mode = mode;
        this.direction = direction;
        this.shiftDistance = shiftDistance;
        this.shifting = isShifting;
        this.hasFilter = hasFilter;
        this.filter = filter;
    }

    @Override
    public IShifter.Mode getMode() {
        return this.mode;
    }

    @Override
    public EnumFacing getDirection() {
        return this.direction;
    }

    @Override
    public int getShiftDistance() {
        return this.shiftDistance;
    }

    @Override
    public boolean isShifting() {
        return this.shifting;
    }

    @Override
    public boolean hasFilter() {
        return this.hasFilter;
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    @Override
    public boolean matches(ItemStack source) {
        return this.filter == null || ItemStack.func_77989_b((ItemStack)this.filter, (ItemStack)source);
    }

    @Override
    public boolean matches(FluidStack source) {
        return source != null && (this.filter == null || FluidContainerRegistry.containsFluid((ItemStack)this.filter, (FluidStack)source) || this.filter.func_77973_b() instanceof IFluidContainerItem && source.isFluidEqual(((IFluidContainerItem)this.filter.func_77973_b()).getFluid(this.filter)));
    }

    public void setMode(IShifter.Mode mode) {
        this.mode = mode;
    }

    public void setDirection(EnumFacing direction) {
        this.direction = direction;
    }

    public void setShiftDistance(int shiftDistance) {
        this.shiftDistance = shiftDistance;
    }

    public void setShifting(boolean shifting) {
        this.shifting = shifting;
    }

    public void setHasFilter(boolean hasFilter) {
        this.hasFilter = hasFilter;
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
    }
}

