/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage;

import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.utils.RenderUtils;
import pl.asie.charset.storage.ModCharsetStorage;
import pl.asie.charset.storage.ProxyCommon;
import pl.asie.charset.storage.backpack.BlockBackpack;
import pl.asie.charset.storage.backpack.ItemBackpack;
import pl.asie.charset.storage.backpack.PacketBackpackOpen;
import pl.asie.charset.storage.backpack.RendererBackpack;
import pl.asie.charset.storage.backpack.TileBackpack;
import pl.asie.charset.storage.barrel.BarrelModel;
import pl.asie.charset.storage.barrel.EntityMinecartDayBarrel;
import pl.asie.charset.storage.barrel.RenderMinecartDayBarrel;
import pl.asie.charset.storage.barrel.TileEntityDayBarrel;
import pl.asie.charset.storage.barrel.TileEntityDayBarrelRenderer;
import pl.asie.charset.storage.crate.CrateModel;
import pl.asie.charset.storage.locking.EntityLock;
import pl.asie.charset.storage.locking.ItemLock;
import pl.asie.charset.storage.locking.RenderLock;

public class ProxyClient
extends ProxyCommon {
    public static final KeyBinding backpackOpenKey = new KeyBinding("key.charset.backpackOpen", 46, "key.categories.gameplay");
    public static final IBakedModel[] backpackTopModel = new IBakedModel[4];
    public static final IBakedModel[] backpackModel = new IBakedModel[4];
    public static final BarrelModel barrelModel = new BarrelModel();
    public static final CrateModel crateModel = new CrateModel();

    @Override
    public void preInit() {
        RenderingRegistry.registerEntityRenderingHandler(EntityLock.class, (IRenderFactory)new IRenderFactory<EntityLock>(){

            public Render<? super EntityLock> createRenderFor(RenderManager manager) {
                return new RenderLock(manager);
            }
        });
        RenderingRegistry.registerEntityRenderingHandler(EntityMinecartDayBarrel.class, (IRenderFactory)new IRenderFactory<EntityMinecartDayBarrel>(){

            public Render<? super EntityMinecartDayBarrel> createRenderFor(RenderManager manager) {
                return new RenderMinecartDayBarrel(manager);
            }
        });
    }

    @Override
    public void init() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileBackpack.class, (TileEntitySpecialRenderer)new RendererBackpack.Tile());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDayBarrel.class, (TileEntitySpecialRenderer)new TileEntityDayBarrelRenderer());
        ClientRegistry.registerKeyBinding((KeyBinding)backpackOpenKey);
        Minecraft.func_71410_x().func_184125_al().func_186722_a((IBlockColor)new BlockBackpack.Color(), new Block[]{ModCharsetStorage.backpackBlock});
        Minecraft.func_71410_x().getItemColors().func_186731_a((IItemColor)new ItemBackpack.Color(), new Block[]{ModCharsetStorage.backpackBlock});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemLock.Color(), new Item[]{ModCharsetStorage.keyItem});
        Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new ItemLock.Color(), new Item[]{ModCharsetStorage.lockItem});
        if (ModCharsetStorage.barrelsEnabled) {
            Minecraft.func_71410_x().func_184125_al().func_186722_a(ProxyClient.barrelModel.colorizer, new Block[]{ModCharsetStorage.barrelBlock});
            Minecraft.func_71410_x().getItemColors().func_186730_a(ProxyClient.barrelModel.colorizer, new Item[]{ModCharsetStorage.barrelItem});
        }
        MinecraftForge.EVENT_BUS.register((Object)new RendererBackpack.Armor());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKey(InputEvent.KeyInputEvent event) {
        ItemStack backpack;
        Minecraft mc = Minecraft.func_71410_x();
        EntityPlayerSP player = mc.field_71439_g;
        if (!mc.field_71415_G || player == null) {
            return;
        }
        if (ModCharsetStorage.enableBackpackOpenKey && backpackOpenKey.func_151468_f() && (backpack = ItemBackpack.getBackpack((EntityPlayer)player)) != null) {
            ModCharsetStorage.packet.sendToServer(new PacketBackpackOpen((EntityPlayer)player));
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onTextureMap(TextureStitchEvent.Pre event) {
        BarrelModel.onTextureLoad(event.getMap());
        CrateModel.onTextureLoad(event.getMap());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onPostBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charsetstorage:barrel", "normal"), (Object)barrelModel);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charsetstorage:barrel", "inventory"), (Object)barrelModel);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charsetstorage:crate", "normal"), (Object)crateModel);
        event.getModelRegistry().func_82595_a((Object)new ModelResourceLocation("charsetstorage:crate", "inventory"), (Object)crateModel);
        IModel backpackModelBase = RenderUtils.getModel(new ResourceLocation("charsetstorage:block/backpack"));
        IModel backpackTopModelBase = RenderUtils.getModel(new ResourceLocation("charsetstorage:block/backpack_top"));
        for (int i = 0; i < 4; ++i) {
            ProxyClient.backpackModel[i] = backpackModelBase.bake((IModelState)new TRSRTransformation(EnumFacing.func_82600_a((int)(i + 2))), DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter);
            ProxyClient.backpackTopModel[i] = backpackTopModelBase.bake((IModelState)new TRSRTransformation(EnumFacing.func_82600_a((int)(i + 2))), DefaultVertexFormats.field_176600_a, RenderUtils.textureGetter);
        }
        BarrelModel.template = (IRetexturableModel)RenderUtils.getModel(new ResourceLocation("charsetstorage:block/barrel"));
    }
}

