/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.backpack;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.lib.inventory.IInventoryOwner;
import pl.asie.charset.lib.inventory.InventorySimple;
import pl.asie.charset.lib.items.IDyeableItem;
import pl.asie.charset.storage.backpack.SlotBackpack;

public class ItemBackpack
extends ItemBlock
implements IDyeableItem {
    public ItemBackpack(Block block) {
        super(block);
        this.func_77625_d(1);
    }

    public static ItemStack getBackpack(EntityPlayer player) {
        ItemStack stack = player.func_184582_a(EntityEquipmentSlot.CHEST);
        if (stack != null && stack.func_77973_b() instanceof ItemBackpack) {
            return stack;
        }
        return null;
    }

    public boolean isValidArmor(ItemStack stack, EntityEquipmentSlot armorType, Entity entity) {
        return armorType == EntityEquipmentSlot.CHEST;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        Container container;
        Slot slot;
        if (entity instanceof EntityPlayer && !((slot = (container = ((EntityPlayer)entity).field_71069_bz).func_75139_a(6)) instanceof SlotBackpack)) {
            SlotBackpack newSlot = new SlotBackpack((EntityPlayer)entity, slot.field_75224_c, slot.getSlotIndex(), slot.field_75223_e, slot.field_75221_f);
            newSlot.field_75222_d = slot.field_75222_d;
            container.field_75151_b.set(6, newSlot);
        }
    }

    @Override
    public int getColor(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("color") ? stack.func_77978_p().func_74762_e("color") : -1;
    }

    @Override
    public boolean hasColor(ItemStack stack) {
        return this.getColor(stack) >= 0;
    }

    @Override
    public void setColor(ItemStack stack, int color) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("color", color);
    }

    public IInventory getInventory(ItemStack stack) {
        if (stack.func_77973_b() == this) {
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            InventorySimple inventory = new InventorySimple(27, new InventoryOwnerBackpack(stack));
            inventory.readFromNBT(stack.func_77978_p(), "items");
            return inventory;
        }
        return null;
    }

    public static class Color
    implements IItemColor {
        @SideOnly(value=Side.CLIENT)
        public int func_186726_a(ItemStack stack, int renderPass) {
            int color = ((IDyeableItem)stack.func_77973_b()).getColor(stack);
            return color >= 0 ? color : 8409144;
        }
    }

    public class InventoryOwnerBackpack
    implements IInventoryOwner {
        public final ItemStack stack;

        protected InventoryOwnerBackpack(ItemStack stack) {
            this.stack = stack;
        }

        @Override
        public void onInventoryChanged(IInventory inventory) {
            ((InventorySimple)inventory).writeToNBT(this.stack.func_77978_p(), "items");
        }
    }
}

