/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.storage.shelf;

import java.util.EnumSet;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.PartSlot;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import pl.asie.charset.lib.Properties;
import pl.asie.charset.lib.multipart.PartSlab;

public class PartShelf
extends PartSlab {
    protected static final AxisAlignedBB[] BOXES = new AxisAlignedBB[8];
    protected final ItemStackHandler inventory = new ItemStackHandler(4);
    protected EnumFacing facing = EnumFacing.NORTH;

    public IBlockState getActualState(IBlockState state) {
        return state.func_177226_a((IProperty)PartSlab.IS_TOP, (Comparable)Boolean.valueOf(this.isTop())).func_177226_a((IProperty)Properties.FACING4, (Comparable)this.facing);
    }

    public BlockStateContainer createBlockState() {
        return new BlockStateContainer((Block)MCMultiPartMod.multipart, new IProperty[]{PartSlab.IS_TOP, Properties.FACING4});
    }

    public ResourceLocation getModelPath() {
        return new ResourceLocation("charsetstorage:shelf");
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74782_a("items", (NBTBase)this.inventory.serializeNBT());
        nbt.func_74774_a("facing", (byte)this.facing.ordinal());
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("items")) {
            this.inventory.deserializeNBT(nbt.func_74775_l("items"));
        }
        if (nbt.func_74764_b("facing")) {
            this.facing = EnumFacing.func_82600_a((int)nbt.func_74771_c("facing"));
            if (this.facing == null || this.facing.func_176740_k() == EnumFacing.Axis.Y) {
                this.facing = EnumFacing.NORTH;
            }
        } else {
            this.facing = EnumFacing.NORTH;
        }
    }

    @Override
    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        buf.writeByte(this.facing.ordinal());
    }

    @Override
    public void readUpdatePacket(PacketBuffer buf) {
        super.readUpdatePacket(buf);
        this.facing = EnumFacing.func_82600_a((int)buf.readByte());
    }

    @Override
    public AxisAlignedBB getBox() {
        return BOXES[this.facing.ordinal() - 2 + (this.isTop ? 4 : 0)];
    }

    @Override
    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.getFaceSlot((EnumFacing)this.facing));
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (this.facing == facing || (this.isTop ? facing == EnumFacing.UP : facing == EnumFacing.DOWN));
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventory);
        }
        return null;
    }

    static {
        for (int i = 0; i < 16; i += 8) {
            int j = i >> 1;
            PartShelf.BOXES[0 + j] = new AxisAlignedBB(0.0, (double)(i + 1) / 16.0, 0.75, 1.0, (double)(i + 6) / 16.0, 1.0);
            PartShelf.BOXES[1 + j] = new AxisAlignedBB(0.0, (double)(i + 1) / 16.0, 0.0, 1.0, (double)(i + 6) / 16.0, 0.25);
            PartShelf.BOXES[2 + j] = new AxisAlignedBB(0.75, (double)(i + 1) / 16.0, 0.0, 1.0, (double)(i + 6) / 16.0, 1.0);
            PartShelf.BOXES[3 + j] = new AxisAlignedBB(0.0, (double)(i + 1) / 16.0, 0.0, 0.25, (double)(i + 6) / 16.0, 1.0);
        }
    }
}

