/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.tweaks;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import pl.asie.charset.tweaks.Tweak;

public class TweakDoubleDoors
extends Tweak {
    private final Set<BlockDoor> allowedDoors = new HashSet<BlockDoor>();

    public TweakDoubleDoors() {
        super("tweaks", "doubleDoorAutoOpen", "Make double doors open both at the same time when one is opened.", true);
    }

    @Override
    public boolean init() {
        this.allowedDoors.add(Blocks.field_180410_as);
        this.allowedDoors.add(Blocks.field_180412_aq);
        this.allowedDoors.add(Blocks.field_180411_ar);
        this.allowedDoors.add(Blocks.field_180413_ao);
        this.allowedDoors.add(Blocks.field_180414_ap);
        this.allowedDoors.add(Blocks.field_180409_at);
        return true;
    }

    @Override
    public void enable() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void disable() {
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    private IBlockState getActualState(IBlockAccess access, BlockPos pos) {
        IBlockState state = access.func_180495_p(pos);
        return state.func_185899_b(access, pos);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onPlayerInteract(PlayerInteractEvent.RightClickBlock event) {
        if (event.getEntityPlayer().func_70093_af() || event.getWorld().field_72995_K) {
            return;
        }
        IBlockState state = this.getActualState((IBlockAccess)event.getWorld(), event.getPos());
        Block block = state.func_177230_c();
        if (!(block instanceof BlockDoor) || !this.allowedDoors.contains(block)) {
            return;
        }
        BlockDoor door = (BlockDoor)block;
        EnumFacing direction = (EnumFacing)state.func_177229_b((IProperty)BlockDoor.field_176520_a);
        boolean isOpen = (Boolean)state.func_177229_b((IProperty)BlockDoor.field_176519_b);
        BlockDoor.EnumHingePosition isMirrored = (BlockDoor.EnumHingePosition)state.func_177229_b((IProperty)BlockDoor.field_176521_M);
        BlockPos pos = event.getPos().func_177972_a(isMirrored == BlockDoor.EnumHingePosition.RIGHT ? direction.func_176735_f() : direction.func_176746_e());
        IBlockState other = this.getActualState((IBlockAccess)event.getWorld(), pos);
        if (other.func_177230_c() == door && other.func_177229_b((IProperty)BlockDoor.field_176520_a) == direction && (Boolean)other.func_177229_b((IProperty)BlockDoor.field_176519_b) == isOpen && other.func_177229_b((IProperty)BlockDoor.field_176521_M) != isMirrored) {
            door.func_180639_a(event.getWorld(), pos, other, event.getEntityPlayer(), event.getHand(), event.getItemStack(), event.getFace(), 0.0f, 0.0f, 0.0f);
        }
    }
}

