/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.tweaks.shard;

import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.oredict.OreDictionary;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.tweaks.ModCharsetTweaks;
import pl.asie.charset.tweaks.Tweak;
import pl.asie.charset.tweaks.shard.ItemShard;

public class TweakGlassShards
extends Tweak {
    public static ItemShard shardItem;

    public TweakGlassShards() {
        super("additions", "glassShards", "Adds glass shards which drop from glass in a manner similar to glowstone dust.", !Loader.isModLoaded((String)"glass_shards"));
    }

    @Override
    public boolean canTogglePostLoad() {
        return false;
    }

    @Override
    public boolean preInit() {
        shardItem = new ItemShard();
        GameRegistry.register((IForgeRegistryEntry)shardItem.setRegistryName("shard"));
        ModCharsetLib.proxy.registerItemModel(shardItem, 0, "charsettweaks:shard");
        for (int i = 1; i <= 16; ++i) {
            ModCharsetLib.proxy.registerItemModel(shardItem, i, "charsettweaks:shard#inventory_colored");
        }
        return true;
    }

    @Override
    public boolean init() {
        ModCharsetTweaks.proxy.initShardsTweakClient();
        MinecraftForge.EVENT_BUS.register((Object)this);
        OreDictionary.registerOre((String)"shardGlass", (ItemStack)new ItemStack((Item)shardItem, 1, Short.MAX_VALUE));
        GameRegistry.addShapedRecipe((ItemStack)new ItemStack(Blocks.field_150359_w), (Object[])new Object[]{"gg", "gg", Character.valueOf('g'), new ItemStack((Item)shardItem, 1, 0)});
        OreDictionary.registerOre((String)"shardGlassColorless", (ItemStack)new ItemStack((Item)shardItem, 1, 0));
        for (int i = 0; i < 16; ++i) {
            GameRegistry.addShapedRecipe((ItemStack)new ItemStack((Block)Blocks.field_150399_cn, 1, i), (Object[])new Object[]{"gg", "gg", Character.valueOf('g'), new ItemStack((Item)shardItem, 1, i + 1)});
            OreDictionary.registerOre((String)ColorUtils.getOreDictEntry("shardGlass", i), (ItemStack)new ItemStack((Item)shardItem, 1, i + 1));
        }
        return true;
    }

    @SubscribeEvent
    public void onBlockHarvest(BlockEvent.HarvestDropsEvent event) {
        if (event.getDrops().size() > 0) {
            return;
        }
        Block block = event.getState().func_177230_c();
        boolean isPane = false;
        int md = 0;
        if (block != Blocks.field_150359_w) {
            if (block == Blocks.field_150399_cn) {
                md = 1 + block.func_176201_c(event.getState());
            } else if (block == Blocks.field_150410_aZ) {
                isPane = true;
            } else if (block == Blocks.field_150397_co) {
                isPane = true;
                md = 1 + block.func_176201_c(event.getState());
            } else {
                return;
            }
        }
        if (event.getDropChance() <= 0.0f) {
            event.setDropChance(1.0f);
        }
        if (isPane) {
            float rand = event.getWorld().field_73012_v.nextFloat();
            if (rand >= 0.5f) {
                event.getDrops().add(new ItemStack((Item)shardItem, 1, md));
            }
        } else {
            int rand = event.getWorld().field_73012_v.nextInt(4) + 1;
            event.getDrops().add(new ItemStack((Item)shardItem, rand, md));
        }
    }
}

