/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.wires;

import mcmultipart.multipart.IPartFactory;
import mcmultipart.multipart.MultipartRegistry;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.ModCharsetLib;
import pl.asie.charset.lib.network.PacketRegistry;
import pl.asie.charset.lib.recipe.RecipeCharset;
import pl.asie.charset.lib.wires.RecipeObjectWire;
import pl.asie.charset.lib.wires.RecipeResultWire;
import pl.asie.charset.lib.wires.WireFactory;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.wires.ProxyCommon;
import pl.asie.charset.wires.RecipeObjectSignalWire;
import pl.asie.charset.wires.logic.WireMigrationProvider;
import pl.asie.charset.wires.logic.WireSignalFactory;

@Mod(modid="CharsetWires", name="+", version="0.3.0-pre15", dependencies="required-after:Forge@[11.15.0.1715,);required-after:CharsetLib@0.3.0-pre15;required-after:mcmultipart", updateJSON="http://charset.asie.pl/update.json", acceptedMinecraftVersions="[1.10]")
public class ModCharsetWires {
    public static final String MODID = "CharsetWires";
    public static final String NAME = "+";
    public static final String VERSION = "0.3.0-pre15";
    public static PacketRegistry packet;
    @SidedProxy(clientSide="pl.asie.charset.wires.ProxyClient", serverSide="pl.asie.charset.wires.ProxyCommon")
    public static ProxyCommon proxy;
    public static WireFactory[] wireFactories;
    private Configuration config;
    private boolean addWireRecipe;
    private boolean addInsulatedWireRecipe;
    private boolean addBundledWireRecipe;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        int i;
        if (!ModCharsetLib.moduleEnabled("wires")) {
            return;
        }
        this.config = new Configuration(ModCharsetLib.instance.getConfigFile("wires.cfg"));
        this.addWireRecipe = this.config.getBoolean("enableWireRecipe", "recipes", true, "");
        this.addInsulatedWireRecipe = this.config.getBoolean("enableInsulatedWireRecipe", "recipes", true, "");
        this.addBundledWireRecipe = this.config.getBoolean("enabledBundledWireRecipe", "recipes", true, "");
        this.config.save();
        ModCharsetWires.wireFactories[0] = new WireSignalFactory(WireType.NORMAL, -1).setRegistryName(new ResourceLocation("charsetwires:rsWireN"));
        for (i = 0; i < 16; ++i) {
            ModCharsetWires.wireFactories[i + 1] = new WireSignalFactory(WireType.INSULATED, i).setRegistryName(new ResourceLocation("charsetwires:rsWireI." + i));
        }
        ModCharsetWires.wireFactories[17] = new WireSignalFactory(WireType.BUNDLED, -1).setRegistryName(new ResourceLocation("charsetwires:rsWireB"));
        for (i = 0; i < 18; ++i) {
            WireManager.register(wireFactories[i]);
        }
        MultipartRegistry.registerPartFactory((IPartFactory.IAdvancedPartFactory)new WireMigrationProvider(), (String[])new String[]{"charsetwires:wire"});
        MinecraftForge.EVENT_BUS.register((Object)proxy);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        if (!ModCharsetLib.moduleEnabled("wires")) {
            return;
        }
        packet = new PacketRegistry(MODID);
        if (this.addWireRecipe) {
            GameRegistry.addRecipe((IRecipe)RecipeCharset.Builder.create(new RecipeResultWire(wireFactories[0], false, 8)).shaped(" r ", "rir", " r ", Character.valueOf('r'), "dustRedstone", Character.valueOf('i'), "ingotIron").build());
        }
        if (this.addInsulatedWireRecipe) {
            for (int i = 0; i < 16; ++i) {
                GameRegistry.addRecipe((IRecipe)RecipeCharset.Builder.create(new RecipeResultWire(wireFactories[i + 1], false, 8)).shaped("ddd", "dwd", "ddd", Character.valueOf('d'), new RecipeObjectWire(wireFactories[0], false), Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, i)).build());
                GameRegistry.addRecipe((IRecipe)RecipeCharset.Builder.create(new RecipeResultWire(wireFactories[i + 1], true, 8)).shaped("ddd", "dwd", "ddd", Character.valueOf('d'), new RecipeObjectWire(wireFactories[0], true), Character.valueOf('w'), new ItemStack(Blocks.field_150325_L, 1, i)).build());
            }
        }
        if (this.addBundledWireRecipe) {
            GameRegistry.addRecipe((IRecipe)RecipeCharset.Builder.create(new RecipeResultWire(wireFactories[17], false, 1)).shaped("sws", "www", "sws", Character.valueOf('w'), new RecipeObjectSignalWire(WireType.INSULATED, false), Character.valueOf('s'), Items.field_151007_F).build());
            GameRegistry.addRecipe((IRecipe)RecipeCharset.Builder.create(new RecipeResultWire(wireFactories[17], true, 1)).shaped("sws", "www", "sws", Character.valueOf('w'), new RecipeObjectSignalWire(WireType.INSULATED, true), Character.valueOf('s'), Items.field_151007_F).build());
        }
    }

    static {
        wireFactories = new WireFactory[18];
    }
}

