/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.wires;

import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.recipe.IRecipeObject;
import pl.asie.charset.lib.wires.ItemWire;
import pl.asie.charset.lib.wires.WireFactory;
import pl.asie.charset.lib.wires.WireManager;
import pl.asie.charset.wires.ModCharsetWires;
import pl.asie.charset.wires.logic.WireSignalFactory;

public class RecipeObjectSignalWire
implements IRecipeObject {
    private final WireType type;
    private final boolean freestanding;

    public RecipeObjectSignalWire(WireType type, boolean freestanding) {
        this.type = type;
        this.freestanding = freestanding;
    }

    @Override
    public boolean matches(ItemStack stack) {
        WireFactory factory;
        if (stack != null && stack.func_77973_b() == WireManager.ITEM && (factory = WireManager.ITEM.getFactory(stack)) instanceof WireSignalFactory) {
            WireSignalFactory signalFactory = (WireSignalFactory)factory;
            if (this.type == null || signalFactory.type == this.type) {
                boolean targetFreestanding = ItemWire.isFreestanding(stack);
                return this.freestanding ? targetFreestanding : !targetFreestanding;
            }
        }
        return false;
    }

    @Override
    public Object preview() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (WireFactory f : ModCharsetWires.wireFactories) {
            if (((WireSignalFactory)f).type != this.type) continue;
            stacks.add(WireManager.ITEM.getStack(f, this.freestanding));
        }
        return stacks;
    }
}

