/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.wires.logic;

import java.util.Arrays;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.PartSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import pl.asie.charset.api.wires.IBundledEmitter;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.charset.api.wires.IWire;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.wires.WireUtils;
import pl.asie.charset.wires.logic.PartWireSignalBase;

public class PartWireBundled
extends PartWireSignalBase
implements IBundledReceiver,
IBundledEmitter {
    private int[] signalLevel = new int[16];
    private byte[] signalValue = new byte[16];

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getRenderColor() {
        return -1;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.signalLevel = nbt.func_74759_k("s");
        if (this.signalLevel == null || this.signalLevel.length != 16) {
            this.signalLevel = new int[16];
        }
        for (int i = 0; i < 16; ++i) {
            this.signalValue[i] = (byte)(this.signalLevel[i] >> 8);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74783_a("s", this.signalLevel);
        return nbt;
    }

    /*
     * WARNING - void declaration
     */
    private void propagate(int color, byte[][] nValues) {
        EnumFacing facing;
        int n;
        int maxSignal = 0;
        int[] neighborLevel = new int[7];
        boolean[] isWire = new boolean[7];
        PartWireSignalBase.PROPAGATING = true;
        if (this.internalConnections > 0) {
            for (WireFace wireFace : WireFace.VALUES) {
                if (!this.connectsInternal(wireFace)) continue;
                isWire[wireFace.ordinal()] = true;
                neighborLevel[wireFace.ordinal()] = WireUtils.getBundledWireLevel(this.getContainer(), wireFace, color);
            }
        }
        for (WireFace wireFace : EnumFacing.field_82609_l) {
            if (this.connectsExternal((EnumFacing)wireFace)) {
                if (nValues[wireFace.ordinal()] != null) {
                    int v = nValues[wireFace.ordinal()][color] << 8;
                    if (v == 0) continue;
                    neighborLevel[wireFace.ordinal()] = v | 0xFF;
                    continue;
                }
                IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a((EnumFacing)wireFace));
                if (container == null) continue;
                isWire[wireFace.ordinal()] = true;
                neighborLevel[wireFace.ordinal()] = WireUtils.getBundledWireLevel(container, this.location, color);
                continue;
            }
            if (!this.connectsCorner((EnumFacing)wireFace)) continue;
            BlockPos cornerPos = this.getPos().func_177972_a((EnumFacing)wireFace).func_177972_a(this.location.facing);
            IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)cornerPos);
            if (container == null) continue;
            isWire[wireFace.ordinal()] = true;
            neighborLevel[wireFace.ordinal()] = WireUtils.getBundledWireLevel(container, WireFace.get(wireFace.func_176734_d()), color);
        }
        PartWireSignalBase.PROPAGATING = false;
        int newSignal = 0;
        for (int j = 0; j < 7; ++j) {
            if (neighborLevel[j] > maxSignal) {
                maxSignal = neighborLevel[j];
            }
            if (isWire[j] || neighborLevel[j] <= newSignal) continue;
            newSignal = neighborLevel[j];
        }
        if (DEBUG) {
            System.out.println("[" + color + "] Levels: " + Arrays.toString(neighborLevel));
        }
        if (maxSignal > this.signalLevel[color] && maxSignal > 1 && (((newSignal = maxSignal - 1) & 0xFF) == 0 || (newSignal & 0xFF) == 255)) {
            newSignal = 0;
        }
        if (newSignal == this.signalLevel[color]) {
            return;
        }
        this.signalLevel[color] = newSignal;
        this.signalValue[color] = (byte)(newSignal >> 8);
        if (newSignal == 0) {
            void var9_16;
            WireFace[] wireFaceArray = WireFace.VALUES;
            n = wireFaceArray.length;
            boolean bl = false;
            while (var9_16 < n) {
                WireFace nLoc = wireFaceArray[var9_16];
                if (this.connectsInternal(nLoc)) {
                    if (neighborLevel[nLoc.ordinal()] > 0) {
                        WireUtils.getWire(this.getContainer(), nLoc).onSignalChanged(color);
                    }
                } else if (nLoc != WireFace.CENTER) {
                    facing = nLoc.facing;
                    if (this.connectsExternal(facing)) {
                        IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a(facing));
                        if (container == null || WireUtils.getWire(container, this.location) == null || neighborLevel[facing.ordinal()] > 0) {
                            this.propagateNotify(facing, color);
                        }
                    } else if (this.connectsCorner(facing) && neighborLevel[facing.ordinal()] > 0) {
                        this.propagateNotifyCorner(this.location.facing, facing, color);
                    }
                }
                ++var9_16;
            }
        } else {
            void var9_18;
            WireFace[] wireFaceArray = WireFace.VALUES;
            n = wireFaceArray.length;
            boolean bl = false;
            while (var9_18 < n) {
                WireFace nLoc = wireFaceArray[var9_18];
                if (neighborLevel[nLoc.ordinal()] < newSignal - 1 || neighborLevel[nLoc.ordinal()] > newSignal + 1) {
                    if (this.connectsInternal(nLoc)) {
                        WireUtils.getWire(this.getContainer(), nLoc).onSignalChanged(color);
                    } else if (nLoc != WireFace.CENTER) {
                        facing = nLoc.facing;
                        if (this.connectsExternal(facing)) {
                            this.propagateNotify(facing, color);
                        } else if (this.connectsCorner(facing)) {
                            this.propagateNotifyCorner(this.location.facing, facing, color);
                        }
                    }
                }
                ++var9_18;
            }
        }
        this.finishPropagation();
    }

    @Override
    public void propagate(int color) {
        if (DEBUG) {
            System.out.println("--- B! PROPAGATE " + this.getPos().toString() + " " + this.location.name() + " --- " + color);
            System.out.println("ConnectionCache: " + Integer.toBinaryString(this.internalConnections) + " " + Integer.toBinaryString(this.externalConnections) + " " + Integer.toBinaryString(this.cornerConnections));
        }
        byte[][] nValues = new byte[6][];
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            if (!this.connectsExternal(facing)) continue;
            BlockPos posFacing = this.getPos().func_177972_a(facing);
            IBundledEmitter emitter = null;
            IMultipartContainer container = MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)posFacing);
            if (container != null) {
                if (container.hasCapability(Capabilities.BUNDLED_EMITTER, WireUtils.getSlotForFace(this.location), facing.func_176734_d())) {
                    emitter = (IBundledEmitter)container.getCapability(Capabilities.BUNDLED_EMITTER, WireUtils.getSlotForFace(this.location), facing.func_176734_d());
                }
            } else {
                TileEntity tile = this.getWorld().func_175625_s(posFacing);
                if (tile.hasCapability(Capabilities.BUNDLED_EMITTER, facing.func_176734_d())) {
                    emitter = (IBundledEmitter)tile.getCapability(Capabilities.BUNDLED_EMITTER, facing.func_176734_d());
                }
            }
            if (emitter == null || emitter instanceof IWire) continue;
            nValues[facing.ordinal()] = emitter.getBundledSignal();
        }
        if (color < 0) {
            for (int i = 0; i < 16; ++i) {
                this.propagate(i, nValues);
            }
        } else {
            this.propagate(color, nValues);
        }
    }

    @Override
    protected void onSignalChanged(int color) {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.propagate(color);
        }
    }

    @Override
    public int getBundledSignalLevel(int i) {
        return this.signalLevel[i & 0xF];
    }

    @Override
    public int getSignalLevel() {
        return 0;
    }

    @Override
    public int getRedstoneLevel() {
        return 0;
    }

    @Override
    public byte[] getBundledSignal() {
        return this.signalValue;
    }

    @Override
    public void onBundledInputChange() {
        this.scheduleLogicUpdate();
    }

    public boolean hasCapability(Capability<?> capability, PartSlot partSlot, EnumFacing face) {
        if (capability == Capabilities.BUNDLED_RECEIVER) {
            return partSlot == WireUtils.getSlotForFace(this.location) ? this.connects(face) : false;
        }
        if (capability == Capabilities.BUNDLED_EMITTER) {
            return partSlot == WireUtils.getSlotForFace(this.location) ? this.connects(face) : false;
        }
        return false;
    }

    public <T> T getCapability(Capability<T> capability, PartSlot partSlot, EnumFacing face) {
        if (!this.hasCapability(capability, partSlot, face)) {
            return null;
        }
        if (capability == Capabilities.BUNDLED_RECEIVER) {
            return (T)this;
        }
        if (capability == Capabilities.BUNDLED_EMITTER) {
            return (T)this;
        }
        return null;
    }
}

