/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.charset.wires.logic;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import java.util.Objects;
import mcmultipart.MCMultiPartMod;
import mcmultipart.multipart.IRedstonePart;
import mcmultipart.multipart.MultipartHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import pl.asie.charset.api.wires.IBundledReceiver;
import pl.asie.charset.api.wires.IRedstoneReceiver;
import pl.asie.charset.api.wires.IWire;
import pl.asie.charset.api.wires.WireFace;
import pl.asie.charset.api.wires.WireType;
import pl.asie.charset.lib.Capabilities;
import pl.asie.charset.lib.utils.ColorUtils;
import pl.asie.charset.lib.utils.MultipartUtils;
import pl.asie.charset.lib.utils.RedstoneUtils;
import pl.asie.charset.lib.wires.PartWire;
import pl.asie.charset.wires.WireUtils;
import pl.asie.charset.wires.logic.WireSignalFactory;

public abstract class PartWireSignalBase
extends PartWire
implements IRedstonePart.ISlottedRedstonePart,
IWire {
    public static boolean DEBUG = false;
    public static boolean PROPAGATING = false;
    public static boolean WIRES_CONNECT_REDSTONE = true;
    private final EnumSet<EnumFacing> propagationDirs = EnumSet.noneOf(EnumFacing.class);
    private int color = -1;

    public PartWireSignalBase() {
        this.scheduleConnectionUpdate();
    }

    public int getColor() {
        return this.color;
    }

    protected void setColor(int color) {
        this.color = color;
    }

    protected WireSignalFactory getSignalFactory() {
        return (WireSignalFactory)this.getFactory();
    }

    protected abstract void onSignalChanged(int var1);

    @Override
    protected void logicUpdate() {
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.onSignalChanged(-1);
        }
    }

    @Override
    public String getDisplayName() {
        String name = "";
        switch (this.getWireType()) {
            case NORMAL: {
                name = I18n.func_74838_a((String)"tile.charset.wire.name");
                break;
            }
            case INSULATED: {
                name = String.format(I18n.func_74838_a((String)"tile.charset.wire.insulated.name"), I18n.func_74838_a((String)ColorUtils.getLangEntry("charset.color.", this.color)));
                break;
            }
            case BUNDLED: {
                name = I18n.func_74838_a((String)"tile.charset.wire.bundled.name");
            }
        }
        if (this.location == WireFace.CENTER) {
            name = String.format(I18n.func_74838_a((String)"tile.charset.wire.freestanding.name"), name);
        }
        return name;
    }

    @Override
    public boolean calculateConnectionWire(PartWire wire) {
        if (super.calculateConnectionWire(wire)) {
            return true;
        }
        if (!(wire instanceof PartWireSignalBase)) {
            return false;
        }
        PartWireSignalBase sWire = (PartWireSignalBase)wire;
        switch (this.getSignalFactory().type) {
            case NORMAL: {
                return sWire.getWireType() != WireType.BUNDLED;
            }
            case INSULATED: {
                return sWire.getWireType() != WireType.INSULATED;
            }
            case BUNDLED: {
                return sWire.getWireType() != WireType.NORMAL;
            }
        }
        return false;
    }

    @Override
    public boolean calculateConnectionNonWire(BlockPos pos, EnumFacing direction) {
        if (this.getSignalFactory().type == WireType.BUNDLED) {
            if (MultipartUtils.hasCapability(Capabilities.BUNDLED_EMITTER, this.getWorld(), pos, WireUtils.getSlotForFace(this.location), direction)) {
                return true;
            }
            if (MultipartUtils.hasCapability(Capabilities.BUNDLED_RECEIVER, this.getWorld(), pos, WireUtils.getSlotForFace(this.location), direction)) {
                return true;
            }
        } else {
            if (MultipartUtils.hasCapability(Capabilities.REDSTONE_EMITTER, this.getWorld(), pos, WireUtils.getSlotForFace(this.location), direction)) {
                return true;
            }
            if (MultipartUtils.hasCapability(Capabilities.REDSTONE_RECEIVER, this.getWorld(), pos, WireUtils.getSlotForFace(this.location), direction)) {
                return true;
            }
            IBlockState connectingState = this.getWorld().func_180495_p(pos);
            Block connectingBlock = connectingState.func_177230_c();
            if (this.location == WireFace.CENTER && !connectingBlock.isSideSolid(connectingState, (IBlockAccess)this.getWorld(), pos, direction)) {
                return false;
            }
            WIRES_CONNECT_REDSTONE = false;
            boolean connectRS = RedstoneUtils.canConnectFace((IBlockAccess)this.getWorld(), pos, connectingState, direction.func_176734_d(), this.location.facing);
            WIRES_CONNECT_REDSTONE = true;
            if (connectRS) {
                return true;
            }
        }
        return false;
    }

    public abstract void propagate(int var1);

    public abstract int getSignalLevel();

    public abstract int getRedstoneLevel();

    @Override
    public void writeUpdatePacket(PacketBuffer buf) {
        super.writeUpdatePacket(buf);
        buf.writeByte(this.color);
    }

    @Override
    public void handlePacket(ByteBuf buf) {
        super.handlePacket(buf);
        this.color = buf.readByte();
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        if (nbt.func_74764_b("col")) {
            this.color = nbt.func_74771_c("col");
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (this.color != -1) {
            nbt.func_74774_a("col", (byte)this.color);
        }
        return super.writeToNBT(nbt);
    }

    @Override
    protected void neighborUpdate(int i) {
        for (int j = 0; j < 6; ++j) {
            if ((i & 1 << j) == 0) continue;
            EnumFacing facing = EnumFacing.func_82600_a((int)j);
            TileEntity tile = this.getWorld().func_175625_s(this.getPos().func_177972_a(facing));
            if (tile == null) continue;
            if (this.getSignalFactory().type == WireType.BUNDLED) {
                if (!tile.hasCapability(Capabilities.BUNDLED_RECEIVER, facing.func_176734_d())) continue;
                ((IBundledReceiver)tile.getCapability(Capabilities.BUNDLED_RECEIVER, facing.func_176734_d())).onBundledInputChange();
                continue;
            }
            if (!tile.hasCapability(Capabilities.REDSTONE_RECEIVER, facing.func_176734_d())) continue;
            ((IRedstoneReceiver)tile.getCapability(Capabilities.REDSTONE_RECEIVER, facing.func_176734_d())).onRedstoneInputChange();
        }
        super.neighborUpdate(i);
    }

    protected void propagateNotifyCorner(EnumFacing side, EnumFacing direction, int color) {
        PartWireSignalBase wire = WireUtils.getWire(MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a(side).func_177972_a(direction)), WireFace.get(direction.func_176734_d()));
        if (wire != null) {
            wire.onSignalChanged(color);
        }
    }

    protected void propagateNotify(EnumFacing facing, int color) {
        PartWireSignalBase wire = WireUtils.getWire(MultipartHelper.getPartContainer((IBlockAccess)this.getWorld(), (BlockPos)this.getPos().func_177972_a(facing)), this.location);
        if (wire != null) {
            wire.onSignalChanged(color);
        } else {
            this.propagationDirs.add(facing);
        }
    }

    protected void finishPropagation() {
        for (EnumFacing facing : this.propagationDirs) {
            TileEntity nt = this.getWorld().func_175625_s(this.getPos().func_177972_a(facing));
            boolean found = false;
            if (nt != null) {
                if (this.getSignalFactory().type == WireType.BUNDLED) {
                    if (nt.hasCapability(Capabilities.BUNDLED_RECEIVER, facing.func_176734_d())) {
                        ((IBundledReceiver)nt.getCapability(Capabilities.BUNDLED_RECEIVER, facing.func_176734_d())).onBundledInputChange();
                        found = true;
                    }
                } else if (nt.hasCapability(Capabilities.REDSTONE_RECEIVER, facing.func_176734_d())) {
                    ((IRedstoneReceiver)nt.getCapability(Capabilities.REDSTONE_RECEIVER, facing.func_176734_d())).onRedstoneInputChange();
                    found = true;
                }
            }
            if (this.getSignalFactory().type == WireType.BUNDLED || found) continue;
            this.getWorld().func_180496_d(this.getPos().func_177972_a(facing), (Block)MCMultiPartMod.multipart);
        }
        this.propagationDirs.clear();
    }

    public int getBundledSignalLevel(int i) {
        return 0;
    }

    public boolean canConnectRedstone(EnumFacing facing) {
        return WIRES_CONNECT_REDSTONE && this.getSignalFactory().type != WireType.BUNDLED && this.connectsExternal(facing);
    }

    public int getWeakSignal(EnumFacing facing) {
        if (!PROPAGATING && this.connectsWeak(facing)) {
            return this.getRedstoneLevel();
        }
        return 0;
    }

    public boolean connectsWeak(EnumFacing facing) {
        if (this.getSignalFactory().type == WireType.BUNDLED) {
            return false;
        }
        if (this.location.facing == facing) {
            return true;
        }
        return this.connects(facing) || this.getSignalFactory().type == WireType.NORMAL;
    }

    @Override
    public WireType getWireType() {
        return this.getSignalFactory().type;
    }

    public int getStrongSignal(EnumFacing facing) {
        if (this.getSignalFactory().type == WireType.NORMAL && this.location.facing == facing) {
            return this.getRedstoneLevel();
        }
        return 0;
    }

    @Override
    public boolean renderEquals(PartWire other) {
        return super.renderEquals(other) && (this.getWireType() == WireType.INSULATED || ((PartWireSignalBase)other).getRedstoneLevel() == this.getRedstoneLevel());
    }

    @Override
    public int renderHashCode() {
        return Objects.hash(super.renderHashCode(), this.getWireType() == WireType.INSULATED ? 0 : this.getRedstoneLevel());
    }
}

