/*
 * Decompiled with CFR 0.152.
 */
package at.feldim2425.moreoverlays.itemsearch;

import at.feldim2425.moreoverlays.MoreOverlays;
import at.feldim2425.moreoverlays.Proxy;
import at.feldim2425.moreoverlays.api.itemsearch.IViewSlot;
import at.feldim2425.moreoverlays.api.itemsearch.SlotHandler;
import at.feldim2425.moreoverlays.config.Config;
import at.feldim2425.moreoverlays.itemsearch.JeiModule;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class GuiHandler {
    private static final float OVERLAY_ZLEVEL = 299.0f;
    private static final int TEXT_FADEOUT = 20;
    private static boolean enabled = false;
    private static List<ItemStack> itemCache = null;
    private static String lastFilterText = "";
    private static boolean emptyFilter = true;
    private static List<String> tooltip = new ArrayList<String>();
    private static BiMap<Integer, IViewSlot> views = HashBiMap.create();
    private static String text = I18n.func_74838_a((String)"gui.moreoverlays.search.disabled");
    private static int highlightTicks = 0;
    private int txtPosY = 0;
    private boolean isCreative = false;
    private boolean handleTooltip = false;
    private int guiOffsetX = 0;
    private int guiOffsetY = 0;

    public static void init() {
        if (Proxy.isJeiInstalled()) {
            MinecraftForge.EVENT_BUS.register((Object)new GuiHandler());
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (!this.canShowIn(event.getGui())) {
            return;
        }
        highlightTicks = 0;
        this.txtPosY = event.getGui().field_146295_m - 19 + (16 - Minecraft.func_71410_x().field_71466_p.field_78288_b) / 2;
        GuiContainer gui = (GuiContainer)event.getGui();
        try {
            Field left = gui.getClass().getField("field_147003_i");
            left.setAccessible(true);
            this.guiOffsetX = left.getInt(gui);
            Field top = gui.getClass().getField("field_147009_r");
            top.setAccessible(true);
            this.guiOffsetY = top.getInt(gui);
        }
        catch (IllegalAccessException e) {
            MoreOverlays.logger.error("Something went wrong. Tried to load gui coords with java reflection. Gui class: " + gui.getClass().getName());
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            try {
                Field left = gui.getClass().getField("guiLeft");
                left.setAccessible(true);
                this.guiOffsetX = left.getInt(gui);
                Field top = gui.getClass().getField("guiTop");
                top.setAccessible(true);
                this.guiOffsetY = top.getInt(gui);
            }
            catch (IllegalAccessException | NoSuchFieldException e1) {
                MoreOverlays.logger.error("Something went wrong. Tried to load gui coords with java reflection. Gui class: " + gui.getClass().getName());
                e1.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public void onGuiOpen(GuiOpenEvent event) {
        this.isCreative = event.getGui() instanceof GuiContainerCreative;
        text = I18n.func_74838_a((String)("gui.moreoverlays.search." + (enabled ? "enabled" : "disabled")));
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onTooltip(ItemTooltipEvent event) {
        if (enabled && !views.isEmpty() && this.handleTooltip) {
            tooltip.clear();
            tooltip.addAll(event.getToolTip());
            event.getToolTip().clear();
        }
    }

    @SubscribeEvent
    public void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (!this.canShowIn(event.getGui())) {
            return;
        }
        RenderHelper.func_74518_a();
        GlStateManager.func_179141_d();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!(!enabled && !Config.itemsearch_DisableText || highlightTicks <= 0 && Config.itemsearch_FadeoutText)) {
            int alpha = 255;
            if (Config.itemsearch_FadeoutText) {
                alpha = (int)((float)highlightTicks / 20.0f * 256.0f);
                alpha = Math.max(0, Math.min(255, alpha));
            }
            int width = Minecraft.func_71410_x().field_71466_p.func_78256_a(text);
            int color = 0xFFFFFF | alpha << 24;
            GlStateManager.func_179094_E();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            Minecraft.func_71410_x().field_71466_p.func_78276_b(text, (event.getGui().field_146294_l - width) / 2, this.txtPosY, color);
            GlStateManager.func_179084_k();
            GlStateManager.func_179121_F();
        }
        if (!enabled || this.isCreative || views == null || views.isEmpty()) {
            return;
        }
        GuiContainer gui = (GuiContainer)event.getGui();
        this.handleTooltip = gui.getSlotUnderMouse() != null;
        Tessellator tess = Tessellator.func_178181_a();
        VertexBuffer renderer = tess.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179090_x();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)0.0f, (float)0.5f);
        renderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (Map.Entry slot : views.entrySet()) {
            int px = ((IViewSlot)slot.getValue()).getRenderPosX(this.guiOffsetX, this.guiOffsetY);
            int py = ((IViewSlot)slot.getValue()).getRenderPosY(this.guiOffsetX, this.guiOffsetY);
            renderer.func_181662_b((double)(px + 16 + this.guiOffsetX), (double)(py + this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_181662_b((double)(px + this.guiOffsetX), (double)(py + this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_181662_b((double)(px + this.guiOffsetX), (double)(py + 16 + this.guiOffsetY), 299.0).func_181675_d();
            renderer.func_181662_b((double)(px + 16 + this.guiOffsetX), (double)(py + 16 + this.guiOffsetY), 299.0).func_181675_d();
        }
        tess.func_78381_a();
        GlStateManager.func_179098_w();
        GlStateManager.func_179121_F();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (!tooltip.isEmpty()) {
            GuiUtils.drawHoveringText(tooltip, (int)event.getMouseX(), (int)event.getMouseY(), (int)event.getGui().field_146294_l, (int)event.getGui().field_146295_m, (int)-1, (FontRenderer)Minecraft.func_71410_x().field_71466_p);
            tooltip.clear();
        }
        GlStateManager.func_179084_k();
    }

    private boolean canShowIn(GuiScreen gui) {
        return gui instanceof GuiContainer && !this.isCreative && ((GuiContainer)gui).field_147002_h != null && !((GuiContainer)gui).field_147002_h.field_75151_b.isEmpty();
    }

    private void checkSlots(GuiContainer container) {
        if (views == null) {
            views = HashBiMap.create();
        } else {
            views.clear();
        }
        for (Slot slot : container.field_147002_h.field_75151_b) {
            IViewSlot slotv = SlotHandler.INSTANCE.getViewSlot(container, slot);
            if (!slotv.canSearch() || this.isSearchedItem(slot.func_75211_c())) continue;
            views.forcePut((Object)slot.field_75222_d, (Object)slotv);
        }
    }

    private boolean isSearchedItem(ItemStack stack) {
        if (emptyFilter) {
            return true;
        }
        if (stack == null) {
            return false;
        }
        for (ItemStack stack1 : itemCache) {
            if (!stack1.func_77969_a(stack) && (stack1.func_77973_b() != stack.func_77973_b() || !stack1.func_77973_b().func_77645_m())) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || Minecraft.func_71410_x().field_71439_g == null || !this.canShowIn(Minecraft.func_71410_x().field_71462_r)) {
            return;
        }
        if (enabled && !JeiModule.overlay.getFilterText().equals(lastFilterText)) {
            lastFilterText = JeiModule.overlay.getFilterText();
            if (itemCache != null) {
                itemCache.clear();
            } else {
                itemCache = new ArrayList<ItemStack>();
            }
            JeiModule.filter.getItemList().forEach(itemElement -> itemCache.add(itemElement.getItemStack()));
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
        }
        if (enabled && Minecraft.func_71410_x().field_71462_r instanceof GuiContainer) {
            this.checkSlots((GuiContainer)Minecraft.func_71410_x().field_71462_r);
        } else if (views != null) {
            views.clear();
        }
        if (highlightTicks > 0) {
            --highlightTicks;
        }
    }

    public static void toggleMode() {
        boolean bl = enabled = !enabled;
        if (enabled) {
            lastFilterText = JeiModule.overlay.getFilterText();
            if (itemCache != null) {
                itemCache.clear();
            } else {
                itemCache = new ArrayList<ItemStack>();
            }
            JeiModule.filter.getItemList().forEach(itemElement -> itemCache.add(itemElement.getItemStack()));
            emptyFilter = lastFilterText.replace(" ", "").isEmpty();
            text = I18n.func_74838_a((String)"gui.moreoverlays.search.enabled");
        } else {
            lastFilterText = "";
            if (itemCache != null) {
                itemCache.clear();
            }
            text = I18n.func_74838_a((String)"gui.moreoverlays.search.disabled");
        }
        highlightTicks = 20;
    }
}

