/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common;

import com.google.common.collect.ObjectArrays;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.LoaderException;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import org.apache.logging.log4j.Level;

public class RegistryHelper {
    public static Block registerBlock(Block block, String registry, String unlocalized) {
        return RegistryHelper.registerBlock(block, ItemBlock.class, registry, unlocalized, new Object[0]);
    }

    public static Block registerBlock(Block block, Class<? extends ItemBlock> itemclass, String registry, String unlocalized, Object ... itemArgs) {
        ((Block)block.setRegistryName(registry)).func_149663_c(unlocalized);
        GameRegistry.register((IForgeRegistryEntry)block);
        if (itemclass != null) {
            try {
                Class[] argClasses = new Class[itemArgs.length + 1];
                argClasses[0] = Block.class;
                for (int idx = 1; idx < argClasses.length; ++idx) {
                    argClasses[idx] = itemArgs[idx - 1].getClass();
                }
                ItemBlock itemBlock = itemclass.getConstructor(argClasses).newInstance(ObjectArrays.concat((Object)block, (Object[])itemArgs));
                ((Item)itemBlock.setRegistryName(registry)).func_77655_b(unlocalized);
                GameRegistry.register((IForgeRegistryEntry)itemBlock);
            }
            catch (Exception e) {
                FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Caught an exception during block registration", (Object[])new Object[0]);
                throw new LoaderException((Throwable)e);
            }
        }
        return block;
    }

    public static Item registerItem(Item item, String registry, String unlocalized) {
        ((Item)item.setRegistryName(registry)).func_77655_b(unlocalized);
        GameRegistry.register((IForgeRegistryEntry)item);
        return item;
    }

    public static void registerTileEntity(Class<? extends TileEntity> tile, String id) {
        GameRegistry.registerTileEntity(tile, (String)id);
    }

    public static void registerTileEntityWithAlternatives(Class<? extends TileEntity> tile, String id, String ... alternatives) {
        GameRegistry.registerTileEntityWithAlternatives(tile, (String)id, (String[])alternatives);
    }

    public static Fluid registerFluid(Fluid fluid) {
        FluidRegistry.registerFluid((Fluid)fluid);
        return fluid;
    }

    public static SoundEvent registerSound(String id) {
        ResourceLocation name = new ResourceLocation(id);
        SoundEvent sound = new SoundEvent(name);
        sound.setRegistryName(name);
        GameRegistry.register((IForgeRegistryEntry)sound);
        return sound;
    }
}

