/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.inventory;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;
import shetiphian.core.common.inventory.IContainerCallback;

public class InventoryInternal
implements IInventory {
    protected final ItemStack[] contents;
    private final String invName;
    private final int stackLimit;
    private final TileEntity invOwner;

    public InventoryInternal(TileEntity invOwner, String invName, int invSize) {
        this(invOwner, invName, invSize, 64);
    }

    public InventoryInternal(TileEntity invOwner, String invName, int invSize, int invStackLimit) {
        this.contents = new ItemStack[invSize];
        this.invOwner = invOwner;
        this.invName = invName;
        this.stackLimit = invStackLimit;
    }

    public void writeToNBT(NBTTagCompound nbtTag) {
        this.writeToNBT(nbtTag, this.invName);
    }

    public void writeToNBT(NBTTagCompound nbtTag, String name) {
        NBTTagList listStacks = new NBTTagList();
        for (byte index = 0; index < this.contents.length; index = (byte)((byte)(index + 1))) {
            if (this.contents[index] == null || this.contents[index].field_77994_a <= 0) continue;
            NBTTagCompound entry = new NBTTagCompound();
            entry.func_74774_a("slot", index);
            this.contents[index].func_77955_b(entry);
            listStacks.func_74742_a((NBTBase)entry);
        }
        nbtTag.func_74782_a(name, (NBTBase)listStacks);
    }

    public void readFromNBT(NBTTagCompound nbtTag) {
        this.readFromNBT(nbtTag, this.invName);
    }

    public void readFromNBT(NBTTagCompound nbtTag, String name) {
        NBTTagList listStacks = nbtTag.func_150295_c(name, 10);
        for (int index = 0; index < listStacks.func_74745_c(); index = (int)((byte)(index + 1))) {
            byte slot;
            NBTTagCompound entry = listStacks.func_150305_b(index);
            byte by = slot = entry.func_74764_b("slot") ? entry.func_74771_c("slot") : entry.func_74771_c("Slot");
            if (!this.okSlotId(index)) continue;
            this.contents[slot] = ItemStack.func_77949_a((NBTTagCompound)entry);
        }
    }

    public ItemStack[] getContents() {
        return this.contents;
    }

    protected boolean okSlotId(int slotId) {
        return slotId > -1 && slotId < this.func_70302_i_();
    }

    public int func_70302_i_() {
        return this.contents.length;
    }

    public ItemStack func_70301_a(int slotId) {
        return this.okSlotId(slotId) ? this.contents[slotId] : null;
    }

    public ItemStack func_70298_a(int slotId, int amount) {
        if (this.okSlotId(slotId) && this.contents[slotId] != null) {
            if (this.contents[slotId].field_77994_a > amount) {
                ItemStack result = this.contents[slotId].func_77979_a(amount);
                this.func_70296_d();
                return result;
            }
            ItemStack stack = this.contents[slotId];
            this.func_70299_a(slotId, null);
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int slotId) {
        ItemStack returnStack = this.func_70301_a(slotId);
        this.func_70299_a(slotId, null);
        return returnStack;
    }

    public void func_70299_a(int slotId, ItemStack stack) {
        if (this.okSlotId(slotId)) {
            this.contents[slotId] = stack != null && stack.field_77994_a > this.func_70297_j_() ? stack.func_77979_a(this.func_70297_j_()) : stack;
            this.func_70296_d();
        }
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public void func_70296_d() {
        this.invOwner.func_70296_d();
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.invOwner instanceof IContainerCallback) {
            return ((IContainerCallback)this.invOwner).canInteractWith(player);
        }
        return this.invOwner != null && this.invOwner.func_145831_w().func_175625_s(this.invOwner.func_174877_v()) == this.invOwner && player.func_70092_e((double)this.invOwner.func_174877_v().func_177958_n() + 0.5, (double)this.invOwner.func_174877_v().func_177956_o() + 0.5, (double)this.invOwner.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.invOwner instanceof IContainerCallback) {
            ((IContainerCallback)this.invOwner).onContainerOpen(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.invOwner instanceof IContainerCallback) {
            ((IContainerCallback)this.invOwner).onContainerClosed(player);
        }
    }

    public boolean func_94041_b(int slotId, ItemStack stack) {
        return this.okSlotId(slotId);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public String func_70005_c_() {
        return this.invOwner.getClass().getName() + "." + this.invName;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }
}

