/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.item;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.handler.ConfigurationHandler;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.tile.TileEnderChest;
import codechicken.enderstorage.util.LogHelper;
import java.util.List;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemEnderPouch
extends Item {
    public ItemEnderPouch() {
        this.func_77625_d(1);
        this.func_77637_a(CreativeTabs.field_78029_e);
        this.func_77655_b("enderPouch");
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List<String> list, boolean extended) {
        Frequency freq = Frequency.fromItemStack(stack);
        if (freq.owner != null) {
            list.add(freq.owner);
        }
        list.add(String.format("%s/%s/%s", freq.getLocalizedLeft(), freq.getLocalizedMiddle(), freq.getLocalizedRight()));
    }

    public EnumActionResult onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEnderChest && player.func_70093_af()) {
            TileEnderChest chest = (TileEnderChest)tile;
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            NBTTagCompound frequencyTag = new NBTTagCompound();
            Frequency frequency = chest.frequency.copy();
            if (ConfigurationHandler.anarchyMode && !frequency.owner.equals(player.getDisplayNameString())) {
                frequency.setOwner(null);
            }
            frequency.writeNBT(frequencyTag);
            stack.func_77978_p().func_74782_a("Frequency", (NBTBase)frequencyTag);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (world.field_72995_K || player.func_70093_af()) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        Frequency frequency = Frequency.fromItemStack(stack);
        LogHelper.info(frequency.toString());
        ((EnderItemStorage)EnderStorageManager.instance(world.field_72995_K).getStorage(frequency, "item")).openSMPGui(player, stack.func_77977_a() + ".name");
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Deprecated
    public String getOwner(ItemStack stack) {
        return EnderStorageManager.getOwner(stack);
    }
}

