/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.network;

import codechicken.core.ServerUtils;
import codechicken.core.fluid.FluidUtils;
import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderLiquidStorage;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.util.ClientUtils;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class TankSynchroniser {
    private static HashMap<String, PlayerItemTankCache> playerItemTankStates;
    private static PlayerItemTankCache clientState;

    public static String key(Frequency freq) {
        return freq.toString();
    }

    public static int splitKeyF(String s) {
        return Integer.parseInt(s.substring(0, s.indexOf(124)));
    }

    public static String splitKeyS(String s) {
        return s.substring(s.indexOf(124) + 1, s.length());
    }

    public static void syncClient(Frequency freq, FluidStack liquid) {
        clientState.sync(freq, liquid);
    }

    public static FluidStack getClientLiquid(Frequency freq) {
        return clientState.getLiquid(freq);
    }

    public static void handleVisiblityPacket(EntityPlayerMP player, PacketCustom packet) {
        playerItemTankStates.get(player.func_70005_c_()).handleVisiblityPacket(packet);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        playerItemTankStates.put(event.player.func_70005_c_(), new PlayerItemTankCache((EntityPlayerMP)event.player));
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (playerItemTankStates != null) {
            playerItemTankStates.remove(event.player.func_70005_c_());
        }
    }

    @SubscribeEvent
    public void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        playerItemTankStates.put(event.player.func_70005_c_(), new PlayerItemTankCache((EntityPlayerMP)event.player));
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && playerItemTankStates != null) {
            for (Map.Entry<String, PlayerItemTankCache> entry : playerItemTankStates.entrySet()) {
                entry.getValue().update();
            }
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ClientUtils.inWorld()) {
            clientState.update();
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K && !ServerUtils.mc().func_71278_l()) {
            playerItemTankStates = null;
        }
    }

    @SubscribeEvent
    public void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K) {
            clientState = new PlayerItemTankCache();
        } else if (playerItemTankStates == null) {
            playerItemTankStates = new HashMap();
        }
    }

    public static class PlayerItemTankCache {
        private boolean client;
        private HashMap<String, PlayerItemTankState> tankStates = new HashMap();
        private HashSet<Frequency> b_visible;
        private HashSet<Frequency> a_visible;
        private EntityPlayerMP player;

        public PlayerItemTankCache(EntityPlayerMP player) {
            this.player = player;
            this.client = false;
        }

        public PlayerItemTankCache() {
            this.client = true;
            this.a_visible = new HashSet();
            this.b_visible = new HashSet();
        }

        public void track(Frequency freq, boolean t) {
            String key = TankSynchroniser.key(freq);
            PlayerItemTankState state = this.tankStates.get(key);
            if (state == null) {
                if (!t) {
                    return;
                }
                state = new PlayerItemTankState(this.player, (EnderLiquidStorage)EnderStorageManager.instance(false).getStorage(freq, "liquid"));
                this.tankStates.put(key, state);
            }
            state.setTracking(t);
        }

        public void sync(Frequency freq, FluidStack liquid) {
            String key = TankSynchroniser.key(freq);
            PlayerItemTankState state = this.tankStates.get(key);
            if (state == null) {
                state = new PlayerItemTankState();
                this.tankStates.put(key, state);
            }
            state.sync(liquid);
        }

        public void update() {
            for (Map.Entry<String, PlayerItemTankState> entry : this.tankStates.entrySet()) {
                entry.getValue().update(this.client);
            }
            if (this.client) {
                Sets.SetView new_visible = Sets.difference(this.a_visible, this.b_visible);
                Sets.SetView old_visible = Sets.difference(this.b_visible, this.a_visible);
                if (!new_visible.isEmpty() || !old_visible.isEmpty()) {
                    PacketCustom packet = new PacketCustom((Object)"ES", 1);
                    packet.writeShort(new_visible.size());
                    for (Frequency frequency : new_visible) {
                        packet.writeNBTTagCompound(frequency.toNBT());
                    }
                    packet.writeShort(old_visible.size());
                    for (Frequency frequency : old_visible) {
                        packet.writeNBTTagCompound(frequency.toNBT());
                    }
                    packet.sendToServer();
                }
                HashSet<Frequency> temp = this.b_visible;
                temp.clear();
                this.b_visible = this.a_visible;
                this.a_visible = temp;
            }
        }

        public FluidStack getLiquid(Frequency freq) {
            String key = TankSynchroniser.key(freq);
            this.a_visible.add(freq);
            PlayerItemTankState state = this.tankStates.get(key);
            return state == null ? FluidUtils.emptyFluid() : state.c_liquid;
        }

        public void handleVisiblityPacket(PacketCustom packet) {
            int i;
            int k = packet.readUShort();
            for (i = 0; i < k; ++i) {
                this.track(Frequency.fromNBT(packet.readNBTTagCompound()), true);
            }
            k = packet.readUShort();
            for (i = 0; i < k; ++i) {
                this.track(Frequency.fromNBT(packet.readNBTTagCompound()), false);
            }
        }
    }

    public static class PlayerItemTankState
    extends TankState {
        private EntityPlayerMP player;
        private boolean tracking;

        public PlayerItemTankState(EntityPlayerMP player, EnderLiquidStorage storage) {
            this.player = player;
            this.reloadStorage(storage);
            this.tracking = true;
        }

        public PlayerItemTankState() {
        }

        @Override
        public void sendSyncPacket() {
            if (!this.tracking) {
                return;
            }
            PacketCustom packet = new PacketCustom((Object)"ES", 4);
            packet.writeNBTTagCompound(this.storage.freq.toNBT());
            packet.writeFluidStack(this.s_liquid);
            packet.sendToPlayer((EntityPlayer)this.player);
        }

        public void setTracking(boolean t) {
            this.tracking = t;
        }

        @Override
        public void update(boolean client) {
            if (this.tracking || client) {
                super.update(client);
            }
        }
    }

    public static abstract class TankState {
        public EnderLiquidStorage storage;
        public FluidStack c_liquid = FluidUtils.emptyFluid();
        public FluidStack s_liquid = FluidUtils.emptyFluid();
        public FluidStack f_liquid = FluidUtils.emptyFluid();

        public void reloadStorage(EnderLiquidStorage storage) {
            this.storage = storage;
        }

        public void update(boolean client) {
            FluidStack a_liquid;
            FluidStack b_liquid;
            if (client) {
                b_liquid = this.c_liquid.copy();
                if (this.s_liquid.isFluidEqual(this.c_liquid)) {
                    this.c_liquid.amount = MathHelper.approachExpI((int)this.c_liquid.amount, (int)this.s_liquid.amount, (double)0.1);
                } else if (this.c_liquid.amount > 100) {
                    this.c_liquid.amount = MathHelper.retreatExpI((int)this.c_liquid.amount, (int)0, (int)this.f_liquid.amount, (double)0.1, (int)1000);
                } else {
                    this.c_liquid = FluidUtils.copy((FluidStack)this.s_liquid, (int)0);
                }
                a_liquid = this.c_liquid;
            } else {
                this.s_liquid = this.storage.getFluid();
                b_liquid = this.s_liquid.copy();
                if (!this.s_liquid.isFluidEqual(this.c_liquid)) {
                    this.sendSyncPacket();
                    this.c_liquid = this.s_liquid;
                } else if (Math.abs(this.c_liquid.amount - this.s_liquid.amount) > 250 || this.s_liquid.amount == 0 && this.c_liquid.amount > 0) {
                    this.sendSyncPacket();
                    this.c_liquid = this.s_liquid;
                }
                a_liquid = this.s_liquid;
            }
            if (b_liquid.amount == 0 != (a_liquid.amount == 0) || !b_liquid.isFluidEqual(a_liquid)) {
                this.onLiquidChanged();
            }
        }

        public void onLiquidChanged() {
        }

        public abstract void sendSyncPacket();

        public void sync(FluidStack liquid) {
            this.s_liquid = liquid;
            if (!this.s_liquid.isFluidEqual(this.c_liquid)) {
                this.f_liquid = this.c_liquid.copy();
            }
        }
    }
}

