/*
 * Decompiled with CFR 0.152.
 */
package com.abecderic.holovm.block;

import com.abecderic.holovm.block.TileVMBase;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;

public class BlockVMBase
extends BlockContainer {
    public static final PropertyBool HASITEM = PropertyBool.func_177716_a((String)"hasitem");
    public static final PropertyBool ADV = PropertyBool.func_177716_a((String)"adv");

    public BlockVMBase() {
        super(Material.field_151573_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)HASITEM, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)ADV, (Comparable)Boolean.valueOf(false)));
        this.setRegistryName("vmbase");
        this.func_149663_c("vmbase");
        this.func_149711_c(2.2f);
        this.func_149752_b(5.0f);
        this.func_149713_g(0);
        this.func_149715_a(1.0f);
    }

    public String func_149739_a() {
        return "tile.holovm:vmbase";
    }

    public TileEntity func_149915_a(World world, int i) {
        return new TileVMBase();
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public void func_149666_a(Item itemIn, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(itemIn, 1, 0));
        list.add(new ItemStack(itemIn, 1, 2));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{HASITEM, ADV});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)HASITEM, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)ADV, (Comparable)Boolean.valueOf((meta & 2) == 2));
    }

    public int func_176201_c(IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)HASITEM) != false ? 1 : 0) + ((Boolean)state.func_177229_b((IProperty)ADV) != false ? 2 : 0);
    }

    public void func_176208_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player) {
        super.func_176208_a(worldIn, pos, state, player);
        TileEntity tileentity = worldIn.func_175625_s(pos);
        if (!worldIn.field_72995_K && tileentity != null && tileentity instanceof TileVMBase) {
            EntityItem item;
            TileVMBase te = (TileVMBase)tileentity;
            for (int i = 0; i < te.func_70302_i_(); ++i) {
                ItemStack stack = te.func_70301_a(i);
                if (stack == null) continue;
                EntityItem item2 = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack);
                worldIn.func_72838_d((Entity)item2);
            }
            ItemStack camouflage = te.getCamouflage();
            if (camouflage != null) {
                item = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, camouflage);
                worldIn.func_72838_d((Entity)item);
            }
            if (((Boolean)state.func_177229_b((IProperty)ADV)).booleanValue()) {
                item = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack(Items.field_151043_k, 4));
                worldIn.func_72838_d((Entity)item);
            }
            if (te.isOwned()) {
                item = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack(Items.field_151045_i));
                worldIn.func_72838_d((Entity)item);
            }
        }
        if (tileentity != null) {
            tileentity.func_145843_s();
        }
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND) {
            int face;
            TileVMBase te = (TileVMBase)worldIn.func_175625_s(pos);
            boolean adv = (Boolean)state.func_177229_b((IProperty)ADV);
            int n = face = adv ? side.func_176745_a() : 0;
            if (playerIn.func_70093_af()) {
                String s = te.getItemString(face);
                if (s != null) {
                    playerIn.func_145747_a((ITextComponent)new TextComponentString(s));
                }
            } else if (!te.isOwned() || te.isOwner(playerIn)) {
                ItemStack stack = te.func_70301_a(face);
                if (stack != null) {
                    EntityItem item = new EntityItem(worldIn, playerIn.field_70165_t, playerIn.field_70163_u + 1.0, playerIn.field_70161_v, stack);
                    worldIn.func_72838_d((Entity)item);
                }
                te.func_70299_a(face, playerIn.func_184586_b(EnumHand.MAIN_HAND));
                if (te.func_70301_a(face) != null) {
                    worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)HASITEM, (Comparable)Boolean.valueOf(true)));
                    int f3no = this.playerYawToF3No(playerIn.func_70079_am());
                    if (!adv) {
                        if (side == EnumFacing.DOWN && f3no != -1) {
                            te.setDirection((byte)f3no);
                        } else if (side == EnumFacing.UP && f3no != -1) {
                            te.setDirection((byte)(4 + f3no));
                        } else {
                            te.setDirection((byte)(6 + side.ordinal()));
                        }
                    } else if (side == EnumFacing.DOWN && f3no != -1) {
                        int b = te.getDirection() & 0xC;
                        te.setDirection((byte)(b + f3no));
                    } else if (side == EnumFacing.UP && f3no != -1) {
                        int b = te.getDirection() & 3;
                        te.setDirection((byte)(b + (f3no << 2)));
                    }
                } else {
                    boolean stacksNull = true;
                    for (int i = 0; i < te.func_70302_i_(); ++i) {
                        if (te.func_70301_a(i) == null) continue;
                        stacksNull = false;
                    }
                    if (stacksNull && te.getCamouflage() == null) {
                        worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)HASITEM, (Comparable)Boolean.valueOf(false)));
                    } else {
                        worldIn.func_175656_a(pos, worldIn.func_180495_p(pos).func_177226_a((IProperty)HASITEM, (Comparable)Boolean.valueOf(true)));
                    }
                }
                te.sendUpdates();
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    playerIn.func_184611_a(EnumHand.MAIN_HAND, null);
                }
            } else {
                playerIn.func_146105_b((ITextComponent)new TextComponentTranslation("holovm.notowner", new Object[]{te.getOwnerName()}));
            }
        }
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        TileVMBase te = (TileVMBase)world.func_175625_s(pos);
        if (!te.isOwned() || te.isOwner(player) || player.func_184812_l_()) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        player.func_146105_b((ITextComponent)new TextComponentTranslation("holovm.notowner", new Object[]{te.getOwnerName()}));
        return false;
    }

    public float getExplosionResistance(World world, BlockPos pos, Entity exploder, Explosion explosion) {
        TileVMBase te = (TileVMBase)world.func_175625_s(pos);
        if (!te.isOwned()) {
            return super.getExplosionResistance(world, pos, exploder, explosion);
        }
        return 3600000.0f;
    }

    private int playerYawToF3No(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw += 360.0f;
        }
        if (yaw >= 315.0f || yaw < 45.0f) {
            return 0;
        }
        if (yaw >= 45.0f && yaw < 135.0f) {
            return 1;
        }
        if (yaw >= 135.0f && yaw < 225.0f) {
            return 2;
        }
        if (yaw >= 225.0f && yaw < 315.0f) {
            return 3;
        }
        return -1;
    }
}

