/*
 * Decompiled with CFR 0.152.
 */
package com.abecderic.holovm.render;

import com.abecderic.holovm.HoloVM;
import com.abecderic.holovm.block.BlockVMBase;
import com.abecderic.holovm.block.TileVMBase;
import com.abecderic.holovm.network.VMBaseRequest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;

public class VMBaseRenderer
extends TileEntitySpecialRenderer<TileVMBase> {
    private static final ResourceLocation MAP_BG = new ResourceLocation("textures/map/map_background.png");
    private static ItemStack vmbaseStack = null;

    public void renderTileEntityAt(TileVMBase te, double x, double y, double z, float partialTicks, int destroyStage) {
        ItemStack camouflage = te.getCamouflage();
        IBlockState state = this.func_178459_a().func_180495_p(te.func_174877_v());
        if (state.func_177230_c() != HoloVM.vmbase) {
            return;
        }
        boolean stacksNull = true;
        for (int i = 0; i < te.func_70302_i_(); ++i) {
            if (te.func_70301_a(i) == null) continue;
            stacksNull = false;
            break;
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockVMBase.HASITEM)).booleanValue() && stacksNull && camouflage == null) {
            HoloVM.snw.sendToServer((IMessage)new VMBaseRequest(te.func_145831_w().field_73011_w.getDimension(), te.func_174877_v()));
        }
        this.renderVM(te, state, x, y, z);
    }

    private void renderVM(TileVMBase tileentity, IBlockState state, double x, double y, double z) {
        this.setupRendering(x, y, z);
        int brightness = tileentity.func_145831_w().func_175626_b(tileentity.func_174877_v(), 0);
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)(brightness % 65536) / 1.0f), (float)((float)(brightness / 65536) / 1.0f));
        GlStateManager.func_179112_b((int)32771, (int)32772);
        ItemStack stack = tileentity.getCamouflage();
        if (!((Boolean)state.func_177229_b((IProperty)BlockVMBase.HASITEM)).booleanValue() || stack == null) {
            if (vmbaseStack == null) {
                vmbaseStack = new ItemStack(HoloVM.vmbase);
            }
            stack = vmbaseStack;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a((float)2.0f, (float)2.0f, (float)2.0f);
        Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179121_F();
        GlStateManager.func_179112_b((int)770, (int)771);
        RenderHelper.func_74518_a();
        if (!((Boolean)state.func_177229_b((IProperty)BlockVMBase.ADV)).booleanValue()) {
            if (tileentity.func_70301_a(0) != null) {
                this.renderItemStack(tileentity, x, y, z, tileentity.func_70301_a(0), tileentity.getDirection());
            }
        } else {
            for (int i = 0; i < tileentity.func_70302_i_(); ++i) {
                if (tileentity.func_70301_a(i) == null) continue;
                int direction = 0;
                if (i >= 2) {
                    direction = 6 + i;
                } else if (i == 0) {
                    direction = tileentity.getDirection() & 3;
                } else if (i == 1) {
                    direction = 4 + ((tileentity.getDirection() & 0xC) >> 2);
                }
                this.renderItemStack(tileentity, x, y, z, tileentity.func_70301_a(i), direction);
            }
        }
        this.finishRendering();
    }

    private void renderItemStack(TileVMBase te, double x, double y, double z, ItemStack stack, int direction) {
        GlStateManager.func_179094_E();
        if (stack.func_77973_b() instanceof ItemMap) {
            ItemMap map = (ItemMap)stack.func_77973_b();
            MapData mapdata = map.func_77873_a(stack, te.func_145831_w());
            if (mapdata != null) {
                Minecraft.func_71410_x().func_175598_ae().field_78724_e.func_110577_a(MAP_BG);
                this.translateOnDirection(direction);
                if (direction >= 0 && direction <= 4) {
                    GlStateManager.func_179109_b((float)(-0.5f - 0.5f * (float)mapdata.field_76197_d), (float)(1.5f - (float)mapdata.field_76197_d), (float)0.0f);
                } else if (direction >= 4 && direction < 8) {
                    GlStateManager.func_179109_b((float)(-0.5f - 0.5f * (float)mapdata.field_76197_d), (float)(0.5f + (float)mapdata.field_76197_d), (float)0.0f);
                } else {
                    GlStateManager.func_179109_b((float)(-0.5f - 0.5f * (float)mapdata.field_76197_d), (float)(0.5f + 0.5f * (float)mapdata.field_76197_d), (float)0.0f);
                }
                GlStateManager.func_179114_b((float)180.0f, (float)180.0f, (float)0.0f, (float)1.0f);
                float f = 0.0078125f * (float)(mapdata.field_76197_d + 1);
                GlStateManager.func_179152_a((float)f, (float)f, (float)f);
                Minecraft.func_71410_x().field_71460_t.func_147701_i().func_148250_a(mapdata, true);
            }
        } else {
            this.translateOnDirection(direction);
            Minecraft.func_71410_x().func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179112_b((int)770, (int)771);
        }
        GlStateManager.func_179121_F();
    }

    private void setupRendering(double x, double y, double z) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        if (Minecraft.func_71379_u()) {
            GL11.glShadeModel((int)7425);
        } else {
            GL11.glShadeModel((int)7424);
        }
        GlStateManager.func_179137_b((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
    }

    private void translateOnDirection(int direction) {
        switch (direction) {
            case 0: {
                GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 1: {
                GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 2: {
                GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
                break;
            }
            case 3: {
                GL11.glTranslated((double)0.0, (double)-1.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 4: {
                GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 5: {
                GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 6: {
                GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 7: {
                GL11.glTranslated((double)0.0, (double)1.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 8: {
                GL11.glTranslated((double)0.0, (double)0.0, (double)-1.0);
                GL11.glRotated((double)180.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 9: {
                GL11.glTranslated((double)0.0, (double)0.0, (double)1.0);
                break;
            }
            case 10: {
                GL11.glTranslated((double)-1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)-90.0, (double)0.0, (double)1.0, (double)0.0);
                break;
            }
            case 11: {
                GL11.glTranslated((double)1.0, (double)0.0, (double)0.0);
                GL11.glRotated((double)90.0, (double)0.0, (double)1.0, (double)0.0);
            }
        }
    }

    private void finishRendering() {
        GlStateManager.func_179084_k();
        RenderHelper.func_74519_b();
        GlStateManager.func_179121_F();
    }
}

