/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.core.handler;

import java.util.ArrayDeque;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import vazkii.psi.client.core.handler.HUDHandler;
import vazkii.psi.client.core.handler.KeybindHandler;
import vazkii.psi.common.core.handler.PersistencyHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;

public class ClientTickHandler {
    public static volatile Queue<Runnable> scheduledActions = new ArrayDeque<Runnable>();
    public static int ticksInGame = 0;
    public static float partialTicks = 0.0f;
    public static float delta = 0.0f;
    public static float total = 0.0f;

    private void calcDelta() {
        float oldTotal = total;
        total = (float)ticksInGame + partialTicks;
        delta = total - oldTotal;
    }

    @SubscribeEvent
    public void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            partialTicks = event.renderTickTime;
        }
    }

    @SubscribeEvent
    public void clientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e == null) {
                PlayerDataHandler.cleanup();
            } else if (mc.field_71439_g != null) {
                PersistencyHandler.init();
                while (!scheduledActions.isEmpty()) {
                    scheduledActions.poll().run();
                }
            }
            HUDHandler.tick();
            GuiScreen gui = mc.field_71462_r;
            if (gui == null || !gui.func_73868_f()) {
                if (gui == null && KeybindHandler.keybind.func_151470_d()) {
                    KeybindHandler.keyDown();
                }
                ++ticksInGame;
                partialTicks = 0.0f;
            }
            this.calcDelta();
        }
    }
}

