/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.client.render.entity;

import com.google.common.base.Optional;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.client.core.handler.ShaderHandler;
import vazkii.psi.common.Psi;
import vazkii.psi.common.entity.EntitySpellCircle;

public class RenderSpellCircle
extends Render<EntitySpellCircle> {
    private static final ResourceLocation[] layers = new ResourceLocation[]{new ResourceLocation(String.format("psi:textures/misc/spellCircle%d.png", 0)), new ResourceLocation(String.format("psi:textures/misc/spellCircle%d.png", 1)), new ResourceLocation(String.format("psi:textures/misc/spellCircle%d.png", 2))};

    public RenderSpellCircle(RenderManager renderManager) {
        super(renderManager);
    }

    public void doRender(EntitySpellCircle entity, double x, double y, double z, float entityYaw, float partialTicks) {
        super.func_76986_a((Entity)entity, x, y, z, entityYaw, partialTicks);
        int colorVal = 1295871;
        ItemStack colorizer = (ItemStack)((Optional)entity.func_184212_Q().func_187225_a(EntitySpellCircle.COLORIZER_DATA)).orNull();
        if (colorizer != null && colorizer.func_77973_b() instanceof ICADColorizer) {
            colorVal = Psi.proxy.getColorizerColor(colorizer).getRGB();
        }
        float alive = (float)entity.getTimeAlive() + partialTicks;
        float s1 = Math.min(1.0f, alive / 5.0f);
        if (alive > 105.0f) {
            s1 = 1.0f - Math.min(1.0f, Math.max(0.0f, alive - 105.0f) / 5.0f);
        }
        RenderSpellCircle.renderSpellCircle(alive, s1, x, y, z, colorVal);
    }

    public static void renderSpellCircle(float time, float s1, double x, double y, double z, int colorVal) {
        float s = 0.0625f;
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(x - (double)(s1 * 2.0f)), (double)(y + 0.01), (double)(z - (double)(s1 * 2.0f)));
        GlStateManager.func_179152_a((float)s, (float)s, (float)s);
        GlStateManager.func_179152_a((float)s1, (float)1.0f, (float)s1);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179129_p();
        GlStateManager.func_179140_f();
        ShaderHandler.useShader(ShaderHandler.rawColor);
        for (int i = 0; i < layers.length; ++i) {
            Color color = new Color(colorVal);
            if (i == 2) {
                color = color.brighter();
            }
            float r = (float)color.getRed() / 255.0f;
            float g = (float)color.getGreen() / 255.0f;
            float b = (float)color.getBlue() / 255.0f;
            float d = 2.0f / s;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)d, (float)d, (float)0.0f);
            float rot = time;
            if (i == 0) {
                rot = -rot;
            }
            GlStateManager.func_179114_b((float)rot, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)(-d), (float)(-d), (float)0.0f);
            if (i == 1) {
                GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            } else {
                GlStateManager.func_179124_c((float)r, (float)g, (float)b);
            }
            Minecraft.func_71410_x().field_71446_o.func_110577_a(layers[i]);
            Gui.func_146110_a((int)0, (int)0, (float)0.0f, (float)0.0f, (int)64, (int)64, (float)64.0f, (float)64.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-0.5f);
        }
        ShaderHandler.releaseShader();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
    }

    protected ResourceLocation getEntityTexture(EntitySpellCircle entity) {
        return null;
    }
}

