/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item;

import java.awt.Color;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.item.ItemMod;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.EnumCADComponent;
import vazkii.psi.api.cad.EnumCADStat;
import vazkii.psi.api.cad.ICAD;
import vazkii.psi.api.cad.ICADAssembly;
import vazkii.psi.api.cad.ICADColorizer;
import vazkii.psi.api.cad.ICADComponent;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.ISpellContainer;
import vazkii.psi.api.spell.ISpellSettable;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.BlockProgrammer;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.core.handler.ConfigHandler;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.core.handler.PsiSoundHandler;
import vazkii.psi.common.crafting.recipe.AssemblyScavengeRecipe;
import vazkii.psi.common.item.base.IPsiItem;
import vazkii.psi.common.item.base.ModItems;

public class ItemCAD
extends ItemMod
implements ICAD,
ISpellSettable,
IItemColorProvider,
IPsiItem {
    private static final String TAG_COMPONENT_PREFIX = "component";
    private static final String TAG_STORED_PSI = "storedPsi";
    private static final String TAG_BULLET_PREFIX = "bullet";
    private static final String TAG_SELECTED_SLOT = "selectedSlot";
    private static final String TAG_TIME = "time";
    private static final String TAG_STORED_VECTOR_PREFIX = "storedVector";
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_Z = "z";
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*\\])|(?:ComputerCraft)$");

    public ItemCAD() {
        super("cad", new String[0]);
        this.func_77625_d(1);
        GameRegistry.addRecipe((IRecipe)new AssemblyScavengeRecipe());
        RecipeSorter.register((String)"psi:assemblyScavenge", AssemblyScavengeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        return ConfigHandler.cadHarvestLevel;
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        Block block = worldIn.func_180495_p(pos).func_177230_c();
        return block == ModBlocks.programmer ? ((BlockProgrammer)block).setSpell(worldIn, pos, playerIn, stack) : EnumActionResult.PASS;
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer playerIn, EnumHand hand) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(playerIn);
        ItemStack playerCad = PsiAPI.getPlayerCAD(playerIn);
        if (playerCad != itemStackIn) {
            if (!worldIn.field_72995_K) {
                playerIn.func_146105_b(new TextComponentTranslation("psimisc.multipleCads", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStackIn);
        }
        ItemStack bullet = this.getBulletInSocket(itemStackIn, this.getSelectedSlot(itemStackIn));
        boolean did = ItemCAD.cast(worldIn, playerIn, data, bullet, itemStackIn, 40, 25, 0.5f, null);
        if (bullet == null && ItemCAD.craft(playerIn, new ItemStack(Items.field_151137_ax), new ItemStack((Item)ModItems.material))) {
            if (!worldIn.field_72995_K) {
                worldIn.func_184148_a(null, playerIn.field_70165_t, playerIn.field_70163_u, playerIn.field_70161_v, PsiSoundHandler.cadShoot, SoundCategory.PLAYERS, 0.5f, (float)(0.5 + Math.random() * 0.5));
            }
            data.deductPsi(100, 60, true);
            if (data.level == 0) {
                data.levelUp();
            }
            did = true;
        }
        return new ActionResult(did ? EnumActionResult.SUCCESS : EnumActionResult.PASS, (Object)itemStackIn);
    }

    @Override
    public void setSpell(EntityPlayer player, ItemStack stack, Spell spell) {
        int slot = this.getSelectedSlot(stack);
        ItemStack bullet = this.getBulletInSocket(stack, slot);
        if (bullet != null && bullet.func_77973_b() instanceof ISpellSettable) {
            ((ISpellSettable)bullet.func_77973_b()).setSpell(player, bullet, spell);
            this.setBulletInSocket(stack, slot, bullet);
        }
    }

    public static boolean cast(World world, EntityPlayer player, PlayerDataHandler.PlayerData data, ItemStack bullet, ItemStack cad, int cd, int particles, float sound, Consumer<SpellContext> predicate) {
        ISpellContainer spellContainer;
        if (data.getAvailablePsi() > 0 && cad != null && bullet != null && bullet.func_77973_b() instanceof ISpellContainer && ItemCAD.isTruePlayer((Entity)player) && (spellContainer = (ISpellContainer)bullet.func_77973_b()).containsSpell(bullet)) {
            Spell spell = spellContainer.getSpell(bullet);
            SpellContext context = new SpellContext().setPlayer(player).setSpell(spell);
            if (predicate != null) {
                predicate.accept(context);
            }
            if (context.isValid()) {
                if (context.cspell.metadata.evaluateAgainst(cad)) {
                    int cost = ItemCAD.getRealCost(cad, bullet, context.cspell.metadata.stats.get((Object)EnumSpellStat.COST));
                    if (cost > 0 || cost == -1) {
                        if (cost != -1) {
                            data.deductPsi(cost, cd, true);
                        }
                        if (!world.field_72995_K) {
                            world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, PsiSoundHandler.cadShoot, SoundCategory.PLAYERS, sound, (float)(0.5 + Math.random() * 0.5));
                        }
                        if (sound > 0.0f) {
                            Color color = Psi.proxy.getCADColor(cad);
                            float r = (float)color.getRed() / 255.0f;
                            float g = (float)color.getGreen() / 255.0f;
                            float b = (float)color.getBlue() / 255.0f;
                            for (int i = 0; i < particles; ++i) {
                                double x = player.field_70165_t + (Math.random() - 0.5) * 2.1 * (double)player.field_70130_N;
                                double y = player.field_70163_u - player.func_70033_W();
                                double z = player.field_70161_v + (Math.random() - 0.5) * 2.1 * (double)player.field_70130_N;
                                float grav = -0.15f - (float)Math.random() * 0.03f;
                                Psi.proxy.sparkleFX(world, x, y, z, r, g, b, grav, 0.25f, 15);
                            }
                            double x = player.field_70165_t;
                            double y = player.field_70163_u + (double)player.func_70047_e() - 0.1;
                            double z = player.field_70161_v;
                            Vector3 lookOrig = new Vector3(player.func_70040_Z());
                            for (int i = 0; i < 25; ++i) {
                                Vector3 look = lookOrig.copy();
                                double spread = 0.25;
                                look.x += (Math.random() - 0.5) * spread;
                                look.y += (Math.random() - 0.5) * spread;
                                look.z += (Math.random() - 0.5) * spread;
                                look.normalize().multiply(0.15);
                                Psi.proxy.sparkleFX(world, x, y, z, r, g, b, (float)look.x, (float)look.y, (float)look.z, 0.3f, 5);
                            }
                        }
                    }
                    spellContainer.castSpell(bullet, context);
                    return true;
                }
                if (!world.field_72995_K) {
                    player.func_146105_b(new TextComponentTranslation("psimisc.weakCad", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
                }
            }
        }
        return false;
    }

    public static boolean craft(EntityPlayer player, ItemStack in, ItemStack out) {
        List items = player.field_70170_p.func_72872_a(EntityItem.class, new AxisAlignedBB(player.field_70165_t - 8.0, player.field_70163_u - 8.0, player.field_70161_v - 8.0, player.field_70165_t + 8.0, player.field_70163_u + 8.0, player.field_70161_v + 8.0));
        Color color = new Color(1295871);
        float r = (float)color.getRed() / 255.0f;
        float g = (float)color.getGreen() / 255.0f;
        float b = (float)color.getBlue() / 255.0f;
        boolean did = false;
        for (EntityItem item : items) {
            ItemStack stack = item.func_92059_d();
            if (stack == null || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)in)) continue;
            ItemStack outCopy = out.func_77946_l();
            outCopy.field_77994_a = stack.field_77994_a;
            item.func_92058_a(outCopy);
            did = true;
            for (int i = 0; i < 5; ++i) {
                double x = item.field_70165_t + (Math.random() - 0.5) * 2.1 * (double)item.field_70130_N;
                double y = item.field_70163_u - item.func_70033_W();
                double z = item.field_70161_v + (Math.random() - 0.5) * 2.1 * (double)item.field_70130_N;
                float grav = -0.05f - (float)Math.random() * 0.01f;
                Psi.proxy.sparkleFX(item.field_70170_p, x, y, z, r, g, b, grav, 3.5f, 15);
                double m = 0.01;
                double d3 = 10.0;
                for (int j = 0; j < 3; ++j) {
                    double d0 = item.field_70170_p.field_73012_v.nextGaussian() * m;
                    double d1 = item.field_70170_p.field_73012_v.nextGaussian() * m;
                    double d2 = item.field_70170_p.field_73012_v.nextGaussian() * m;
                    item.field_70170_p.func_175688_a(EnumParticleTypes.EXPLOSION_NORMAL, item.field_70165_t + (double)(item.field_70170_p.field_73012_v.nextFloat() * item.field_70130_N * 2.0f) - (double)item.field_70130_N - d0 * d3, item.field_70163_u + (double)(item.field_70170_p.field_73012_v.nextFloat() * item.field_70131_O) - d1 * d3, item.field_70161_v + (double)(item.field_70170_p.field_73012_v.nextFloat() * item.field_70130_N * 2.0f) - (double)item.field_70130_N - d2 * d3, d0, d1, d2, new int[0]);
                }
            }
        }
        return did;
    }

    public static int getRealCost(ItemStack stack, ItemStack bullet, int cost) {
        if (stack != null && stack.func_77973_b() instanceof ICAD) {
            int eff = ((ICAD)stack.func_77973_b()).getStatValue(stack, EnumCADStat.EFFICIENCY);
            if (eff == -1) {
                return -1;
            }
            if (eff == 0) {
                return cost;
            }
            double effPercentile = (double)eff / 100.0;
            double procCost = (double)cost / effPercentile;
            if (bullet != null) {
                procCost *= ((ISpellContainer)bullet.func_77973_b()).getCostModifier(bullet);
            }
            return (int)procCost;
        }
        return cost;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof EntityPlayer)) {
            return false;
        }
        EntityPlayer player = (EntityPlayer)e;
        String name = player.func_70005_c_();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    public static void setComponent(ItemStack stack, ItemStack componentStack) {
        if (componentStack != null && componentStack.func_77973_b() instanceof ICADComponent) {
            ICADComponent component = (ICADComponent)componentStack.func_77973_b();
            EnumCADComponent componentType = component.getComponentType(componentStack);
            String name = TAG_COMPONENT_PREFIX + componentType.name();
            NBTTagCompound cmp = new NBTTagCompound();
            componentStack.func_77955_b(cmp);
            ItemNBTHelper.setCompound((ItemStack)stack, (String)name, (NBTTagCompound)cmp);
        }
    }

    public static ItemStack makeCAD(ItemStack ... components) {
        ItemStack stack = new ItemStack((Item)ModItems.cad);
        for (ItemStack component : components) {
            ItemCAD.setComponent(stack, component);
        }
        return stack;
    }

    @Override
    public ItemStack getComponentInSlot(ItemStack stack, EnumCADComponent type) {
        String name = TAG_COMPONENT_PREFIX + type.name();
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)name, (boolean)true);
        if (cmp == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)cmp);
    }

    @Override
    public int getStatValue(ItemStack stack, EnumCADStat stat) {
        ItemStack componentStack = this.getComponentInSlot(stack, stat.getSourceType());
        if (componentStack != null && componentStack.func_77973_b() instanceof ICADComponent) {
            ICADComponent component = (ICADComponent)componentStack.func_77973_b();
            return component.getCADStatValue(componentStack, stat);
        }
        return 0;
    }

    @Override
    public int getStoredPsi(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_STORED_PSI, (int)0);
    }

    @Override
    public void regenPsi(ItemStack stack, int psi) {
        int maxPsi = this.getStatValue(stack, EnumCADStat.OVERFLOW);
        int currPsi = this.getStoredPsi(stack);
        int endPsi = Math.min(currPsi + psi, maxPsi);
        if (endPsi != currPsi) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_STORED_PSI, (int)endPsi);
        }
    }

    @Override
    public int consumePsi(ItemStack stack, int psi) {
        int currPsi = this.getStoredPsi(stack);
        if (currPsi >= psi) {
            ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_STORED_PSI, (int)(currPsi - psi));
            return 0;
        }
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_STORED_PSI, (int)0);
        return psi - currPsi;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getSpellColor(ItemStack stack) {
        ItemStack dye = this.getComponentInSlot(stack, EnumCADComponent.DYE);
        if (dye != null && dye.func_77973_b() instanceof ICADColorizer) {
            return ((ICADColorizer)dye.func_77973_b()).getColor(dye);
        }
        return 1295871;
    }

    @Override
    public boolean isSocketSlotAvailable(ItemStack stack, int slot) {
        int sockets = this.getStatValue(stack, EnumCADStat.SOCKETS);
        return slot < sockets;
    }

    @Override
    public ItemStack getBulletInSocket(ItemStack stack, int slot) {
        String name = TAG_BULLET_PREFIX + slot;
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)name, (boolean)true);
        if (cmp == null) {
            return null;
        }
        return ItemStack.func_77949_a((NBTTagCompound)cmp);
    }

    @Override
    public void setBulletInSocket(ItemStack stack, int slot, ItemStack bullet) {
        String name = TAG_BULLET_PREFIX + slot;
        NBTTagCompound cmp = new NBTTagCompound();
        if (bullet != null) {
            bullet.func_77955_b(cmp);
        }
        ItemNBTHelper.setCompound((ItemStack)stack, (String)name, (NBTTagCompound)cmp);
    }

    @Override
    public int getSelectedSlot(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_SELECTED_SLOT, (int)0);
    }

    @Override
    public void setSelectedSlot(ItemStack stack, int slot) {
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_SELECTED_SLOT, (int)slot);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged;
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex == 1 ? ItemCAD.this.getSpellColor(stack) : 0xFFFFFF;
            }
        };
    }

    @Override
    public int getTime(ItemStack stack) {
        return ItemNBTHelper.getInt((ItemStack)stack, (String)TAG_TIME, (int)0);
    }

    @Override
    public void incrementTime(ItemStack stack) {
        int time = this.getTime(stack);
        ItemNBTHelper.setInt((ItemStack)stack, (String)TAG_TIME, (int)(time + 1));
    }

    @Override
    public int getMemorySize(ItemStack stack) {
        return this.getStatValue(stack, EnumCADStat.SOCKETS) / 3;
    }

    @Override
    public void setStoredVector(ItemStack stack, int memorySlot, Vector3 vec) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds");
        }
        NBTTagCompound cmp = new NBTTagCompound();
        cmp.func_74780_a(TAG_X, vec.x);
        cmp.func_74780_a(TAG_Y, vec.y);
        cmp.func_74780_a(TAG_Z, vec.z);
        ItemNBTHelper.setCompound((ItemStack)stack, (String)(TAG_STORED_VECTOR_PREFIX + memorySlot), (NBTTagCompound)cmp);
    }

    @Override
    public Vector3 getStoredVector(ItemStack stack, int memorySlot) throws SpellRuntimeException {
        int size = this.getMemorySize(stack);
        if (memorySlot < 0 || memorySlot >= size) {
            throw new SpellRuntimeException("psi.spellerror.memoryoutofbounds");
        }
        NBTTagCompound cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)(TAG_STORED_VECTOR_PREFIX + memorySlot), (boolean)false);
        double x = cmp.func_74762_e(TAG_X);
        double y = cmp.func_74762_e(TAG_Y);
        double z = cmp.func_74762_e(TAG_Z);
        return new Vector3(x, y, z);
    }

    public void func_150895_a(Item itemIn, CreativeTabs tab, List<ItemStack> subItems) {
        subItems.add(ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 0)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 0), new ItemStack((Item)ModItems.cadCore, 1, 0), new ItemStack((Item)ModItems.cadSocket, 1, 0), new ItemStack((Item)ModItems.cadBattery, 1, 0)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 1), new ItemStack((Item)ModItems.cadCore, 1, 0), new ItemStack((Item)ModItems.cadSocket, 1, 0), new ItemStack((Item)ModItems.cadBattery, 1, 0)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 2), new ItemStack((Item)ModItems.cadCore, 1, 1), new ItemStack((Item)ModItems.cadSocket, 1, 1), new ItemStack((Item)ModItems.cadBattery, 1, 1)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 3), new ItemStack((Item)ModItems.cadCore, 1, 3), new ItemStack((Item)ModItems.cadSocket, 1, 3), new ItemStack((Item)ModItems.cadBattery, 1, 2)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 4), new ItemStack((Item)ModItems.cadCore, 1, 3), new ItemStack((Item)ModItems.cadSocket, 1, 3), new ItemStack((Item)ModItems.cadBattery, 1, 2)));
        subItems.add(ItemCAD.makeCAD(new ItemStack((Item)ModItems.cadAssembly, 1, 5), new ItemStack((Item)ModItems.cadCore, 1, 3), new ItemStack((Item)ModItems.cadSocket, 1, 3), new ItemStack((Item)ModItems.cadBattery, 1, 2)));
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ItemCAD.tooltipIfShift(tooltip, () -> {
            String componentName = ItemCAD.local((String)ISocketable.getSocketedItemName(stack, "psimisc.none"));
            ItemCAD.addToTooltip((List)tooltip, (String)"psimisc.spellSelected", (Object[])new Object[]{componentName});
            for (EnumCADComponent componentType : (EnumCADComponent[])EnumCADComponent.class.getEnumConstants()) {
                ItemStack componentStack = this.getComponentInSlot(stack, componentType);
                String name = "psimisc.none";
                if (componentStack != null) {
                    name = componentStack.func_82833_r();
                }
                name = ItemCAD.local((String)name);
                String line = TextFormatting.GREEN + ItemCAD.local((String)componentType.getName()) + TextFormatting.GRAY + ": " + name;
                ItemCAD.addToTooltip((List)tooltip, (String)line, (Object[])new Object[0]);
                line = "";
                for (EnumCADStat stat : (EnumCADStat[])EnumCADStat.class.getEnumConstants()) {
                    if (stat.getSourceType() != componentType) continue;
                    String shrt = stat.getName();
                    int statVal = this.getStatValue(stack, stat);
                    String statValStr = statVal == -1 ? "\u221e" : "" + statVal;
                    line = " " + TextFormatting.AQUA + ItemCAD.local((String)shrt) + TextFormatting.GRAY + ": " + statValStr;
                    if (line.isEmpty()) continue;
                    ItemCAD.addToTooltip((List)tooltip, (String)line, (Object[])new Object[0]);
                }
            }
        });
    }

    @Override
    public boolean requiresSneakForSpellSet(ItemStack stack) {
        return true;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.RARE;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemMeshDefinition getCustomMeshDefinition() {
        return new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                ICAD cad = (ICAD)stack.func_77973_b();
                ItemStack assemblyStack = cad.getComponentInSlot(stack, EnumCADComponent.ASSEMBLY);
                if (assemblyStack == null) {
                    return null;
                }
                ICADAssembly assembly = (ICADAssembly)assemblyStack.func_77973_b();
                return assembly.getCADModel(assemblyStack, stack);
            }
        };
    }
}

