/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.item.armor;

import java.util.List;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vazkii.arl.interf.IItemColorProvider;
import vazkii.arl.item.ItemMod;
import vazkii.arl.item.ItemModArmor;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.cad.ISocketable;
import vazkii.psi.api.exosuit.IPsiEventArmor;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.client.model.ModelPsimetalExosuit;
import vazkii.psi.common.core.PsiCreativeTab;
import vazkii.psi.common.core.handler.PlayerDataHandler;
import vazkii.psi.common.item.ItemCAD;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.item.tool.IPsimetalTool;
import vazkii.psi.common.item.tool.ItemPsimetalTool;

public class ItemPsimetalArmor
extends ItemModArmor
implements IPsimetalTool,
IPsiEventArmor,
IItemColorProvider {
    protected ModelBiped[] models = null;

    public ItemPsimetalArmor(String name, int type, EntityEquipmentSlot slot) {
        super(name, PsiAPI.PSIMETAL_ARMOR_MATERIAL, type, slot);
        this.func_77637_a(PsiCreativeTab.INSTANCE);
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        ItemPsimetalTool.regen(itemStack, (Entity)player, false);
    }

    public void cast(ItemStack stack, PsiArmorEvent event) {
        PlayerDataHandler.PlayerData data = PlayerDataHandler.get(event.getEntityPlayer());
        ItemStack playerCad = PsiAPI.getPlayerCAD(event.getEntityPlayer());
        if (playerCad != null) {
            ItemStack bullet = this.getBulletInSocket(stack, this.getSelectedSlot(stack));
            ItemCAD.cast(event.getEntityPlayer().field_70170_p, event.getEntityPlayer(), data, bullet, playerCad, this.getCastCooldown(stack), 0, this.getCastVolume(), context -> {
                context.tool = stack;
                context.attackingEntity = event.attacker;
                context.damageTaken = event.damage;
            });
        }
    }

    @Override
    public void onEvent(ItemStack stack, PsiArmorEvent event) {
        if (event.type.equals(this.getEvent(stack))) {
            this.cast(stack, event);
        }
    }

    public String getEvent(ItemStack stack) {
        return "psi.event.none";
    }

    public int getCastCooldown(ItemStack stack) {
        return 5;
    }

    public float getCastVolume() {
        return 0.025f;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ItemMod.tooltipIfShift(tooltip, () -> {
            String componentName = ItemMod.local((String)ISocketable.getSocketedItemName(stack, "psimisc.none"));
            ItemMod.addToTooltip((List)tooltip, (String)"psimisc.spellSelected", (Object[])new Object[]{componentName});
            ItemMod.addToTooltip((List)tooltip, (String)this.getEvent(stack), (Object[])new Object[0]);
        });
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == ModItems.material && par2ItemStack.func_77952_i() == 1 ? true : super.func_82789_a(par1ItemStack, par2ItemStack);
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        boolean overlay = type != null && type.equals("overlay");
        return overlay ? "psi:textures/model/psimetalExosuit.png" : "psi:textures/model/psimetalExosuitSensor.png";
    }

    public boolean func_82816_b_(ItemStack stack) {
        return true;
    }

    public int func_82814_b(ItemStack stack) {
        return 1295871;
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getItemColor() {
        return new IItemColor(){

            public int func_186726_a(ItemStack stack, int tintIndex) {
                return tintIndex == 1 ? ItemPsimetalArmor.this.func_82814_b(stack) : 0xFFFFFF;
            }
        };
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        int slotIndex = armorSlot.ordinal();
        ModelBiped model = this.getArmorModelForSlot(entityLiving, itemStack, slotIndex);
        if (model == null) {
            model = this.provideArmorModelForSlot(itemStack, slotIndex);
        }
        return model;
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModelForSlot(EntityLivingBase entity, ItemStack stack, int slot) {
        if (this.models == null) {
            this.models = new ModelBiped[4];
        }
        return this.models[slot -= 2];
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped provideArmorModelForSlot(ItemStack stack, int slot) {
        this.models[slot -= 2] = new ModelPsimetalExosuit(slot);
        return this.models[slot];
    }

    @Override
    public boolean requiresSneakForSpellSet(ItemStack stack) {
        return false;
    }
}

