/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.spell.trick.block;

import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.eventhandler.Event;
import vazkii.psi.api.internal.Vector3;
import vazkii.psi.api.spell.EnumSpellStat;
import vazkii.psi.api.spell.Spell;
import vazkii.psi.api.spell.SpellCompilationException;
import vazkii.psi.api.spell.SpellContext;
import vazkii.psi.api.spell.SpellMetadata;
import vazkii.psi.api.spell.SpellParam;
import vazkii.psi.api.spell.SpellRuntimeException;
import vazkii.psi.api.spell.param.ParamVector;
import vazkii.psi.api.spell.piece.PieceTrick;

public class PieceTrickBreakBlock
extends PieceTrick {
    SpellParam position;

    public PieceTrickBreakBlock(Spell spell) {
        super(spell);
    }

    @Override
    public void initParams() {
        this.position = new ParamVector("psi.spellparam.position", 2774482, false, false);
        this.addParam(this.position);
    }

    @Override
    public void addToMetadata(SpellMetadata meta) throws SpellCompilationException {
        super.addToMetadata(meta);
        meta.addStat(EnumSpellStat.POTENCY, 20);
        meta.addStat(EnumSpellStat.COST, 25);
    }

    @Override
    public Object execute(SpellContext context) throws SpellRuntimeException {
        if (context.caster.field_70170_p.field_72995_K) {
            return null;
        }
        Vector3 positionVal = (Vector3)this.getParamValue(context, this.position);
        if (positionVal == null) {
            throw new SpellRuntimeException("psi.spellerror.nullvector");
        }
        if (!context.isInRadius(positionVal)) {
            throw new SpellRuntimeException("psi.spellerror.outsideradius");
        }
        BlockPos pos = new BlockPos(positionVal.x, positionVal.y, positionVal.z);
        PieceTrickBreakBlock.removeBlockWithDrops(context, context.caster, context.caster.field_70170_p, context.tool, pos, true);
        return null;
    }

    public static void removeBlockWithDrops(SpellContext context, EntityPlayer player, World world, ItemStack tool, BlockPos pos, boolean particles) {
        if (!world.func_175667_e(pos) || context.positionBroken != null && pos.equals((Object)context.positionBroken.func_178782_a()) || !world.func_175660_a(player, pos)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (!(world.field_72995_K || block == null || block.isAir(state, (IBlockAccess)world, pos) || block instanceof BlockLiquid || block instanceof IFluidBlock || !(block.func_180647_a(state, player, world, pos) > 0.0f))) {
            if (!ForgeHooks.canHarvestBlock((Block)block, (EntityPlayer)player, (IBlockAccess)world, (BlockPos)pos)) {
                return;
            }
            BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    if (block.removedByPlayer(state, world, pos, player, true)) {
                        block.func_176206_d(world, pos, state);
                        block.func_180657_a(world, player, pos, state, world.func_175625_s(pos), tool);
                    }
                } else {
                    world.func_175698_g(pos);
                }
            }
            if (particles) {
                world.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)state));
            }
        }
    }
}

