/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.core.entity.EntityHelper;
import com.github.lunatrius.ingameinfo.client.gui.overlay.InfoItem;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.registry.FMLControlledNamespacedRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;

public abstract class TagPlayerEquipment
extends Tag {
    public static final FMLControlledNamespacedRegistry<Item> ITEM_REGISTRY = GameData.getItemRegistry();
    public static final String[] TYPES = new String[]{"equipped", "offhand", "mainhand", "helmet", "chestplate", "leggings", "boots"};
    public static final int[] SLOTS = new int[]{-3, -2, -1, 3, 2, 1, 0};
    protected final int slot;

    public TagPlayerEquipment(int slot) {
        this.slot = slot;
    }

    @Override
    public String getCategory() {
        return "playerequipment";
    }

    protected ItemStack getItemStack(int slot) {
        if (slot == -2) {
            return player.func_184592_cb();
        }
        if (slot == -1 || slot == -3) {
            return player.func_184614_ca();
        }
        return TagPlayerEquipment.player.field_71071_by.func_70440_f(slot);
    }

    public static void register() {
        for (int i = 0; i < TYPES.length; ++i) {
            TagRegistry.INSTANCE.register(new Name(SLOTS[i]).setName(TYPES[i] + "name"));
            TagRegistry.INSTANCE.register(new UniqueName(SLOTS[i]).setName(TYPES[i] + "uniquename"));
            TagRegistry.INSTANCE.register(new Damage(SLOTS[i]).setName(TYPES[i] + "damage"));
            TagRegistry.INSTANCE.register(new MaximumDamage(SLOTS[i]).setName(TYPES[i] + "maxdamage"));
            TagRegistry.INSTANCE.register(new DamageLeft(SLOTS[i]).setName(TYPES[i] + "damageleft"));
            TagRegistry.INSTANCE.register(new Quantity(SLOTS[i]).setName(TYPES[i] + "quantity"));
            TagRegistry.INSTANCE.register(new Icon(SLOTS[i], false).setName(TYPES[i] + "icon"));
            TagRegistry.INSTANCE.register(new Icon(SLOTS[i], true).setName(TYPES[i] + "largeicon"));
        }
    }

    public static class Icon
    extends TagPlayerEquipment {
        private final boolean large;

        public Icon(int slot, boolean large) {
            super(slot);
            this.large = large;
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            InfoItem item = new InfoItem(itemStack, this.large);
            info.add(item);
            return Icon.getIconTag(item);
        }
    }

    public static class Quantity
    extends TagPlayerEquipment {
        public Quantity(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            return String.valueOf(itemStack != null ? EntityHelper.getItemCountInInventory((IInventory)Quantity.player.field_71071_by, (Item)itemStack.func_77973_b(), (int)itemStack.func_77952_i()) : 0);
        }
    }

    public static class DamageLeft
    extends TagPlayerEquipment {
        public DamageLeft(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            return String.valueOf(itemStack != null && itemStack.func_77984_f() ? itemStack.func_77958_k() + 1 - itemStack.func_77952_i() : 0);
        }
    }

    public static class MaximumDamage
    extends TagPlayerEquipment {
        public MaximumDamage(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            return String.valueOf(itemStack != null && itemStack.func_77984_f() ? itemStack.func_77958_k() + 1 : 0);
        }
    }

    public static class Damage
    extends TagPlayerEquipment {
        public Damage(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            return String.valueOf(itemStack != null && itemStack.func_77984_f() ? itemStack.func_77952_i() : 0);
        }
    }

    public static class UniqueName
    extends TagPlayerEquipment {
        public UniqueName(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            Item item = itemStack != null ? itemStack.func_77973_b() : null;
            return item != null ? String.valueOf(ITEM_REGISTRY.getNameForObject((IForgeRegistryEntry)item)) : "";
        }
    }

    public static class Name
    extends TagPlayerEquipment {
        public Name(int slot) {
            super(slot);
        }

        @Override
        public String getValue() {
            ItemStack itemStack = this.getItemStack(this.slot);
            String arrows = itemStack != null && itemStack.func_77973_b() == Items.field_151031_f ? " (" + EntityHelper.getItemCountInInventory((IInventory)Name.player.field_71071_by, (Item)Items.field_151032_g) + ")" : "";
            return itemStack != null ? itemStack.func_82833_r() + arrows : "";
        }
    }
}

