/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.ingameinfo.tag;

import com.github.lunatrius.core.util.math.MBlockPos;
import com.github.lunatrius.core.world.chunk.ChunkHelper;
import com.github.lunatrius.ingameinfo.tag.Tag;
import com.github.lunatrius.ingameinfo.tag.registry.TagRegistry;
import java.util.Locale;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Biomes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.DimensionType;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;

public abstract class TagWorld
extends Tag {
    protected final MBlockPos pos = new MBlockPos();

    @Override
    public String getCategory() {
        return "world";
    }

    public static void register() {
        TagRegistry.INSTANCE.register(new Name().setName("worldname"));
        TagRegistry.INSTANCE.register(new Size().setName("worldsize"));
        TagRegistry.INSTANCE.register(new SizeMB().setName("worldsizemb"));
        TagRegistry.INSTANCE.register(new Seed().setName("seed"));
        TagRegistry.INSTANCE.register(new Difficulty().setName("difficulty"));
        TagRegistry.INSTANCE.register(new DifficultyId().setName("difficultyid"));
        TagRegistry.INSTANCE.register(new LocalDifficulty().setName("localdifficulty"));
        TagRegistry.INSTANCE.register(new Dimension().setName("dimension"));
        TagRegistry.INSTANCE.register(new DimensionId().setName("dimensionid"));
        TagRegistry.INSTANCE.register(new Biome().setName("biome"));
        TagRegistry.INSTANCE.register(new BiomeId().setName("biomeid"));
        TagRegistry.INSTANCE.register(new Daytime().setName("daytime"));
        TagRegistry.INSTANCE.register(new MoonPhase().setName("moonphase"));
        TagRegistry.INSTANCE.register(new Raining().setName("raining"));
        TagRegistry.INSTANCE.register(new Thundering().setName("thundering"));
        TagRegistry.INSTANCE.register(new Snowing().setName("snowing"));
        TagRegistry.INSTANCE.register(new NextWeatherChange().setName("nextweatherchange").setAliases("nextrain"));
        TagRegistry.INSTANCE.register(new Slimes().setName("slimes"));
        TagRegistry.INSTANCE.register(new Hardcore().setName("hardcore"));
        TagRegistry.INSTANCE.register(new Temperature().setName("temperature"));
        TagRegistry.INSTANCE.register(new LocalTemperature().setName("localtemperature"));
        TagRegistry.INSTANCE.register(new Humidity().setName("humidity"));
    }

    public static class Humidity
    extends TagWorld {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.0f", Float.valueOf(world.func_180494_b((BlockPos)playerPosition).func_76727_i() * 100.0f));
        }
    }

    public static class LocalTemperature
    extends TagWorld {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(world.func_180494_b((BlockPos)playerPosition).func_180626_a((BlockPos)playerPosition) * 100.0f));
        }
    }

    public static class Temperature
    extends TagWorld {
        @Override
        public String getValue() {
            return String.format(Locale.ENGLISH, "%.0f", Float.valueOf(world.func_180494_b((BlockPos)playerPosition).func_185353_n() * 100.0f));
        }
    }

    public static class Hardcore
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72912_H().func_76093_s());
        }
    }

    public static class Slimes
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(hasSeed && ChunkHelper.isSlimeChunk((long)seed, (BlockPos)playerPosition) || world.func_180494_b((BlockPos)playerPosition) == Biomes.field_76780_h);
        }
    }

    public static class NextWeatherChange
    extends TagWorld {
        @Override
        public String getValue() {
            if (server == null) {
                return "?";
            }
            WorldInfo worldInfo = server.func_71218_a(0).func_72912_H();
            int clearTime = worldInfo.func_176133_A();
            float seconds = (float)(clearTime > 0 ? clearTime : worldInfo.func_76083_p()) / 20.0f;
            if (seconds < 60.0f) {
                return String.format(Locale.ENGLISH, "%.1fs", Float.valueOf(seconds));
            }
            if (seconds < 3600.0f) {
                return String.format(Locale.ENGLISH, "%.1fm", Float.valueOf(seconds / 60.0f));
            }
            return String.format(Locale.ENGLISH, "%.1fh", Float.valueOf(seconds / 3600.0f));
        }
    }

    public static class Snowing
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72896_J() && world.func_180494_b((BlockPos)playerPosition).func_76746_c());
        }
    }

    public static class Thundering
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72911_I() && world.func_180494_b((BlockPos)playerPosition).func_76738_d());
        }
    }

    public static class Raining
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72896_J() && world.func_180494_b((BlockPos)playerPosition).func_76738_d());
        }
    }

    public static class MoonPhase
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72853_d());
        }
    }

    public static class Daytime
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(world.func_72967_a(1.0f) < 4);
        }
    }

    public static class BiomeId
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(net.minecraft.world.biome.Biome.func_185362_a((net.minecraft.world.biome.Biome)world.func_180494_b((BlockPos)playerPosition)));
        }
    }

    public static class Biome
    extends TagWorld {
        @Override
        public String getValue() {
            return world.func_180494_b((BlockPos)playerPosition).func_185359_l();
        }
    }

    public static class DimensionId
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(DimensionId.player.field_71093_bK);
        }
    }

    public static class Dimension
    extends TagWorld {
        @Override
        public String getValue() {
            return DimensionType.func_186069_a((int)Dimension.player.field_71093_bK).func_186065_b();
        }
    }

    public static class LocalDifficulty
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            DifficultyInstance difficulty = world.func_175649_E((BlockPos)playerPosition);
            if (server != null && (worldServer = DimensionManager.getWorld((int)LocalDifficulty.player.field_71093_bK)) != null) {
                difficulty = worldServer.func_175649_E((BlockPos)playerPosition);
            }
            return String.format(Locale.ENGLISH, "%.2f", Float.valueOf(difficulty.func_180168_b()));
        }
    }

    public static class DifficultyId
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)DifficultyId.player.field_71093_bK)) != null) {
                return String.valueOf(worldServer.func_175659_aa().func_151525_a());
            }
            return String.valueOf(DifficultyId.minecraft.field_71474_y.field_74318_M.func_151525_a());
        }
    }

    public static class Difficulty
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)Difficulty.player.field_71093_bK)) != null) {
                return I18n.func_135052_a((String)worldServer.func_175659_aa().func_151526_b(), (Object[])new Object[0]);
            }
            return I18n.func_135052_a((String)Difficulty.minecraft.field_71474_y.field_74318_M.func_151526_b(), (Object[])new Object[0]);
        }
    }

    public static class Seed
    extends TagWorld {
        @Override
        public String getValue() {
            return String.valueOf(seed);
        }
    }

    public static class SizeMB
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)SizeMB.player.field_71093_bK)) != null) {
                return String.format(Locale.ENGLISH, "%.1f", (double)worldServer.func_72912_H().func_76092_g() / 1048576.0);
            }
            return String.format(Locale.ENGLISH, "%.1f", (double)world.func_72912_H().func_76092_g() / 1048576.0);
        }
    }

    public static class Size
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)Size.player.field_71093_bK)) != null) {
                return String.valueOf(worldServer.func_72912_H().func_76092_g());
            }
            return String.valueOf(world.func_72912_H().func_76092_g());
        }
    }

    public static class Name
    extends TagWorld {
        @Override
        public String getValue() {
            WorldServer worldServer;
            if (server != null && (worldServer = DimensionManager.getWorld((int)Name.player.field_71093_bK)) != null) {
                return worldServer.func_72912_H().func_76065_j();
            }
            return world.func_72912_H().func_76065_j();
        }
    }
}

