/*
 * Decompiled with CFR 0.152.
 */
package truetyper;

import java.nio.FloatBuffer;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Matrix4f;
import truetyper.Formatter;
import truetyper.TrueTypeFont;

public class FontHelper {
    private static final String formatEscape = "\u00a7";
    private static final Pattern formattingCodePattern = Pattern.compile("(?i)" + String.valueOf('\u00a7') + "[0-9A-FK-OR]");

    public static void drawString(String s, float x, float y, TrueTypeFont font, float scaleX, float scaleY, float ... rgba) {
        FontHelper.drawString(s, x, y, font, scaleX, scaleY, 0.0f, rgba);
    }

    public static void drawCenteredString(String s, float x, float y, TrueTypeFont font, float scaleX, float scaleY, float ... rgba) {
        FontHelper.drawString(s, x - font.getWidth(s.replaceAll(formattingCodePattern.toString(), "")) / (4.0f / scaleX), y, font, scaleX, scaleY, rgba);
    }

    public static void drawString(String s, float x, float y, TrueTypeFont font, float scaleX, float scaleY, float rotationZ, float ... rgba) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc);
        if (mc.field_71474_y.field_74319_N) {
            return;
        }
        float amt = 2.0f / (float)sr.func_78325_e();
        if (sr.func_78325_e() == 1) {
            amt = 2.0f;
        }
        FloatBuffer matrixData = BufferUtils.createFloatBuffer((int)16);
        GL11.glGetFloat((int)2982, (FloatBuffer)matrixData);
        FontHelper.set2DMode(matrixData);
        GL11.glPushMatrix();
        y = (float)mc.field_71440_d - y * (float)sr.func_78325_e() - font.getLineHeight() / amt;
        float tx = x * (float)sr.func_78325_e() + font.getWidth(s) / 2.0f;
        float tranx = tx + 2.0f;
        float trany = y + font.getLineHeight() / 2.0f;
        GL11.glTranslatef((float)tranx, (float)trany, (float)0.0f);
        GL11.glRotatef((float)rotationZ, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glTranslatef((float)(-tranx), (float)(-trany), (float)0.0f);
        GL11.glEnable((int)3042);
        if (s.contains(formatEscape)) {
            String[] pars = s.split(formatEscape);
            float totalOffset = 0.0f;
            for (int i = 0; i < pars.length; ++i) {
                String par = pars[i];
                float[] c = rgba;
                if (i > 0) {
                    c = Formatter.getFormatted(par.charAt(0));
                    par = par.substring(1, par.length());
                }
                font.drawString(x * (float)sr.func_78325_e() + totalOffset, y, par, scaleX / amt, scaleY / amt, c);
                totalOffset += font.getWidth(par);
            }
        } else {
            font.drawString(x * (float)sr.func_78325_e(), y, s, scaleX / amt, scaleY / amt, rgba);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
        FontHelper.set3DMode();
    }

    private static void set2DMode(FloatBuffer matrixData) {
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution sr = new ScaledResolution(mc);
        mc.field_71460_t.func_78478_c();
        GL11.glMatrixMode((int)5889);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        GL11.glOrtho((double)0.0, (double)mc.field_71443_c, (double)0.0, (double)mc.field_71440_d, (double)-1.0, (double)1.0);
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glLoadIdentity();
        Matrix4f matrix = new Matrix4f();
        matrix.load(matrixData);
        GL11.glTranslatef((float)(matrix.m30 * (float)sr.func_78325_e()), (float)(-matrix.m31 * (float)sr.func_78325_e()), (float)0.0f);
    }

    private static void set3DMode() {
        GL11.glMatrixMode((int)5888);
        GL11.glPopMatrix();
        GL11.glMatrixMode((int)5889);
        GL11.glPopMatrix();
        Minecraft mc = Minecraft.func_71410_x();
        mc.field_71460_t.func_78478_c();
    }
}

