/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.foxlib.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.util.math.MathHelper;
import uk.kihira.foxlib.client.gui.IControl;
import uk.kihira.foxlib.client.gui.IControlCallback;

public class GuiSlider
extends GuiButton
implements IControl<Float> {
    public float currentValue;
    private float minValue;
    private float maxValue;
    private float sliderValue;
    private String preString;
    private boolean dragging = false;
    private IControlCallback parent;

    public GuiSlider(int id, int x, int y, int width, float minValue, float maxValue, float defaultValue) {
        super(id, x, y, width, 20, String.valueOf(defaultValue));
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.currentValue = defaultValue;
        this.sliderValue = MathHelper.func_76131_a((float)((this.currentValue - this.minValue) / (this.maxValue - this.minValue)), (float)0.0f, (float)1.0f);
    }

    public GuiSlider(IControlCallback parent, int id, int x, int y, int width, float minValue, float maxValue, float defaultValue) {
        this(id, x, y, width, minValue, maxValue, defaultValue);
        this.parent = parent;
    }

    public GuiSlider(IControlCallback parent, int id, int x, int y, int width, float minValue, float maxValue, float defaultValue, String displayString) {
        this(parent, id, x, y, width, minValue, maxValue, defaultValue);
        this.preString = displayString;
    }

    protected void func_146119_b(Minecraft minecraft, int xPos, int yPos) {
        if (this.field_146125_m) {
            if (this.dragging) {
                this.updateValues(xPos, yPos);
            }
            minecraft.field_71446_o.func_110577_a(field_146122_a);
            this.func_73729_b((int)((float)this.field_146128_h + this.sliderValue * (float)(this.field_146120_f - 8)), this.field_146129_i, 0, 66, 4, 20);
            this.func_73729_b((int)((float)this.field_146128_h + this.sliderValue * (float)(this.field_146120_f - 8) + 4.0f), this.field_146129_i, 196, 66, 4, 20);
        }
    }

    public boolean func_146116_c(Minecraft minecraft, int xPos, int yPos) {
        if (super.func_146116_c(minecraft, xPos, yPos)) {
            this.updateValues(xPos, yPos);
            this.dragging = true;
            return true;
        }
        return false;
    }

    public int func_146114_a(boolean bool) {
        return 0;
    }

    public void func_146118_a(int xPos, int yPos) {
        this.dragging = false;
    }

    @Override
    public void setValue(Float currentValue) {
        this.currentValue = currentValue.floatValue();
        this.sliderValue = MathHelper.func_76131_a((float)((this.currentValue - this.minValue) / (this.maxValue - this.minValue)), (float)0.0f, (float)1.0f);
        this.field_146126_j = String.valueOf(this.currentValue);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.currentValue);
    }

    private void updateValues(int xPos, int yPos) {
        float prevValue = this.currentValue;
        this.sliderValue = MathHelper.func_76131_a((float)(((float)xPos - ((float)this.field_146128_h + 4.0f)) / ((float)this.field_146120_f - 8.0f)), (float)0.0f, (float)1.0f);
        this.currentValue = (int)(this.sliderValue * (this.maxValue - this.minValue) + this.minValue);
        if (this.parent != null && !this.parent.onValueChange(this, Float.valueOf(prevValue), Float.valueOf(this.currentValue))) {
            this.setValue(Float.valueOf(prevValue));
        } else {
            this.field_146126_j = String.valueOf(this.currentValue);
        }
    }
}

