/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client;

import com.google.common.collect.ArrayListMultimap;
import java.util.List;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import uk.kihira.tails.client.model.ModelSizableMuzzle;
import uk.kihira.tails.client.model.ears.ModelCatEars;
import uk.kihira.tails.client.model.ears.ModelCatSmallEars;
import uk.kihira.tails.client.model.ears.ModelFoxEars;
import uk.kihira.tails.client.model.ears.ModelPandaEars;
import uk.kihira.tails.client.model.tail.ModelBirdTail;
import uk.kihira.tails.client.model.tail.ModelBunnyTail;
import uk.kihira.tails.client.model.tail.ModelCatTail;
import uk.kihira.tails.client.model.tail.ModelDevilTail;
import uk.kihira.tails.client.model.tail.ModelDragonTail;
import uk.kihira.tails.client.model.tail.ModelFluffyTail;
import uk.kihira.tails.client.model.tail.ModelRaccoonTail;
import uk.kihira.tails.client.model.tail.ModelSharkTail;
import uk.kihira.tails.client.render.RenderPart;
import uk.kihira.tails.client.render.RenderWings;
import uk.kihira.tails.common.PartsData;

@SideOnly(value=Side.CLIENT)
public class PartRegistry {
    private static final ArrayListMultimap<PartsData.PartType, RenderPart> partRegistry = ArrayListMultimap.create();

    public static void registerPart(PartsData.PartType partType, RenderPart renderPart) {
        partRegistry.put((Object)partType, (Object)renderPart);
    }

    public static List<RenderPart> getParts(PartsData.PartType partType) {
        return partRegistry.get((Object)partType);
    }

    public static RenderPart getRenderPart(PartsData.PartType partType, int index) {
        List<RenderPart> parts = PartRegistry.getParts(partType);
        index = index >= parts.size() ? 0 : index;
        return parts.get(index);
    }

    static {
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.fluffy", 2, new ModelFluffyTail(), null, "foxTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.dragon", 1, new ModelDragonTail(), null, "dragonTail", "dragonTailStriped").setAuthor("@TTFTCUTS", 0, 0).setAuthor("@TTFTCUTS", 1, 0));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.raccoon", 0, new ModelRaccoonTail(), null, "racoonTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.devil", 1, new ModelDevilTail(), null, "devilTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.cat", 0, new ModelCatTail(), null, "tabbyTail", "tigerTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.bird", 0, new ModelBirdTail(), null, "birdTail").setAuthor("@blusunrize", 0, 0));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.shark", 0, new ModelSharkTail(), "access_denied", "sharkTail"));
        PartRegistry.registerPart(PartsData.PartType.TAIL, new RenderPart("tail.bunny", 0, new ModelBunnyTail(), "@carrotcodes", "bunnyTail"));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.fox", 1, new ModelFoxEars(), "@Adeon", "foxEars"));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.cat", 0, new ModelCatEars(), null, "catEars"));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.panda", 0, new ModelPandaEars(), null, "pandaEars"));
        PartRegistry.registerPart(PartsData.PartType.EARS, new RenderPart("ears.catSmall", 0, new ModelCatSmallEars(), null, "catSmallEars"));
        PartRegistry.registerPart(PartsData.PartType.WINGS, new RenderWings("wings.big", 1, null, null, new String[]{"bigWings", "metalWings", "dragonWings", "dragonBonelessWings"}).setAuthor("@littlechippie").setAuthor("Dracyoshi", 0, 2).setAuthor("Dracyoshi", 0, 3).setAuthor("Dracyoshi", 1, 2).setAuthor("Dracyoshi", 1, 3));
        PartRegistry.registerPart(PartsData.PartType.MUZZLE, new RenderPart("muzzle.standard", 4, new ModelSizableMuzzle(-2.0f, -3.0f, -9.0f, 4, 3, 5), null, "standardMuzzle", "altMuzzle"));
        PartRegistry.registerPart(PartsData.PartType.MUZZLE, new RenderPart("muzzle.slim", 4, new ModelSizableMuzzle(-2.0f, -2.0f, -9.0f, 4, 2, 5), null, "standardMuzzle", "altMuzzle"));
        PartRegistry.registerPart(PartsData.PartType.MUZZLE, new RenderPart("muzzle.thin", 4, new ModelSizableMuzzle(-1.5f, -2.0f, -9.0f, 3, 2, 5, 0, 9), null, "standardMuzzle", "altMuzzle"));
    }
}

