/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client.gui;

import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.entity.player.EntityPlayer;
import uk.kihira.tails.client.gui.ControlsPanel;
import uk.kihira.tails.client.gui.GuiBase;
import uk.kihira.tails.client.gui.LibraryImportPanel;
import uk.kihira.tails.client.gui.LibraryInfoPanel;
import uk.kihira.tails.client.gui.LibraryPanel;
import uk.kihira.tails.client.gui.PartsPanel;
import uk.kihira.tails.client.gui.PreviewPanel;
import uk.kihira.tails.client.gui.TexturePanel;
import uk.kihira.tails.client.gui.TintPanel;
import uk.kihira.tails.client.texture.TextureHelper;
import uk.kihira.tails.common.PartInfo;
import uk.kihira.tails.common.PartsData;
import uk.kihira.tails.common.Tails;

public class GuiEditor
extends GuiBase {
    int textureID;
    private PartsData.PartType partType;
    private PartsData partsData;
    private PartInfo editingPartInfo;
    PartInfo originalPartInfo;
    private UUID playerUUID;
    private int guiScale;
    TintPanel tintPanel;
    PartsPanel partsPanel;
    private PreviewPanel previewPanel;
    TexturePanel texturePanel;
    private ControlsPanel controlsPanel;
    public LibraryPanel libraryPanel;
    public LibraryInfoPanel libraryInfoPanel;
    LibraryImportPanel libraryImportPanel;

    public GuiEditor() {
        super(4);
        if (Tails.localPartsData == null) {
            Tails.setLocalPartsData(new PartsData());
        }
        this.partType = PartsData.PartType.TAIL;
        for (PartsData.PartType partType : PartsData.PartType.values()) {
            if (Tails.localPartsData.hasPartInfo(partType)) continue;
            Tails.localPartsData.setPartInfo(partType, new PartInfo(false, 0, 0, 0, -65536, -16711936, -16776961, null, partType));
        }
        PartInfo partInfo = Tails.localPartsData.getPartInfo(this.partType);
        this.playerUUID = EntityPlayer.func_146094_a((GameProfile)Minecraft.func_71410_x().func_110432_I().func_148256_e());
        this.originalPartInfo = partInfo.deepCopy();
        this.setPartsData(Tails.localPartsData.deepCopy());
        this.editingPartInfo = this.originalPartInfo.deepCopy();
    }

    public void func_73866_w_() {
        int previewWindowEdgeOffset = 110;
        int previewWindowRight = this.field_146294_l - previewWindowEdgeOffset;
        int previewWindowBottom = this.field_146295_m - 30;
        int texSelectHeight = 35;
        if (this.tintPanel == null) {
            this.previewPanel = new PreviewPanel(this, previewWindowEdgeOffset, 0, previewWindowRight - previewWindowEdgeOffset, previewWindowBottom);
            this.getLayer(0).add(this.previewPanel);
            this.partsPanel = new PartsPanel(this, 0, 0, previewWindowEdgeOffset, this.field_146295_m - texSelectHeight);
            this.getLayer(1).add(this.partsPanel);
            this.libraryPanel = new LibraryPanel(this, 0, 0, previewWindowEdgeOffset, this.field_146295_m);
            this.getLayer(1).add(this.libraryPanel);
            this.texturePanel = new TexturePanel(this, 0, this.field_146295_m - texSelectHeight, previewWindowEdgeOffset, 43);
            this.getLayer(1).add(this.texturePanel);
            this.tintPanel = new TintPanel(this, previewWindowRight, 0, this.field_146294_l - previewWindowRight, this.field_146295_m);
            this.getLayer(1).add(this.tintPanel);
            this.libraryImportPanel = new LibraryImportPanel(this, previewWindowRight, this.field_146295_m - 60, this.field_146294_l - previewWindowRight, 60);
            this.getLayer(1).add(this.libraryImportPanel);
            this.libraryInfoPanel = new LibraryInfoPanel(this, previewWindowRight, 0, this.field_146294_l - previewWindowRight, this.field_146295_m - 60);
            this.getLayer(1).add(this.libraryInfoPanel);
            this.controlsPanel = new ControlsPanel(this, previewWindowEdgeOffset, previewWindowBottom, previewWindowRight - previewWindowEdgeOffset, this.field_146295_m - previewWindowBottom);
            this.getLayer(1).add(this.controlsPanel);
            this.libraryInfoPanel.enabled = false;
            this.libraryImportPanel.enabled = false;
            this.libraryPanel.enabled = false;
        } else {
            this.tintPanel.resize(previewWindowRight, 0, this.field_146294_l - previewWindowRight, this.field_146295_m);
            this.libraryInfoPanel.resize(previewWindowRight, 0, this.field_146294_l - previewWindowRight, this.field_146295_m - 60);
            this.partsPanel.resize(0, 0, previewWindowEdgeOffset, this.field_146295_m - texSelectHeight);
            this.libraryPanel.resize(0, 0, previewWindowEdgeOffset, this.field_146295_m);
            this.previewPanel.resize(previewWindowEdgeOffset, 0, previewWindowRight - previewWindowEdgeOffset, previewWindowBottom);
            this.texturePanel.resize(0, this.field_146295_m - texSelectHeight, previewWindowEdgeOffset, 43);
            this.libraryImportPanel.resize(previewWindowRight, this.field_146295_m - 60, this.field_146294_l - previewWindowRight, 60);
            this.controlsPanel.resize(previewWindowEdgeOffset, previewWindowBottom, previewWindowRight - previewWindowEdgeOffset, this.field_146295_m - previewWindowBottom);
        }
        super.func_73866_w_();
    }

    @Override
    public void func_146281_b() {
        Tails.proxy.addPartsData(this.playerUUID, Tails.localPartsData);
        super.func_146281_b();
    }

    void refreshTintPane() {
        this.tintPanel.refreshTintPane();
    }

    void setPartsInfo(PartInfo newPartInfo) {
        this.editingPartInfo = newPartInfo;
        if (this.editingPartInfo.hasPart) {
            this.editingPartInfo.setTexture(TextureHelper.generateTexture(this.playerUUID, this.editingPartInfo));
        }
        this.partsData.setPartInfo(this.partType, this.editingPartInfo);
        this.setPartsData(this.partsData);
        this.texturePanel.updateButtons();
    }

    PartInfo getEditingPartInfo() {
        return this.editingPartInfo;
    }

    public void setPartsData(PartsData newPartsData) {
        this.partsData = newPartsData;
        Tails.proxy.addPartsData(this.playerUUID, this.partsData);
    }

    public PartsData getPartsData() {
        return this.partsData;
    }

    public void setPartType(PartsData.PartType partType) {
        this.partType = partType;
        PartInfo newPartInfo = this.partsData.getPartInfo(partType);
        if (newPartInfo == null) {
            newPartInfo = new PartInfo(false, 0, 0, 0, -65536, -16711936, -16776961, null, partType);
        }
        this.originalPartInfo = newPartInfo.deepCopy();
        PartInfo partInfo = this.originalPartInfo.deepCopy();
        this.clearCurrTintEdit();
        this.setPartsInfo(partInfo);
        this.partsPanel.initPartList();
        this.refreshTintPane();
        this.textureID = partInfo.textureID;
        this.texturePanel.updateButtons();
    }

    public PartsData.PartType getPartType() {
        return this.partType;
    }

    void clearCurrTintEdit() {
        this.tintPanel.currTintEdit = 0;
    }

    private void setScale(int scale) {
        Minecraft.func_71410_x().field_71474_y.field_74335_Z = scale;
        ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x());
        int j = scaledresolution.func_78326_a();
        int k = scaledresolution.func_78328_b();
        this.func_146280_a(Minecraft.func_71410_x(), j, k);
    }
}

