/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client.gui;

import com.google.common.base.Strings;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.xml.bind.DatatypeConverter;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.Display;
import uk.kihira.foxlib.client.gui.GuiBaseScreen;
import uk.kihira.foxlib.client.toast.ToastManager;
import uk.kihira.tails.client.gui.GuiEditor;
import uk.kihira.tails.client.texture.TextureHelper;
import uk.kihira.tails.common.PartsData;
import uk.kihira.tails.common.Tails;
import uk.kihira.tails.common.network.PlayerDataMessage;

class GuiExport
extends GuiBaseScreen {
    private final GuiEditor parent;
    private final PartsData partsData;
    private ScaledResolution scaledRes;
    private String exportMessage = "";
    private URI exportLoc;
    private GuiButton openFolderButton;

    GuiExport(GuiEditor parent, PartsData partsData) {
        this.parent = parent;
        this.partsData = partsData;
    }

    public void func_73866_w_() {
        this.scaledRes = new ScaledResolution(this.field_146297_k);
        this.field_146292_n.add(new GuiBaseScreen.GuiButtonTooltip(this, 0, 20, this.field_146295_m - 90, 130, 20, I18n.func_135052_a((String)"gui.button.export.userdir", (Object[])new Object[0]), this.scaledRes.func_78326_a() / 2, I18n.func_135052_a((String)"gui.button.export.tooltip", (Object[])new Object[]{System.getProperty("user.home")})));
        this.field_146292_n.add(new GuiBaseScreen.GuiButtonTooltip(this, 1, 20, this.field_146295_m - 65, 130, 20, I18n.func_135052_a((String)"gui.button.export.minecraftdir", (Object[])new Object[0]), this.scaledRes.func_78326_a() / 2, I18n.func_135052_a((String)"gui.button.export.tooltip", (Object[])new Object[]{System.getProperty("user.dir")})));
        this.field_146292_n.add(new GuiBaseScreen.GuiButtonTooltip(this, 2, 20, this.field_146295_m - 40, 130, 20, I18n.func_135052_a((String)"gui.button.export.custom", (Object[])new Object[0]), this.scaledRes.func_78326_a() / 2, I18n.func_135052_a((String)"gui.button.export.custom.tooltip", (Object[])new Object[0])));
        this.openFolderButton = new GuiBaseScreen.GuiButtonTooltip(this, 3, this.field_146294_l - 150, this.field_146295_m - 65, 130, 20, I18n.func_135052_a((String)"gui.button.openfolder", (Object[])new Object[0]), this.scaledRes.func_78326_a() / 2, I18n.func_135052_a((String)"gui.button.openfolder.tooltip", (Object[])new Object[0]));
        this.field_146292_n.add(this.openFolderButton);
        this.openFolderButton.field_146125_m = !Strings.isNullOrEmpty((String)this.exportMessage);
        this.field_146292_n.add(new GuiBaseScreen.GuiButtonTooltip(this, 10, this.field_146294_l - 150, this.field_146295_m - 40, 130, 20, I18n.func_135052_a((String)"gui.button.upload", (Object[])new Object[0]), this.scaledRes.func_78326_a() / 2, I18n.func_135052_a((String)"tails.upload.tooltip", (Object[])new Object[0])));
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.export.title", (Object[])new Object[0]), this.field_146294_l / 2, 25, 0xFFFFFF);
        this.field_146289_q.func_78279_b(I18n.func_135052_a((String)"gui.export.information", (Object[])new Object[0]), this.field_146294_l / 6, 50, (int)((float)this.scaledRes.func_78326_a() / 1.5f), 0xFFFFFF);
        if (!Strings.isNullOrEmpty((String)this.exportMessage)) {
            this.field_146289_q.func_78279_b(this.exportMessage, 160, this.field_146295_m - 88, this.field_146294_l - 160, 0xFFFFFF);
        }
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0 || button.field_146127_k == 1 || button.field_146127_k == 2) {
            File file;
            EntityPlayerSP player = this.field_146297_k.field_71439_g;
            this.exportMessage = "";
            this.exportLoc = null;
            if (button.field_146127_k == 0) {
                file = new File(System.getProperty("user.home"));
            } else if (button.field_146127_k == 1) {
                file = new File(System.getProperty("user.dir"));
            } else {
                JFileChooser fileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
                fileChooser.setFileSelectionMode(1);
                if (fileChooser.showSaveDialog(Display.getParent()) == 0) {
                    file = fileChooser.getSelectedFile();
                } else {
                    return;
                }
            }
            if (file.exists() && file.canWrite()) {
                BufferedImage image;
                this.exportLoc = file.toURI();
                if (!(file = new File(file, File.separatorChar + player.getDisplayNameString() + ".png")).exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        this.setExportMessage(TextFormatting.DARK_RED + String.format("Failed to create skin file! %s", e));
                        e.printStackTrace();
                    }
                }
                if ((image = TextureHelper.writePartsDataToSkin(this.partsData, (AbstractClientPlayer)player)) != null) {
                    try {
                        ImageIO.write((RenderedImage)image, "png", file);
                    }
                    catch (IOException e) {
                        this.setExportMessage(TextFormatting.DARK_RED + String.format("Failed to save skin file! %s", e));
                        e.printStackTrace();
                    }
                } else {
                    this.setExportMessage(TextFormatting.DARK_RED + "Failed to export skin, image was null!");
                    file.delete();
                }
            }
            if (Strings.isNullOrEmpty((String)this.exportMessage)) {
                this.savePartsData();
                this.openFolderButton.field_146125_m = true;
                this.setExportMessage(TextFormatting.GREEN + I18n.func_135052_a((String)"tails.export.success", (Object[])new Object[]{file}));
            }
        }
        if (button.field_146127_k == 3 && this.exportLoc != null) {
            try {
                Desktop.getDesktop().browse(this.exportLoc);
            }
            catch (IOException e) {
                this.setExportMessage(TextFormatting.DARK_RED + String.format("Failed to open export location: %s", e));
                e.printStackTrace();
            }
        }
        if (button.field_146127_k == 10) {
            final BufferedImage image = TextureHelper.writePartsDataToSkin(this.partsData, (AbstractClientPlayer)this.field_146297_k.field_71439_g);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    GuiExport.this.exportMessage = I18n.func_135052_a((String)"tails.uploading", (Object[])new Object[0]);
                    new ImgurUpload().uploadImage(image);
                }
            };
            runnable.run();
        }
    }

    protected void func_73869_a(char key, int keyCode) throws IOException {
        if (keyCode == 1) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent);
        } else {
            super.func_73869_a(key, keyCode);
        }
    }

    private void setExportMessage(String message) {
        this.exportMessage = message;
        ToastManager.INSTANCE.createCenteredToast(this.field_146294_l / 2, this.field_146295_m - 45, new ScaledResolution(this.field_146297_k).func_78326_a() / 3, this.exportMessage);
    }

    private void savePartsData() {
        Tails.setLocalPartsData(this.partsData);
        Tails.proxy.addPartsData(this.field_146297_k.field_71439_g.getPersistentID(), this.partsData);
        Tails.networkWrapper.sendToServer((IMessage)new PlayerDataMessage(this.field_146297_k.func_110432_I().func_148256_e().getId(), this.partsData, false));
    }

    private class ImgurUpload {
        static final String CLIENT_ID = "ceb9fca19ef9a31";

        private ImgurUpload() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        void uploadImage(BufferedImage image) {
            block13: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                BufferedReader in = null;
                try {
                    URL url = new URL("https://api.imgur.com/3/upload.json");
                    ImageIO.write((RenderedImage)image, "png", baos);
                    baos.flush();
                    String base64Image = DatatypeConverter.printBase64Binary((byte[])baos.toByteArray());
                    String data = URLEncoder.encode("image", "UTF-8") + "=" + URLEncoder.encode(base64Image, "UTF-8");
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setDoOutput(true);
                    conn.setRequestProperty("Authorization", "Client-ID ceb9fca19ef9a31");
                    OutputStreamWriter wr = new OutputStreamWriter(conn.getOutputStream());
                    wr.write(data);
                    wr.close();
                    if (conn.getResponseCode() == 200) {
                        in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        JsonObject jsonElement = new JsonParser().parse((Reader)in).getAsJsonObject();
                        if (jsonElement.get("status").getAsInt() == 200) {
                            JsonObject dataJson = jsonElement.get("data").getAsJsonObject();
                            String id = dataJson.get("id").getAsString();
                            String imgurURL = "http://imgur.com/" + id + ".png";
                            String skinURL = "https://minecraft.net/profile/skin/remote?url=";
                            GuiExport.this.setExportMessage(TextFormatting.GREEN + I18n.func_135052_a((String)"tails.upload.success", (Object[])new Object[0]));
                            GuiExport.this.exportLoc = URI.create(skinURL + imgurURL);
                            ((GuiExport)GuiExport.this).openFolderButton.field_146125_m = true;
                            GuiExport.this.savePartsData();
                            Desktop.getDesktop().browse(GuiExport.this.exportLoc);
                        } else {
                            this.handleError(jsonElement);
                        }
                    } else if (conn.getResponseCode() != 500) {
                        in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        JsonObject jsonElement = new JsonParser().parse((Reader)in).getAsJsonObject();
                        this.handleError(jsonElement);
                    } else {
                        GuiExport.this.setExportMessage(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tails.upload.failed", (Object[])new Object[0]));
                    }
                    IOUtils.closeQuietly((OutputStream)baos);
                }
                catch (IOException e) {
                    Tails.logger.catching((Throwable)e);
                    break block13;
                }
                catch (JsonParseException e2) {
                    Tails.logger.catching((Throwable)e2);
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)baos);
                    IOUtils.closeQuietly(in);
                }
                IOUtils.closeQuietly((Reader)in);
            }
        }

        private void handleError(JsonObject json) {
            int status = json.get("status").getAsInt();
            if (status == 429 || status == 403) {
                GuiExport.this.setExportMessage(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tails.upload.ratelimit", (Object[])new Object[0]));
            } else {
                GuiExport.this.setExportMessage(TextFormatting.DARK_RED + I18n.func_135052_a((String)"tails.upload.failed", (Object[])new Object[0]));
            }
        }
    }
}

