/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import uk.kihira.foxlib.client.gui.GuiIconButton;
import uk.kihira.foxlib.client.gui.GuiList;
import uk.kihira.foxlib.client.gui.IListCallback;
import uk.kihira.tails.client.gui.GuiEditor;
import uk.kihira.tails.client.gui.LibraryListEntry;
import uk.kihira.tails.client.gui.Panel;
import uk.kihira.tails.common.LibraryEntryData;
import uk.kihira.tails.common.Tails;

public class LibraryPanel
extends Panel<GuiEditor>
implements IListCallback<LibraryListEntry> {
    private static final LibrarySorter sorter = new LibrarySorter();
    private GuiList<LibraryListEntry> list;
    private GuiTextField searchField;

    public LibraryPanel(GuiEditor parent, int left, int top, int width, int height) {
        super(parent, left, top, width, height);
    }

    public void func_73866_w_() {
        this.initList();
        this.field_146292_n.add(new GuiButtonExt(0, 3, this.field_146295_m - 18, this.field_146294_l - 6, 15, I18n.func_135052_a((String)"gui.button.all", (Object[])new Object[0])));
        this.searchField = new GuiTextField(1, this.field_146289_q, 5, this.field_146295_m - 31, this.field_146294_l - 10, 10);
        super.func_73866_w_();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.field_73735_i = -100.0f;
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -872415232, -872415232);
        this.searchField.func_146194_f();
        this.list.func_148128_a(mouseX, mouseY, p_73863_3_);
        this.field_73735_i = 0.0f;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(GuiIconButton.iconsTextures);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179109_b((float)(this.field_146294_l - 16), (float)(this.field_146295_m - 32), (float)0.0f);
        GlStateManager.func_179152_a((float)0.75f, (float)0.75f, (float)0.0f);
        this.func_73729_b(0, 0, 160, 0, 16, 16);
        GlStateManager.func_179121_F();
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            // empty if block
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.list.func_148179_a(mouseX, mouseY, mouseButton);
        this.searchField.func_146192_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_146286_b(int mouseX, int mouseY, int mouseButton) {
        super.func_146286_b(mouseX, mouseY, mouseButton);
        this.list.func_148181_b(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_146274_d() throws IOException {
        this.list.func_178039_p();
    }

    @Override
    public void func_73869_a(char key, int keycode) {
        this.searchField.func_146201_a(key, keycode);
        if (this.searchField.func_146176_q() && this.searchField.func_146206_l()) {
            List<LibraryListEntry> newEntries = this.filterListEntries(this.searchField.func_146179_b().toLowerCase());
            newEntries.add(0, new LibraryListEntry.NewLibraryListEntry(this, null));
            this.list.getEntries().clear();
            this.list.getEntries().addAll(newEntries);
        }
        super.func_73869_a(key, keycode);
    }

    @Override
    public boolean onEntrySelected(GuiList guiList, int index, LibraryListEntry entry) {
        if (!(entry instanceof LibraryListEntry.NewLibraryListEntry)) {
            ((GuiEditor)this.parent).libraryInfoPanel.setEntry(entry);
            ((GuiEditor)this.parent).setPartsData(entry.data.partsData.deepCopy());
        }
        return true;
    }

    public void initList() {
        ArrayList<LibraryListEntry> libraryEntries = new ArrayList<LibraryListEntry>();
        for (LibraryEntryData data : Tails.proxy.getLibraryManager().libraryEntries) {
            libraryEntries.add(new LibraryListEntry(data));
        }
        libraryEntries.add(0, new LibraryListEntry.NewLibraryListEntry(this, null));
        Collections.sort(libraryEntries, sorter);
        this.list = new GuiList<LibraryListEntry>(this, this.field_146294_l, this.field_146295_m - 34, 0, this.field_146295_m - 34, 50, libraryEntries);
    }

    public void addSelectedEntry(LibraryListEntry entry) {
        this.list.getEntries().add(entry);
        this.list.setCurrrentIndex(this.list.getEntries().size() - 1);
        ((GuiEditor)this.parent).libraryInfoPanel.setEntry(entry);
    }

    public void removeEntry(LibraryListEntry entry) {
        Tails.proxy.getLibraryManager().removeEntry(entry.data);
        this.list.getEntries().remove(entry);
    }

    private List<LibraryListEntry> filterListEntries(String filter) {
        ArrayList<LibraryListEntry> filteredEntries = new ArrayList<LibraryListEntry>();
        ArrayList<LibraryListEntry> entries = new ArrayList<LibraryListEntry>();
        for (LibraryEntryData data : Tails.proxy.getLibraryManager().libraryEntries) {
            entries.add(new LibraryListEntry(data));
        }
        for (LibraryListEntry entry : entries) {
            if (!(entry instanceof LibraryListEntry.NewLibraryListEntry) && !entry.data.entryName.toLowerCase().contains(filter)) continue;
            filteredEntries.add(entry);
        }
        return filteredEntries;
    }

    public void func_146281_b() {
        Tails.proxy.getLibraryManager().removeRemoteEntries();
        super.func_146281_b();
    }

    private static class LibrarySorter
    implements Comparator<LibraryListEntry> {
        private LibrarySorter() {
        }

        @Override
        public int compare(LibraryListEntry entry1, LibraryListEntry entry2) {
            if (entry1.equals(entry2)) {
                return 0;
            }
            if (entry1 instanceof LibraryListEntry.NewLibraryListEntry) {
                return Integer.MIN_VALUE;
            }
            if (entry2 instanceof LibraryListEntry.NewLibraryListEntry) {
                return Integer.MAX_VALUE;
            }
            if (entry1.data.favourite && !entry2.data.favourite) {
                return -1;
            }
            if (!entry1.data.favourite && entry2.data.favourite) {
                return 1;
            }
            return 0;
        }
    }
}

