/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import org.lwjgl.opengl.GL11;
import uk.kihira.foxlib.client.gui.GuiList;
import uk.kihira.foxlib.client.gui.IListCallback;
import uk.kihira.tails.client.ClientUtils;
import uk.kihira.tails.client.FakeEntity;
import uk.kihira.tails.client.PartRegistry;
import uk.kihira.tails.client.gui.GuiEditor;
import uk.kihira.tails.client.gui.Panel;
import uk.kihira.tails.client.render.RenderPart;
import uk.kihira.tails.common.PartInfo;
import uk.kihira.tails.common.PartsData;

public class PartsPanel
extends Panel<GuiEditor>
implements IListCallback<PartEntry> {
    private GuiList<PartEntry> partList;
    private GuiButton partTypeButton;
    private final FakeEntity fakeEntity;
    private final int listTop = 35;

    public PartsPanel(GuiEditor parent, int left, int top, int right, int bottom) {
        super(parent, left, top, right, bottom);
        this.alwaysReceiveMouse = true;
        this.fakeEntity = new FakeEntity((World)Minecraft.func_71410_x().field_71441_e);
    }

    public void func_73866_w_() {
        this.initPartList();
        this.partTypeButton = new GuiButtonExt(0, this.field_146294_l / 2 - 25, 16, 50, 16, ((GuiEditor)this.parent).getPartType().name());
        this.field_146292_n.add(this.partTypeButton);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.field_73735_i = -100.0f;
        this.func_73733_a(0, 0, this.field_146294_l, 35, -369098752, -369098752);
        this.func_73733_a(0, 35, this.field_146294_l, this.field_146295_m, -872415232, -872415232);
        this.field_73735_i = 0.0f;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.partselect", (Object[])new Object[0]), this.field_146294_l / 2, 5, 0xFFFFFF);
        this.partList.func_148128_a(mouseX, mouseY, p_73863_3_);
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            if (((GuiEditor)this.parent).getPartType().ordinal() + 1 >= PartsData.PartType.values().length) {
                ((GuiEditor)this.parent).setPartType(PartsData.PartType.values()[0]);
            } else {
                ((GuiEditor)this.parent).setPartType(PartsData.PartType.values()[((GuiEditor)this.parent).getPartType().ordinal() + 1]);
            }
            this.partTypeButton.field_146126_j = ((GuiEditor)this.parent).getPartType().name();
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.partList.func_148179_a(mouseX, mouseY, mouseButton);
    }

    @Override
    public void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.partList.func_148181_b(mouseX, mouseY, state);
    }

    @Override
    public void func_146274_d() throws IOException {
        this.partList.func_178039_p();
    }

    public void func_146281_b() {
        for (PartEntry entry : this.partList.getEntries()) {
            entry.partInfo.setTexture(null);
        }
    }

    @Override
    public boolean onEntrySelected(GuiList guiList, int index, PartEntry entry) {
        ((GuiEditor)this.parent).textureID = 0;
        PartInfo partInfo = new PartInfo(entry.partInfo.hasPart, entry.partInfo.typeid, entry.partInfo.subid, entry.partInfo.textureID, (int[])((GuiEditor)this.parent).getEditingPartInfo().tints.clone(), entry.partInfo.partType, null);
        ((GuiEditor)this.parent).setPartsInfo(partInfo);
        return true;
    }

    void initPartList() {
        ArrayList<PartEntry> partList = new ArrayList<PartEntry>();
        PartsData.PartType partType = ((GuiEditor)this.parent).getPartType();
        partList.add(new PartEntry(new PartInfo(false, 0, 0, 0, -65536, -16711936, -16776961, null, partType)));
        List<RenderPart> parts = PartRegistry.getParts(partType);
        for (int type = 0; type < parts.size(); ++type) {
            for (int subType = 0; subType <= parts.get(type).getAvailableSubTypes(); ++subType) {
                PartInfo partInfo = new PartInfo(true, type, subType, 0, -65536, -16711936, -16776961, null, partType);
                partList.add(new PartEntry(partInfo));
            }
        }
        this.partList = new GuiList<PartEntry>(this, this.field_146294_l, this.field_146295_m - 35, 35, this.field_146295_m, 55, partList);
        this.partList.field_148155_a = this.field_146294_l;
        this.selectDefaultListEntry();
    }

    void selectDefaultListEntry() {
        for (GuiListExtended.IGuiListEntry iGuiListEntry : this.partList.getEntries()) {
            PartEntry partEntry = (PartEntry)iGuiListEntry;
            PartInfo partInfo = ((GuiEditor)this.parent).getEditingPartInfo();
            if ((partEntry.partInfo.hasPart || partInfo.hasPart) && (!partInfo.hasPart || !partEntry.partInfo.hasPart || partEntry.partInfo.typeid != partInfo.typeid || partEntry.partInfo.subid != partInfo.subid)) continue;
            this.partList.setCurrrentIndex(this.partList.getEntries().indexOf(partEntry));
            break;
        }
    }

    private void renderPart(int x, int y, int z, int scale, PartInfo partInfo) {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)x, (float)y, (float)z);
        GL11.glScalef((float)(-scale), (float)scale, (float)1.0f);
        RenderHelper.func_74519_b();
        Minecraft.func_71410_x().func_175598_ae().field_78735_i = 180.0f;
        PartRegistry.getRenderPart(partInfo.partType, partInfo.typeid).render((EntityLivingBase)this.fakeEntity, partInfo, 0.0, 0.0, 0.0, 0.0f);
        RenderHelper.func_74518_a();
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77476_b);
        GL11.glDisable((int)3553);
        OpenGlHelper.func_77473_a((int)OpenGlHelper.field_77478_a);
        GL11.glPopMatrix();
    }

    class PartEntry
    implements GuiListExtended.IGuiListEntry {
        final PartInfo partInfo;

        PartEntry(PartInfo partInfo) {
            this.partInfo = partInfo;
        }

        public void func_180790_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            PartsPanel.this.field_73735_i = 0.0f;
            if (this.partInfo.hasPart) {
                RenderPart renderPart;
                boolean currentPart = PartsPanel.this.partList.getCurrrentIndex() == slotIndex;
                PartsPanel.this.renderPart(PartsPanel.this.right - 25, y - 25, currentPart ? 10 : 1, 50, this.partInfo);
                ClientUtils.drawStringMultiLine(PartsPanel.this.field_146289_q, I18n.func_135052_a((String)PartRegistry.getRenderPart(this.partInfo.partType, this.partInfo.typeid).getUnlocalisedName(this.partInfo.subid), (Object[])new Object[0]), 5, y + 17, 0xFFFFFF);
                if (currentPart && (renderPart = PartRegistry.getRenderPart(((GuiEditor)PartsPanel.this.parent).getPartType(), this.partInfo.typeid)).getModelAuthor() != null) {
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179109_b((float)5.0f, (float)(y + 27), (float)0.0f);
                    GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)1.0f);
                    PartsPanel.this.field_73735_i = 100.0f;
                    PartsPanel.this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.createdby", (Object[])new Object[0]) + ":", 0, 0, 0xFFFFFF);
                    GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
                    PartsPanel.this.field_146289_q.func_78276_b(TextFormatting.AQUA + renderPart.getModelAuthor(), 0, 0, 0xFFFFFF);
                    GlStateManager.func_179121_F();
                    PartsPanel.this.field_73735_i = 0.0f;
                }
            } else {
                PartsPanel.this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"tail.none.name", (Object[])new Object[0]), 5, y + ((PartsPanel)PartsPanel.this).partList.field_148149_f / 2 - 5, 0xFFFFFF);
            }
        }

        public void func_178011_a(int p_178011_1_, int p_178011_2_, int p_178011_3_) {
        }

        public boolean func_148278_a(int index, int mouseX, int mouseY, int mouseEvent, int mouseSlotX, int mouseSlotY) {
            return true;
        }

        public void func_148277_b(int index, int mouseX, int mouseY, int mouseEvent, int mouseSlotX, int mouseSlotY) {
        }
    }
}

