/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.client.gui;

import com.google.common.base.Strings;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.IntBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.I18n;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.input.Cursor;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import uk.kihira.foxlib.client.gui.GuiIconButton;
import uk.kihira.tails.client.gui.GuiEditor;
import uk.kihira.tails.client.gui.Panel;
import uk.kihira.tails.client.gui.controls.GuiHSBSlider;

public class TintPanel
extends Panel<GuiEditor>
implements GuiHSBSlider.IHSBSliderCallback {
    int currTintEdit = 0;
    int currTintColour = 0xFFFFFF;
    private GuiTextField hexText;
    private GuiHSBSlider[] hsbSliders;
    private GuiHSBSlider[] rgbSliders;
    private GuiIconButton tintReset;
    private GuiIconButton colourPicker;
    private IntBuffer pixelBuffer;
    private boolean selectingColour = false;
    private int editPaneTop;

    public TintPanel(GuiEditor parent, int left, int top, int width, int height) {
        super(parent, left, top, width, height);
        this.alwaysReceiveMouse = true;
    }

    public void func_73866_w_() {
        this.editPaneTop = this.field_146295_m - 107;
        int topOffset = 20;
        for (int i = 2; i <= 4; ++i) {
            this.field_146292_n.add(new GuiButton(i, 30, topOffset, 40, 20, I18n.func_135052_a((String)"gui.button.edit", (Object[])new Object[0])));
            topOffset += 35;
        }
        this.hexText = new GuiTextField(-1, this.field_146289_q, 30, this.editPaneTop + 20, 73, 10);
        this.hexText.func_146203_f(6);
        this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
        this.rgbSliders = new GuiHSBSlider[3];
        this.rgbSliders[0] = new GuiHSBSlider(5, 5, this.editPaneTop + 70, 100, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, I18n.func_135052_a((String)"gui.slider.red.tooltip", (Object[])new Object[0]));
        this.rgbSliders[1] = new GuiHSBSlider(6, 5, this.editPaneTop + 80, 100, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, I18n.func_135052_a((String)"gui.slider.green.tooltip", (Object[])new Object[0]));
        this.rgbSliders[2] = new GuiHSBSlider(7, 5, this.editPaneTop + 90, 100, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, I18n.func_135052_a((String)"gui.slider.blue.tooltip", (Object[])new Object[0]));
        this.rgbSliders[0].setHue(0.0f);
        this.rgbSliders[1].setHue(0.33333334f);
        this.rgbSliders[2].setHue(0.6666667f);
        this.field_146292_n.add(this.rgbSliders[0]);
        this.field_146292_n.add(this.rgbSliders[1]);
        this.field_146292_n.add(this.rgbSliders[2]);
        this.hsbSliders = new GuiHSBSlider[3];
        this.hsbSliders[0] = new GuiHSBSlider(15, 5, this.editPaneTop + 35, 100, 10, this, GuiHSBSlider.HSBSliderType.HUE, I18n.func_135052_a((String)"gui.slider.hue.tooltip", (Object[])new Object[0]));
        this.hsbSliders[1] = new GuiHSBSlider(16, 5, this.editPaneTop + 45, 100, 10, this, GuiHSBSlider.HSBSliderType.SATURATION, I18n.func_135052_a((String)"gui.slider.saturation.tooltip", (Object[])new Object[0]));
        this.hsbSliders[2] = new GuiHSBSlider(17, 5, this.editPaneTop + 55, 100, 10, this, GuiHSBSlider.HSBSliderType.BRIGHTNESS, I18n.func_135052_a((String)"gui.slider.brightness.tooltip", (Object[])new Object[0]));
        this.field_146292_n.add(this.hsbSliders[0]);
        this.field_146292_n.add(this.hsbSliders[1]);
        this.field_146292_n.add(this.hsbSliders[2]);
        this.tintReset = new GuiIconButton(8, this.field_146294_l - 20, this.editPaneTop + 2, GuiIconButton.Icons.UNDO, I18n.func_135052_a((String)"gui.button.reset", (Object[])new Object[0]));
        this.field_146292_n.add(this.tintReset);
        this.tintReset.field_146124_l = false;
        this.colourPicker = new GuiIconButton(21, this.field_146294_l - 36, this.editPaneTop + 1, GuiIconButton.Icons.EYEDROPPER, I18n.func_135052_a((String)"gui.button.picker.0", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.button.picker.1", (Object[])new Object[0]));
        this.field_146292_n.add(this.colourPicker);
        this.colourPicker.field_146125_m = false;
        this.refreshTintPane();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float p_73863_3_) {
        this.field_73735_i = -100.0f;
        this.func_73733_a(0, 0, this.field_146294_l, this.field_146295_m, -872415232, -872415232);
        this.field_73735_i = 0.0f;
        int topOffset = 10;
        for (int tint = 1; tint <= 3; ++tint) {
            String s = I18n.func_135052_a((String)"gui.tint", (Object[])new Object[]{tint});
            this.field_146289_q.func_78276_b(s, 5, topOffset, 0xFFFFFF);
            int colour = ((GuiEditor)this.parent).getEditingPartInfo().tints[tint - 1] | 0xFF000000;
            this.func_73733_a(5, topOffset + 10, 25, topOffset + 30, colour, colour);
            topOffset += 35;
        }
        if (this.currTintEdit > 0) {
            this.func_73730_a(0, this.field_146294_l, this.editPaneTop, -16777216);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.tint.edit", (Object[])new Object[]{this.currTintEdit}), 5, this.editPaneTop + 5, 0xFFFFFF);
            this.field_146289_q.func_78276_b(I18n.func_135052_a((String)"gui.hex", (Object[])new Object[0]) + ":", 5, this.editPaneTop + 21, 0xFFFFFF);
            this.hexText.func_146194_f();
        }
        super.func_73863_a(mouseX, mouseY, p_73863_3_);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k >= 2 && button.field_146127_k <= 4) {
            this.currTintEdit = button.field_146127_k - 1;
            this.currTintColour = ((GuiEditor)this.parent).getEditingPartInfo().tints[this.currTintEdit - 1] & 0xFFFFFF;
            this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
            this.refreshTintPane();
            this.tintReset.field_146124_l = false;
            this.colourPicker.field_146124_l = true;
        } else if (button.field_146127_k == 8) {
            this.currTintColour = ((GuiEditor)this.parent).originalPartInfo.tints[this.currTintEdit - 1] & 0xFFFFFF;
            this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
            this.refreshTintPane();
            this.tintReset.field_146124_l = false;
        } else if (button.field_146127_k == 21) {
            this.setSelectingColour(true);
        }
    }

    @Override
    public void func_73869_a(char letter, int keyCode) {
        this.hexText.func_146201_a(letter, keyCode);
        try {
            if (!Strings.isNullOrEmpty((String)this.hexText.func_146179_b())) {
                this.currTintColour = Integer.parseInt(this.hexText.func_146179_b(), 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.refreshTintPane();
        if (keyCode == 1 && this.selectingColour) {
            this.setSelectingColour(false);
        } else {
            super.func_73869_a(letter, keyCode);
        }
    }

    @Override
    public void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.selectingColour && mouseButton == 0) {
            this.currTintColour = this.getColourAtPoint(Mouse.getEventX(), Mouse.getEventY());
            this.setSelectingColour(false);
            this.refreshTintPane();
        } else {
            this.hexText.func_146192_a(mouseX, mouseY, mouseButton);
            super.func_73864_a(mouseX, mouseY, mouseButton);
        }
    }

    @Override
    public void onValueChangeHSBSlider(GuiHSBSlider source, double sliderValue) {
        if (source == this.rgbSliders[0] || source == this.rgbSliders[1] || source == this.rgbSliders[2]) {
            this.currTintColour = new Color((int)(this.rgbSliders[0].getValue() * 255.0), (int)(this.rgbSliders[1].getValue() * 255.0), (int)(this.rgbSliders[2].getValue() * 255.0)).getRGB();
        } else {
            float[] hsbvals = new float[]{(float)this.hsbSliders[0].getValue(), (float)this.hsbSliders[1].getValue(), (float)this.hsbSliders[2].getValue()};
            hsbvals[source.getType().ordinal()] = (float)sliderValue;
            this.currTintColour = Color.getHSBColor(hsbvals[0], hsbvals[1], hsbvals[2]).getRGB();
        }
        this.hexText.func_146180_a(Integer.toHexString(this.currTintColour));
        this.refreshTintPane();
    }

    private int getColourAtPoint(int x, int y) {
        int pixels = 1;
        if (this.pixelBuffer == null) {
            this.pixelBuffer = BufferUtils.createIntBuffer((int)pixels);
        }
        int[] pixelData = new int[pixels];
        GL11.glPixelStorei((int)3333, (int)1);
        GL11.glPixelStorei((int)3317, (int)1);
        this.pixelBuffer.clear();
        GlStateManager.func_187413_a((int)x, (int)y, (int)1, (int)1, (int)32993, (int)33639, (IntBuffer)this.pixelBuffer);
        this.pixelBuffer.get(pixelData);
        TextureUtil.func_147953_a((int[])pixelData, (int)1, (int)1);
        return pixelData[0] & 0xFFFFFF;
    }

    private void setSelectingColour(boolean selectingColour) {
        this.selectingColour = selectingColour;
        if (selectingColour) {
            try {
                BufferedImage bufferedImage = ImageIO.read(this.field_146297_k.func_110442_L().func_110536_a(GuiIconButton.iconsTextures).func_110527_b());
                int pixels = 256;
                int[] pixelData = new int[pixels];
                IntBuffer buffer = IntBuffer.wrap(bufferedImage.getRGB(GuiIconButton.Icons.EYEDROPPER.u, GuiIconButton.Icons.EYEDROPPER.v + 16, 16, 16, pixelData, 0, 16));
                Cursor cursor = new Cursor(16, 16, 0, 15, 1, buffer, null);
                Mouse.setNativeCursor((Cursor)cursor);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Mouse.setNativeCursor(null);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
        }
    }

    void refreshTintPane() {
        this.hexText.func_146193_g(this.currTintColour);
        Color c = new Color(this.currTintColour);
        this.rgbSliders[0].setValue((float)c.getRed() / 255.0f);
        this.rgbSliders[1].setValue((float)c.getGreen() / 255.0f);
        this.rgbSliders[2].setValue((float)c.getBlue() / 255.0f);
        float[] hsbvals = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), null);
        this.hsbSliders[0].setValue(hsbvals[0]);
        this.hsbSliders[1].setValue(hsbvals[1]);
        this.hsbSliders[2].setValue(hsbvals[2]);
        this.hsbSliders[1].setHue((float)this.hsbSliders[0].getValue());
        this.hsbSliders[1].setBrightness((float)this.hsbSliders[2].getValue());
        if (this.currTintEdit > 0) {
            this.rgbSliders[2].field_146125_m = true;
            this.rgbSliders[1].field_146125_m = true;
            this.rgbSliders[0].field_146125_m = true;
            this.hsbSliders[2].field_146125_m = true;
            this.hsbSliders[1].field_146125_m = true;
            this.hsbSliders[0].field_146125_m = true;
            this.tintReset.field_146125_m = true;
            this.colourPicker.field_146125_m = true;
        } else {
            this.rgbSliders[2].field_146125_m = false;
            this.rgbSliders[1].field_146125_m = false;
            this.rgbSliders[0].field_146125_m = false;
            this.hsbSliders[2].field_146125_m = false;
            this.hsbSliders[1].field_146125_m = false;
            this.hsbSliders[0].field_146125_m = false;
            this.tintReset.field_146125_m = false;
            this.colourPicker.field_146125_m = false;
        }
        this.tintReset.field_146124_l = true;
        if (this.currTintEdit > 0) {
            ((GuiEditor)this.parent).getEditingPartInfo().tints[this.currTintEdit - 1] = this.currTintColour | 0xFF000000;
        }
        ((GuiEditor)this.parent).setPartsInfo(((GuiEditor)this.parent).getEditingPartInfo());
    }
}

