/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.common;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import net.minecraftforge.fml.common.versioning.ComparableVersion;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.fml.common.versioning.VersionParser;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.IFMLCallHook;
import net.minecraftforge.fml.relauncher.IFMLLoadingPlugin;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.CountingOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.Display;

public class FoxLibManager
implements IFMLCallHook,
IFMLLoadingPlugin {
    private static final String foxlibVersion = "1.10.2-0.11.1";
    private static final String foxlibReqVersion = "[0.10.0,)";
    private static final String foxlibFileName = "FoxLib-1.10.2-0.11.1.jar";
    private static final String foxlibDownloadLink = "http://addons-origin.cursecdn.com/files/2307/728/FoxLib-1.9.4-0.10.0.jar";
    private static final String foxlibDownloadFallback = "http://minecraft.curseforge.com/mc-mods/223291-kihira.foxlib/files";
    public static final Logger logger = LogManager.getLogger((String)"FoxLib Manager");
    static final String MC_VERSION = "1.10.2";
    private static final Pattern pattern = Pattern.compile("(\\w+)[-][\\d\\.]+.*?([\\d\\.]{5,})[\\w]*.*?\\.jar", 2);
    private int totalSize;

    public String[] getASMTransformerClass() {
        return null;
    }

    public String getModContainerClass() {
        return null;
    }

    public String getSetupClass() {
        return this.getClass().getName();
    }

    public void injectData(Map<String, Object> data) {
    }

    public String getAccessTransformerClass() {
        return null;
    }

    public Void call() throws Exception {
        byte[] bs = Launch.classLoader.getClassBytes("net.minecraft.world.World");
        if (bs != null) {
            logger.warn("We are in a dev environment, skipping version check");
        } else {
            this.checkFoxLib();
        }
        return null;
    }

    private void checkFoxLib() {
        TreeMap<ComparableVersion, File> foxLibs = this.buildFoxLibFileList();
        if (foxLibs.size() >= 2) {
            int i = 0;
            for (File file : foxLibs.values()) {
                if (i == 0) {
                    ++i;
                    continue;
                }
                logger.info("Removing old version of FoxLib with the name " + file.getName());
                if (file.delete()) continue;
                logger.error("Failed to delete file, removing on exit");
                file.deleteOnExit();
            }
        } else if (foxLibs.size() == 0) {
            if (!GraphicsEnvironment.isHeadless()) {
                this.showDownloadOptionDialog("FoxLib is not installed and required! Would you like to download it?");
                this.checkFoxLib();
            } else {
                logger.error("FoxLib is REQUIRED to use Tails and must be downloaded in order to use the mod");
                System.exit(-1);
            }
        } else if (!VersionParser.parseRange((String)foxlibReqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion("1.10.2-" + foxLibs.firstKey().toString()))) {
            if (!GraphicsEnvironment.isHeadless()) {
                this.showDownloadOptionDialog("FoxLib is not the required version! Would you like to update it?");
                this.checkFoxLib();
            } else {
                logger.error("A newer version of FoxLib is REQUIRED to use Tails and must be downloaded in order to use the mod");
                System.exit(-1);
            }
        }
    }

    private TreeMap<ComparableVersion, File> buildFoxLibFileList() {
        File[] files = new File((File)FMLInjectionData.data()[6], "mods").listFiles();
        TreeMap<ComparableVersion, File> foxLibs = new TreeMap<ComparableVersion, File>(new Comparator<ComparableVersion>(){

            @Override
            public int compare(ComparableVersion o1, ComparableVersion o2) {
                return o2.compareTo(o1);
            }
        });
        this.findFoxlibFiles(foxLibs, files);
        File dir = new File((File)FMLInjectionData.data()[6], "mods" + File.separator + MC_VERSION);
        if (dir.exists()) {
            files = dir.listFiles();
            this.findFoxlibFiles(foxLibs, files);
        }
        return foxLibs;
    }

    private void findFoxlibFiles(TreeMap<ComparableVersion, File> map, File[] files) {
        for (File file : files) {
            String name;
            Matcher matcher = pattern.matcher(file.getName());
            if (!matcher.matches() || !(name = matcher.group(1)).equalsIgnoreCase("FoxLib")) continue;
            ComparableVersion version = new ComparableVersion(matcher.group(2));
            map.put(version, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void showDownloadOptionDialog(String message) {
        block9: {
            int opt;
            block10: {
                logger.info("Requesting users input for FoxLib. Check your windows!");
                logger.info(message);
                opt = JOptionPane.showConfirmDialog(Display.getParent(), message);
                if (opt != 0) break block10;
                File target = null;
                FileOutputStream output = null;
                InputStream input = null;
                try {
                    File dir = new File((File)FMLInjectionData.data()[6], "mods" + File.separator + MC_VERSION);
                    if (dir.exists()) {
                        logger.info("Detected MC specific sub directory, downloading to there instead of main directory");
                        target = new File(dir, File.separator + foxlibFileName);
                    } else {
                        target = new File((File)FMLInjectionData.data()[6], "mods" + File.separator + foxlibFileName);
                    }
                    URL download = new URL(foxlibDownloadLink);
                    output = new FileOutputStream(target);
                    input = download.openStream();
                    this.totalSize = Integer.valueOf(download.openConnection().getHeaderField("Content-Length"));
                    final ProgressMonitor monitor = new ProgressMonitor(Display.getParent(), "Downloading FoxLib", null, 0, this.totalSize - 100);
                    monitor.setMillisToPopup(0);
                    final InputStream finalInput = input;
                    final FileOutputStream finalOutput = output;
                    new Runnable(){

                        @Override
                        public void run() {
                            DownloadCountingOutputStream countingOutputStream = new DownloadCountingOutputStream(finalOutput, monitor);
                            try {
                                IOUtils.copy((InputStream)finalInput, (OutputStream)((Object)countingOutputStream));
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            finally {
                                monitor.close();
                            }
                        }
                    }.run();
                    IOUtils.closeQuietly((OutputStream)output);
                }
                catch (IOException e) {
                    if (!target.delete()) {
                        target.deleteOnExit();
                    }
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(Display.getParent(), "Failed to download FoxLib! Manually download from http://minecraft.curseforge.com/mc-mods/223291-kihira.foxlib/files", "Download Failed", 0);
                    logger.error("FoxLib is REQUIRED to use Tails and must be downloaded in order to use the mod");
                    FMLCommonHandler.instance().exitJava(-1, true);
                    break block9;
                }
                finally {
                    IOUtils.closeQuietly(output);
                    IOUtils.closeQuietly(input);
                }
                IOUtils.closeQuietly((InputStream)input);
                break block9;
            }
            if (opt == -1 || opt == 1) {
                logger.error("FoxLib is REQUIRED to use Tails and must be downloaded in order to use the mod");
                System.exit(-1);
            }
        }
    }

    private class DownloadCountingOutputStream
    extends CountingOutputStream {
        private final ProgressMonitor update;

        DownloadCountingOutputStream(OutputStream out, ProgressMonitor update) {
            super(out);
            this.update = update;
        }

        protected void afterWrite(int n) throws IOException {
            super.afterWrite(n);
            this.update.setProgress((int)this.getByteCount());
        }
    }
}

