/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.common;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.apache.commons.io.IOUtils;
import uk.kihira.tails.client.gui.GuiEditor;
import uk.kihira.tails.common.LibraryEntryData;
import uk.kihira.tails.common.Tails;
import uk.kihira.tails.common.network.LibraryEntriesMessage;

public class LibraryManager {
    public final List<LibraryEntryData> libraryEntries = this.loadLibrary();

    public void addEntries(List<? extends LibraryEntryData> entries) {
        this.libraryEntries.addAll(entries);
    }

    public void addEntry(LibraryEntryData data) {
        this.libraryEntries.add(data);
    }

    public void removeEntry(LibraryEntryData data) {
        this.libraryEntries.remove(data);
    }

    public void removeRemoteEntries() {
        Iterator<LibraryEntryData> iterator = this.libraryEntries.iterator();
        while (iterator.hasNext()) {
            LibraryEntryData entry = iterator.next();
            if (!entry.remoteEntry) continue;
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<LibraryEntryData> loadLibrary() {
        FileReader fileReader;
        ArrayList<LibraryEntryData> libraryEntries;
        block5: {
            Gson gson = Tails.gson;
            libraryEntries = new ArrayList<LibraryEntryData>();
            fileReader = null;
            try {
                fileReader = new FileReader(this.getLibraryFile());
                List loadedEntries = (List)gson.fromJson((Reader)fileReader, new TypeToken<List<LibraryEntryData>>(){}.getType());
                if (loadedEntries == null || loadedEntries.size() <= 0) break block5;
                for (LibraryEntryData libEntry : loadedEntries) {
                    if (libEntry.partsData == null) continue;
                    libraryEntries.add(libEntry);
                }
            }
            catch (FileNotFoundException e) {
                try {
                    Tails.logger.catching((Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(fileReader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)fileReader);
            }
        }
        IOUtils.closeQuietly((Reader)fileReader);
        return libraryEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveLibrary() {
        ArrayList<LibraryEntryData> entries = new ArrayList<LibraryEntryData>();
        FileWriter fileWriter = null;
        for (LibraryEntryData libraryListEntry : this.libraryEntries) {
            if (libraryListEntry.remoteEntry) continue;
            entries.add(libraryListEntry);
        }
        try {
            fileWriter = new FileWriter(this.getLibraryFile());
            Tails.gson.toJson(entries, (Appendable)fileWriter);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fileWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)fileWriter);
        }
        IOUtils.closeQuietly((Writer)fileWriter);
    }

    private File getLibraryFile() {
        File libraryFile = new File("tailslibrary.json");
        if (!libraryFile.exists()) {
            try {
                libraryFile.createNewFile();
            }
            catch (IOException e) {
                Tails.logger.error("Failed to create a library file!", (Throwable)e);
            }
        }
        return libraryFile;
    }

    public static class ClientLibraryManager
    extends LibraryManager {
        @Override
        public void addEntries(List<? extends LibraryEntryData> entries) {
            super.addEntries(entries);
            GuiScreen guiScreen = Minecraft.func_71410_x().field_71462_r;
            if (guiScreen instanceof GuiEditor) {
                GuiEditor editor = (GuiEditor)guiScreen;
                if (editor.libraryPanel != null && editor.libraryInfoPanel != null) {
                    ((GuiEditor)guiScreen).libraryPanel.initList();
                }
                ((GuiEditor)guiScreen).libraryInfoPanel.setEntry(null);
            }
        }

        @Override
        public void removeEntry(final LibraryEntryData data) {
            if (data.remoteEntry) {
                Tails.networkWrapper.sendToServer((IMessage)new LibraryEntriesMessage((List<LibraryEntryData>)new ArrayList<LibraryEntryData>(){
                    {
                        this.add(data);
                    }
                }, true));
            } else {
                super.removeEntry(data);
            }
        }
    }
}

