/*
 * Decompiled with CFR 0.152.
 */
package uk.kihira.tails.common;

import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import uk.kihira.tails.common.PartsData;

public class PartInfo
implements Cloneable {
    @Expose
    public final boolean hasPart;
    @Expose
    public final int typeid;
    @Expose
    public final int subid;
    @Expose
    public final int[] tints;
    @Expose
    public final int textureID;
    @Expose
    public PartsData.PartType partType;
    private ResourceLocation texture;
    public boolean needsTextureCompile = true;

    public PartInfo(boolean hasPart, int type, int subtype, int textureID, int[] tints, PartsData.PartType partType, ResourceLocation texture) {
        this.hasPart = hasPart;
        this.typeid = type;
        this.subid = subtype;
        this.textureID = textureID;
        this.tints = tints;
        this.partType = partType;
        this.texture = texture;
    }

    public PartInfo(boolean hasPart, int type, int subtype, int textureID, int tint1, int tint2, int tint3, ResourceLocation texture, PartsData.PartType partType) {
        this(hasPart, type, subtype, textureID, new int[]{tint1, tint2, tint3}, partType, texture);
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public void setTexture(ResourceLocation texture) {
        if (texture == null || this.texture != null && !this.texture.equals((Object)texture)) {
            try {
                Minecraft.func_71410_x().field_71446_o.func_147645_c(this.texture);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.needsTextureCompile = true;
        } else {
            this.needsTextureCompile = false;
        }
        this.texture = texture;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartInfo partInfo = (PartInfo)o;
        if (this.hasPart != partInfo.hasPart) {
            return false;
        }
        if (this.subid != partInfo.subid) {
            return false;
        }
        if (this.textureID != partInfo.textureID) {
            return false;
        }
        if (this.typeid != partInfo.typeid) {
            return false;
        }
        if (this.partType != partInfo.partType) {
            return false;
        }
        return Arrays.equals(this.tints, partInfo.tints);
    }

    public int hashCode() {
        int result = this.hasPart ? 1 : 0;
        result = 31 * result + this.typeid;
        result = 31 * result + this.subid;
        result = 31 * result + Arrays.hashCode(this.tints);
        result = 31 * result + this.textureID;
        result = 31 * result + this.partType.hashCode();
        return result;
    }

    public String toString() {
        return "PartInfo{hasPart=" + this.hasPart + ", typeid=" + this.typeid + ", subid=" + this.subid + ", tints=" + Arrays.toString(this.tints) + ", textureID=" + this.textureID + ", partType=" + (Object)((Object)this.partType) + ", texture=" + this.texture + '}';
    }

    public PartInfo deepCopy() {
        Gson gson = new Gson();
        return (PartInfo)gson.fromJson(gson.toJson((Object)this), PartInfo.class);
    }
}

