/*
 * Decompiled with CFR 0.152.
 */
package cad97.spawnercraft.init;

import cad97.spawnercraft.handler.ConfigHandler;
import cad97.spawnercraft.utility.LogHelper;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class SpawnerCraftMobAlias {
    public static final Map<String, NBTTagCompound> customNBT = new HashMap<String, NBTTagCompound>();
    public static final Map<String, String> aliasedIDs = new HashMap<String, String>();
    public static final Map<String, EntityList.EntityEggInfo> customEggs = new HashMap<String, EntityList.EntityEggInfo>();

    public static void registerMobAliases() {
        NBTTagCompound mainHand;
        NBTTagList handItems;
        if (ConfigHandler.witherSkeletonSoul && !EntityList.field_75627_a.containsKey("WitherSkeleton")) {
            NBTTagCompound wither = new NBTTagCompound();
            wither.func_74778_a("id", "WitherSkeleton");
            wither.func_74774_a("SkeletonType", (byte)1);
            handItems = new NBTTagList();
            mainHand = new NBTTagCompound();
            mainHand.func_74778_a("id", "minecraft:stone_sword");
            handItems.func_74742_a((NBTBase)mainHand);
            wither.func_74782_a("HandItems", (NBTBase)handItems);
            customNBT.put("WitherSkeleton", wither);
            aliasedIDs.put("WitherSkeleton", "Skeleton");
        }
        if (ConfigHandler.straySoul && !EntityList.field_75627_a.containsKey("Stray")) {
            NBTTagCompound stray = new NBTTagCompound();
            stray.func_74778_a("id", "Stray");
            stray.func_74774_a("SkeletonType", (byte)2);
            handItems = new NBTTagList();
            mainHand = new NBTTagCompound();
            mainHand.func_74778_a("id", "minecraft:bow");
            handItems.func_74742_a((NBTBase)mainHand);
            stray.func_74782_a("HandItems", (NBTBase)handItems);
            customNBT.put("Stray", stray);
            aliasedIDs.put("Stray", "Skeleton");
        }
        if (ConfigHandler.huskSoul && !EntityList.field_75627_a.containsKey("Husk")) {
            NBTTagCompound husk = new NBTTagCompound();
            husk.func_74778_a("id", "Husk");
            husk.func_74774_a("ZombieType", (byte)6);
            customNBT.put("Husk", husk);
            aliasedIDs.put("Husk", "Zombie");
        }
        if (ConfigHandler.elderGuardianSoul && !EntityList.field_75627_a.containsKey("ElderGuardian")) {
            NBTTagCompound elder = new NBTTagCompound();
            elder.func_74778_a("id", "ElderGuardian");
            elder.func_74774_a("Elder", (byte)1);
            customNBT.put("ElderGuardian", elder);
            aliasedIDs.put("ElderGuardian", "Guardian");
        }
        if (ConfigHandler.donkeySoul && !EntityList.field_75627_a.containsKey("Donkey")) {
            NBTTagCompound donkey = new NBTTagCompound();
            donkey.func_74778_a("id", "Donkey");
            donkey.func_74774_a("Type", (byte)1);
            customNBT.put("Donkey", donkey);
            aliasedIDs.put("Donkey", "EntityHorse");
        }
        if (ConfigHandler.muleSoul && !EntityList.field_75627_a.containsKey("Mule")) {
            NBTTagCompound mule = new NBTTagCompound();
            mule.func_74778_a("id", "Mule");
            mule.func_74774_a("Type", (byte)2);
            customNBT.put("Mule", mule);
            aliasedIDs.put("Mule", "EntityHorse");
        }
        if (ConfigHandler.skeletonHorseSoul && !EntityList.field_75627_a.containsKey("SkeletonHorse")) {
            NBTTagCompound sHorse = new NBTTagCompound();
            sHorse.func_74778_a("id", "SkeletonHorse");
            sHorse.func_74774_a("Type", (byte)4);
            customNBT.put("SkeletonHorse", sHorse);
            aliasedIDs.put("SkeletonHorse", "EntityHorse");
        }
        SpawnerCraftMobAlias.registerEggInfo();
        LogHelper.logInfo("Mob Aliases registered.");
        LogHelper.logDebug("These are only usable internally.");
    }

    private static void registerEggInfo() {
        if (ConfigHandler.witherSkeletonSoul) {
            customEggs.put("WitherSkeleton", new EntityList.EntityEggInfo(null, 0x131313, 0x3D3D3D));
        }
        if (ConfigHandler.straySoul) {
            customEggs.put("Stray", new EntityList.EntityEggInfo(null, 0x6F6F6F, 0xB8B8B8));
        }
        if (ConfigHandler.huskSoul) {
            customEggs.put("Husk", new EntityList.EntityEggInfo(null, 7432539, 11903349));
        }
        if (ConfigHandler.elderGuardianSoul) {
            customEggs.put("ElderGuardian", new EntityList.EntityEggInfo(null, 12631726, 0x5C5C75));
        }
        if (ConfigHandler.donkeySoul) {
            customEggs.put("Donkey", new EntityList.EntityEggInfo(null, 5062709, 6970448));
        }
        if (ConfigHandler.muleSoul) {
            customEggs.put("Mule", new EntityList.EntityEggInfo(null, 1638912, 4204567));
        }
        if (ConfigHandler.skeletonHorseSoul) {
            customEggs.put("SkeletonHorse", new EntityList.EntityEggInfo(null, 6381898, 0xB4B4AA));
        }
    }
}

