/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.capability;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.capability.ISculptSettingsHandler;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.packet.PacketSyncAllSculptingData;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SculptSettingsHandler
implements ICapabilityProvider,
ISculptSettingsHandler,
INBTSerializable<NBTTagCompound> {
    @CapabilityInject(value=ISculptSettingsHandler.class)
    public static final Capability<ISculptSettingsHandler> SCULPT_SETTINGS_CAP = null;
    public int mode;
    public int direction;
    public int shapeTypeCurved;
    public int shapeTypeFlat;
    public int sculptSemiDiameter;
    public int wallThickness;
    public boolean targetBitGridVertexes;
    public boolean sculptHollowShapeWire;
    public boolean sculptHollowShapeSpade;
    public boolean openEnds;
    public ItemStack setBitWire;
    public ItemStack setBitSpade;

    public SculptSettingsHandler(int mode, int direction, int shapeTypeCurved, int shapeTypeFlat, boolean targetBitGridVertexes, int sculptSemiDiameter, boolean sculptHollowShapeWire, boolean sculptHollowShapeSpade, boolean openEnds, int wallThickness, ItemStack setBitWire, ItemStack setBitSpade) {
        this.mode = mode;
        this.direction = direction;
        this.shapeTypeCurved = shapeTypeCurved;
        this.shapeTypeFlat = shapeTypeFlat;
        this.targetBitGridVertexes = targetBitGridVertexes;
        this.sculptSemiDiameter = sculptSemiDiameter;
        this.sculptHollowShapeWire = sculptHollowShapeWire;
        this.sculptHollowShapeSpade = sculptHollowShapeSpade;
        this.openEnds = openEnds;
        this.wallThickness = wallThickness;
        this.setBitWire = setBitWire;
        this.setBitSpade = setBitSpade;
    }

    public SculptSettingsHandler() {
        this.mode = Configs.sculptMode.getDefaultValue();
        this.direction = Configs.sculptDirection.getDefaultValue();
        this.shapeTypeCurved = Configs.sculptShapeTypeCurved.getDefaultValue();
        this.shapeTypeFlat = Configs.sculptShapeTypeFlat.getDefaultValue();
        this.targetBitGridVertexes = Configs.sculptTargetBitGridVertexes.getDefaultValue();
        this.sculptSemiDiameter = Configs.sculptSemiDiameter.getDefaultValue();
        this.sculptHollowShapeWire = Configs.sculptHollowShapeWire.getDefaultValue();
        this.sculptHollowShapeSpade = Configs.sculptHollowShapeSpade.getDefaultValue();
        this.openEnds = Configs.sculptOpenEnds.getDefaultValue();
        this.wallThickness = Configs.sculptWallThickness.getDefaultValue();
        this.setBitWire = Configs.sculptSetBitWire.getDefaultValue();
        this.setBitSpade = Configs.sculptSetBitSpade.getDefaultValue();
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return SCULPT_SETTINGS_CAP != null && capability == SCULPT_SETTINGS_CAP;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        return (T)(capability == SCULPT_SETTINGS_CAP ? SCULPT_SETTINGS_CAP.cast((Object)this) : null);
    }

    public static ISculptSettingsHandler getCapability(EntityPlayer player) {
        return (ISculptSettingsHandler)player.getCapability(SCULPT_SETTINGS_CAP, null);
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("mode", this.mode);
        nbt.func_74768_a("direction", this.direction);
        nbt.func_74768_a("shapeTypeCurved", this.shapeTypeCurved);
        nbt.func_74768_a("shapeTypeFlat", this.shapeTypeFlat);
        nbt.func_74757_a("targetBitGridVertexes", this.targetBitGridVertexes);
        nbt.func_74768_a("sculptSemiDiameter", this.sculptSemiDiameter);
        nbt.func_74757_a("sculptHollowShapeWire", this.sculptHollowShapeWire);
        nbt.func_74757_a("sculptHollowShapeSpade", this.sculptHollowShapeSpade);
        nbt.func_74757_a("openEnds", this.openEnds);
        nbt.func_74768_a("wallThickness", this.wallThickness);
        ItemStackHelper.saveStackToNBT(nbt, this.setBitWire, "setBitWire");
        ItemStackHelper.saveStackToNBT(nbt, this.setBitSpade, "setBitSpade");
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.mode = nbt.func_74762_e("mode");
        this.direction = nbt.func_74762_e("direction");
        this.shapeTypeCurved = nbt.func_74762_e("shapeTypeCurved");
        this.shapeTypeFlat = nbt.func_74762_e("shapeTypeFlat");
        this.targetBitGridVertexes = nbt.func_74767_n("targetBitGridVertexes");
        this.sculptSemiDiameter = nbt.func_74762_e("sculptSemiDiameter");
        this.sculptHollowShapeWire = nbt.func_74767_n("sculptHollowShapeWire");
        this.sculptHollowShapeSpade = nbt.func_74767_n("sculptHollowShapeSpade");
        this.openEnds = nbt.func_74767_n("openEnds");
        this.wallThickness = nbt.func_74762_e("wallThickness");
        this.setBitWire = ItemStackHelper.loadStackFromNBT(nbt, "setBitWire");
        this.setBitSpade = ItemStackHelper.loadStackFromNBT(nbt, "setBitSpade");
    }

    @Override
    public void syncAllData(EntityPlayerMP player) {
        ExtraBitManipulation.packetNetwork.sendTo((IMessage)new PacketSyncAllSculptingData(this.mode, this.direction, this.shapeTypeCurved, this.shapeTypeFlat, this.targetBitGridVertexes, this.sculptSemiDiameter, this.sculptHollowShapeWire, this.sculptHollowShapeSpade, this.openEnds, this.wallThickness, this.setBitWire, this.setBitSpade), player);
    }

    @Override
    public int getMode() {
        return this.mode;
    }

    @Override
    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(int direction) {
        this.direction = direction;
    }

    @Override
    public int getShapeTypeCurved() {
        return this.shapeTypeCurved;
    }

    @Override
    public void setShapeTypeCurved(int shapeTypeCurved) {
        this.shapeTypeCurved = shapeTypeCurved;
    }

    @Override
    public int getShapeTypeFlat() {
        return this.shapeTypeFlat;
    }

    @Override
    public void setShapeTypeFlat(int shapeTypeFlat) {
        this.shapeTypeFlat = shapeTypeFlat;
    }

    @Override
    public int getSculptSemiDiameter() {
        return this.sculptSemiDiameter;
    }

    @Override
    public void setSculptSemiDiameter(int sculptSemiDiameter) {
        this.sculptSemiDiameter = sculptSemiDiameter;
    }

    @Override
    public int getWallThickness() {
        return this.wallThickness;
    }

    @Override
    public void setWallThickness(int wallThickness) {
        this.wallThickness = wallThickness;
    }

    @Override
    public boolean isBitGridTargeted() {
        return this.targetBitGridVertexes;
    }

    @Override
    public void setBitGridTargeted(boolean targetBitGridVertexes) {
        this.targetBitGridVertexes = targetBitGridVertexes;
    }

    @Override
    public boolean isShapeHollowWire() {
        return this.sculptHollowShapeWire;
    }

    @Override
    public void setShapeHollowWire(boolean sculptHollowShapeWire) {
        this.sculptHollowShapeWire = sculptHollowShapeWire;
    }

    @Override
    public boolean isShapeHollowSpade() {
        return this.sculptHollowShapeSpade;
    }

    @Override
    public void setShapeHollowSpade(boolean sculptHollowShapeSpade) {
        this.sculptHollowShapeSpade = sculptHollowShapeSpade;
    }

    @Override
    public boolean areEndsOpen() {
        return this.openEnds;
    }

    @Override
    public void setEndsOpen(boolean openEnds) {
        this.openEnds = openEnds;
    }

    @Override
    public ItemStack getBitStackWire() {
        return this.setBitWire;
    }

    @Override
    public void setBitStackWire(ItemStack setBitWire) {
        this.setBitWire = setBitWire;
    }

    @Override
    public ItemStack getBitStackSpade() {
        return this.setBitSpade;
    }

    @Override
    public void setBitStackSpade(ItemStack setBitSpade) {
        this.setBitSpade = setBitSpade;
    }
}

