/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.config;

import com.phylogeny.extrabitmanipulation.config.ConfigHandlerExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.config.ConfigNamed;
import com.phylogeny.extrabitmanipulation.config.ConfigShapeRender;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.item.Item;
import net.minecraftforge.common.config.ConfigElement;
import net.minecraftforge.fml.client.config.DummyConfigElement;
import net.minecraftforge.fml.client.config.GuiConfig;
import net.minecraftforge.fml.client.config.IConfigElement;

public class GuiConfigExtraBitManipulation
extends GuiConfig {
    public GuiConfigExtraBitManipulation(GuiScreen parentScreen) {
        super(parentScreen, GuiConfigExtraBitManipulation.getConfigElements(), "ExtraBitManipulation", false, false, GuiConfig.getAbridgedConfigPath((String)ConfigHandlerExtraBitManipulation.configFile.toString()));
    }

    private static List<IConfigElement> getConfigElements() {
        ArrayList<IConfigElement> configElements = new ArrayList<IConfigElement>();
        GuiConfigExtraBitManipulation.addChildElementsToDummyElement("Tool Settings", "Configures sculpting dimensions, wrench inversion mode, the way bits are handled when removed from the world, and the way bit removal/addition areas are displayed. (applies to all sculpting tools -- see 'Item Properties' menu for item-specific settings)", configElements);
        GuiConfigExtraBitManipulation.addDummyElementsOfChildElementSetsToDummyElement(configElements, false, "Default Values", "Configures sculpting data default values.", "Per Tool or Per Player", "Configures whether sculpting data is stored/assessed on/from individual tools or on/from the player.", "Display In Chat", "Configures whether changes to sculpting data are displayed in chat.", "Sculpting Data Settings", "Configures sculpting data storage/assesses, default values, and chat notifications upon change. (applies to all sculpting tools -- see 'Item Properties' menu for item-specific settings)");
        GuiConfigExtraBitManipulation.addDummyElementsOfProcessedChildElementSetsToDummyElement(configElements, Configs.itemPropertyMap, "Item Properties", "Configures the damage characteristics and default data of the Bit Wrench and Sculpting Tools", false);
        GuiConfigExtraBitManipulation.addDummyElementsOfProcessedChildElementSetsToDummyElement(configElements, Configs.itemRecipeMap, "Recipes", "Configures the recipe for the Bit Wrench", true);
        GuiConfigExtraBitManipulation.addDummyElementsOfProcessedChildElementSetsToDummyElement(configElements, Configs.itemShapes, "Bit Wrench Overlays", "Configures the way the Bit Wrench overlays are rendered", "Sculpting Tool Shapes", "Configures the Sculpting Tools' bit removal/addition shapes/boxes", "Rendering", "Configures the rendering of the Bit Wrench's overlays and the Sculpting Tools' bit removal/addition shapes/boxes");
        return configElements;
    }

    private static void addDummyElementsOfProcessedChildElementSetsToDummyElement(List<IConfigElement> configElements, ConfigShapeRender[] config, String ... names) {
        ArrayList<IConfigElement> childElements = new ArrayList<IConfigElement>();
        int startLen = names.length;
        for (int i = 0; i < startLen - 4; i += 2) {
            GuiConfigExtraBitManipulation.addChildElementsToDummyElement(names[i], names[i + 1], childElements);
        }
        int endLen = config.length * 2 + 2;
        String[] processedNames = new String[endLen];
        for (int i = 0; i < endLen - 2; ++i) {
            int shapeIndex = i / 2;
            processedNames[i] = i % 2 == 0 ? config[shapeIndex].getTitle() : "Configures the color/alpha/line-width of the " + GuiConfigExtraBitManipulation.getInsertText(shapeIndex) + (shapeIndex < 2 ? " and the bounding box around the " + GuiConfigExtraBitManipulation.getInsertText(shapeIndex + 2) : "") + ", as well as which portions of it are rendered";
        }
        processedNames[endLen - 2] = names[startLen - 4];
        processedNames[endLen - 1] = names[startLen - 3];
        GuiConfigExtraBitManipulation.addDummyElementsOfChildElementSetsToDummyElement(childElements, false, processedNames);
        GuiConfigExtraBitManipulation.addElementsToDummyElement(names[startLen - 2], names[startLen - 1], configElements, childElements);
    }

    private static String getInsertText(int shapeIndex) {
        boolean removeBits = shapeIndex % 2 == 0;
        return (shapeIndex == 0 ? "Straight" : (shapeIndex == 1 ? "Flat" : "Curved")) + " Sculpting " + (removeBits ? "Wire's " : "Spade's ") + (shapeIndex > 1 ? "spherical/ellipsoidal" : "cubic/cuboidal") + " bit " + (removeBits ? "removal" : "addition") + " area";
    }

    private static void addDummyElementsOfProcessedChildElementSetsToDummyElement(List<IConfigElement> configElements, Map<Item, ConfigNamed> configs, String name, String toolTip, boolean isRecipe) {
        int len = configs.size();
        if (!isRecipe) {
            len *= 2;
        }
        String[] processedNames = new String[len += 2];
        int i = 0;
        for (Item item : configs.keySet()) {
            ConfigNamed config = configs.get(item);
            String itemTitle = config.getTitle();
            processedNames[i++] = itemTitle + (isRecipe ? " Recipe" : " Properties");
            if (isRecipe) continue;
            processedNames[i++] = "Configures the damage characteristics of the " + itemTitle;
        }
        processedNames[len - 2] = name;
        processedNames[len - 1] = toolTip;
        GuiConfigExtraBitManipulation.addDummyElementsOfChildElementSetsToDummyElement(configElements, isRecipe, processedNames);
    }

    private static void addDummyElementsOfChildElementSetsToDummyElement(List<IConfigElement> configElements, boolean isRecipe, String ... names) {
        ArrayList<IConfigElement> childElements = new ArrayList<IConfigElement>();
        int len = names.length;
        if (len >= 2) {
            int inc = isRecipe ? 1 : 2;
            for (int i = 0; i < names.length - 2; i += inc) {
                if (isRecipe) {
                    GuiConfigExtraBitManipulation.addRecipeChildElementsToDummyElement(names[i], childElements);
                    continue;
                }
                GuiConfigExtraBitManipulation.addChildElementsToDummyElement(names[i], names[i + 1], childElements);
            }
            GuiConfigExtraBitManipulation.addElementsToDummyElement(names[len - 2], names[len - 1], configElements, childElements);
        }
    }

    private static void addRecipeChildElementsToDummyElement(String name, List<IConfigElement> configElements) {
        GuiConfigExtraBitManipulation.addChildElementsToDummyElement(name, "Configures the recipe type and configuration for the " + name, configElements);
    }

    private static void addElementsToDummyElement(String text, String toolTip, List<IConfigElement> configElements, List<IConfigElement> childElements) {
        configElements.add((IConfigElement)new DummyConfigElement.DummyCategoryElement(text, toolTip, childElements));
    }

    private static void addChildElementsToDummyElement(String text, String toolTip, List<IConfigElement> configElements) {
        GuiConfigExtraBitManipulation.addElementsToDummyElement(text, toolTip, configElements, new ConfigElement(ConfigHandlerExtraBitManipulation.configFile.getCategory(text.toLowerCase())).getChildElements());
    }
}

