/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.client.eventhandler;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.client.shape.Prism;
import com.phylogeny.extrabitmanipulation.config.ConfigShapeRender;
import com.phylogeny.extrabitmanipulation.config.ConfigShapeRenderPair;
import com.phylogeny.extrabitmanipulation.helper.SculptSettingsHelper;
import com.phylogeny.extrabitmanipulation.item.ItemBitToolBase;
import com.phylogeny.extrabitmanipulation.item.ItemBitWrench;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import com.phylogeny.extrabitmanipulation.packet.PacketCycleBitWrenchMode;
import com.phylogeny.extrabitmanipulation.packet.PacketSculpt;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Cylinder;
import org.lwjgl.util.glu.Disk;
import org.lwjgl.util.glu.Quadric;
import org.lwjgl.util.glu.Sphere;

public class ClientEventHandler {
    private int frameCounter;
    private Vec3d drawnStartPoint = null;
    private static final ResourceLocation ARROW_HEAD = new ResourceLocation("extrabitmanipulation", "textures/overlays/ArrowHead.png");
    private static final ResourceLocation ARROW_BIDIRECTIONAL = new ResourceLocation("extrabitmanipulation", "textures/overlays/ArrowBidirectional.png");
    private static final ResourceLocation ARROW_CYCLICAL = new ResourceLocation("extrabitmanipulation", "textures/overlays/ArrowCyclical.png");
    private static final ResourceLocation CIRCLE = new ResourceLocation("extrabitmanipulation", "textures/overlays/Circle.png");
    private static final ResourceLocation INVERSION = new ResourceLocation("extrabitmanipulation", "textures/overlays/Inversion.png");
    private static final int[] DIRECTION_FORWARD = new int[]{2, 0, 5, 4, 1, 3};
    private static final int[] DIRECTION_BACKWARD = new int[]{1, 4, 0, 5, 3, 2};
    private static final int[] AXIS_FORWARD = new int[]{2, 3, 4, 5, 0, 1};
    private static final int[] AXIS_BACKWARD = new int[]{4, 5, 0, 1, 2, 3};
    private static final int[] SHAPE_CURVED = new int[]{1, 2, 0, 0, 0, 0, 0};
    private static final int[] SHAPE_FLAT = new int[]{3, 3, 3, 6, 3, 3, 3};

    @SubscribeEvent
    public void registerTextures(TextureStitchEvent.Pre event) {
        this.registerTexture(ARROW_HEAD);
        this.registerTexture(ARROW_BIDIRECTIONAL);
        this.registerTexture(ARROW_CYCLICAL);
        this.registerTexture(CIRCLE);
        this.registerTexture(INVERSION);
    }

    private void registerTexture(ResourceLocation resourceLocation) {
        SimpleTexture texture = new SimpleTexture(resourceLocation);
        Minecraft.func_71410_x().field_71446_o.func_110579_a(resourceLocation, (ITextureObject)texture);
    }

    /*
     * Unable to fully structure code
     */
    @SubscribeEvent
    public void interceptMouseInput(MouseEvent event) {
        player = Minecraft.func_71410_x().field_71439_g;
        if (event.getDwheel() != 0) {
            stack = player.func_184614_ca();
            if (stack != null && stack.func_77973_b() instanceof ItemBitToolBase) {
                v0 = forward = event.getDwheel() < 0;
                if (player.func_70093_af()) {
                    if (stack.func_77973_b() instanceof ItemBitWrench) {
                        ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketCycleBitWrenchMode(forward));
                    } else {
                        this.cycleSemiDiameter((EntityPlayer)player, stack, forward);
                    }
                    event.setCanceled(true);
                } else if (stack.func_77973_b() instanceof ItemSculptingTool && (GuiScreen.func_146271_m() || GuiScreen.func_175283_s())) {
                    if (GuiScreen.func_146271_m()) {
                        this.cycleDirection((EntityPlayer)player, stack, forward);
                    } else {
                        this.cycleWallThickness((EntityPlayer)player, stack, forward);
                    }
                    event.setCanceled(true);
                }
            } else {
                this.drawnStartPoint = null;
            }
        } else if ((GuiScreen.func_146271_m() || GuiScreen.func_175283_s()) && event.isButtonstate()) {
            stack = player.field_71071_by.func_70448_g();
            if (stack != null && (item = stack.func_77973_b()) != null && item instanceof ItemSculptingTool) {
                if (GuiScreen.func_146271_m()) {
                    if (event.getButton() == 1) {
                        this.cycleShapeType((EntityPlayer)player, stack, item);
                    }
                    if (event.getButton() == 0) {
                        this.toggleBitGridTargeted((EntityPlayer)player, stack);
                    }
                } else {
                    if (event.getButton() == 1) {
                        this.toggleHollowShape((EntityPlayer)player, stack, item);
                    }
                    if (event.getButton() == 0) {
                        this.toggleOpenEnds((EntityPlayer)player, stack);
                    }
                }
                event.setCanceled(true);
            }
        } else if (event.getButton() == 0) {
            if (!player.field_71075_bZ.field_75099_e) {
                return;
            }
            stack = player.field_71071_by.func_70448_g();
            if (stack != null) {
                item = stack.func_77973_b();
                if (event.isButtonstate() && item instanceof ItemBitWrench) {
                    event.setCanceled(true);
                } else if (item != null && item instanceof ItemSculptingTool) {
                    v1 = drawnMode = SculptSettingsHelper.getMode((EntityPlayer)player, stack.func_77978_p()) == 2;
                    if (!drawnMode) {
                        this.drawnStartPoint = null;
                    }
                    if (event.isButtonstate() || drawnMode && this.drawnStartPoint != null) {
                        toolItem = (ItemSculptingTool)item;
                        removeBits = toolItem.removeBits();
                        target = Minecraft.func_71410_x().field_71476_x;
                        if (target != null && target.field_72313_a != RayTraceResult.Type.MISS) {
                            if (target.field_72313_a == RayTraceResult.Type.BLOCK) {
                                pos = target.func_178782_a();
                                side = target.field_178784_b;
                                hit = target.field_72307_f;
                                swingTool = true;
                                if (drawnMode && event.isButtonstate() && this.drawnStartPoint != null) {
                                    event.setCanceled(true);
                                    return;
                                }
                                if (!player.func_70093_af() && drawnMode && event.isButtonstate()) {
                                    bitLoc = ChiselsAndBitsAPIAccess.apiInstance.getBitPos((float)hit.field_72450_a - (float)pos.func_177958_n(), (float)hit.field_72448_b - (float)pos.func_177956_o(), (float)hit.field_72449_c - (float)pos.func_177952_p(), side, pos, false);
                                    if (bitLoc != null) {
                                        x = pos.func_177958_n();
                                        y = pos.func_177956_o();
                                        z = pos.func_177952_p();
                                        x2 = (float)x + (float)bitLoc.getBitX() * 0.0625f;
                                        y2 = (float)y + (float)bitLoc.getBitY() * 0.0625f;
                                        z2 = (float)z + (float)bitLoc.getBitZ() * 0.0625f;
                                        if (!removeBits) {
                                            x2 += (float)side.func_82601_c() * 0.0625f;
                                            y2 += (float)side.func_96559_d() * 0.0625f;
                                            z2 += (float)side.func_82599_e() * 0.0625f;
                                        }
                                        this.drawnStartPoint = new Vec3d((double)x2, (double)y2, (double)z2);
                                    } else {
                                        this.drawnStartPoint = null;
                                        swingTool = false;
                                    }
                                } else {
                                    if (player.func_70093_af()) {
                                        api = ChiselsAndBitsAPIAccess.apiInstance;
                                        bitLoc = api.getBitPos((float)hit.field_72450_a - (float)pos.func_177958_n(), (float)hit.field_72448_b - (float)pos.func_177956_o(), (float)hit.field_72449_c - (float)pos.func_177952_p(), side, pos, false);
                                        if (bitLoc != null) {
                                            try {
                                                bitAccess = api.getBitAccess(player.field_70170_p, pos);
                                                bitStack = bitAccess.getBitAt(bitLoc.getBitX(), bitLoc.getBitY(), bitLoc.getBitZ()).getItemStack(1);
                                                SculptSettingsHelper.setBitStack((EntityPlayer)player, stack, removeBits, bitStack);
                                                if (!(removeBits != false ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade).shouldDisplayInChat()) ** GOTO lbl99
                                                this.printChatMessageWithDeletion((removeBits != false ? "Removing only " : "Sculpting with ") + bitStack.func_82833_r().substring(15));
                                            }
                                            catch (APIExceptions.CannotBeChiseled e) {
                                                event.setCanceled(true);
                                                return;
                                            }
                                        }
                                    } else if (!player.func_70093_af() || removeBits || drawnMode) {
                                        swingTool = toolItem.sculptBlocks(stack, (EntityPlayer)player, player.field_70170_p, pos, side, hit, this.drawnStartPoint);
                                        ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSculpt(pos, side, hit, this.drawnStartPoint));
                                    }
lbl99:
                                    // 6 sources

                                    if (drawnMode && !event.isButtonstate()) {
                                        this.drawnStartPoint = null;
                                    }
                                }
                                if (swingTool) {
                                    player.func_184609_a(EnumHand.MAIN_HAND);
                                }
                                event.setCanceled(true);
                            }
                        } else if (player.func_70093_af() && event.isButtonstate() && removeBits) {
                            SculptSettingsHelper.setBitStack((EntityPlayer)player, stack, true, null);
                            if ((removeBits != false ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade).shouldDisplayInChat()) {
                                this.printChatMessageWithDeletion("Removing any/all bits");
                            }
                        } else if (drawnMode) {
                            this.drawnStartPoint = null;
                        }
                    }
                }
            }
        }
        if (!event.isCanceled() && event.getButton() == 1 && event.isButtonstate() && (stack = player.field_71071_by.func_70448_g()) != null && (item = stack.func_77973_b()) != null && item instanceof ItemSculptingTool) {
            this.cycleMode((EntityPlayer)player, stack, player.func_70093_af() == false);
        }
    }

    private void cycleMode(EntityPlayer player, ItemStack stack, boolean forward) {
        int mode = SculptSettingsHelper.cycleData(SculptSettingsHelper.getMode(player, stack.func_77978_p()), forward, ItemSculptingTool.MODE_TITLES.length);
        SculptSettingsHelper.setMode(player, stack, mode);
        if (Configs.sculptMode.shouldDisplayInChat()) {
            this.printChatMessageWithDeletion(SculptSettingsHelper.getModeText(mode));
        }
    }

    private void cycleDirection(EntityPlayer player, ItemStack stack, boolean forward) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int direction = SculptSettingsHelper.getDirection(player, nbt);
        int shapeType = SculptSettingsHelper.getShapeType(player, nbt, ((ItemSculptingTool)stack.func_77973_b()).isCurved());
        int rotation = direction / 6;
        direction %= 6;
        if (!(shapeType == 4 && (!forward ? rotation != 0 : rotation != 1) || shapeType == 5 && (!forward ? rotation != 0 : rotation != 3))) {
            int n = shapeType == 2 || shapeType > 3 ? (forward ? DIRECTION_FORWARD[direction] : DIRECTION_BACKWARD[direction]) : (direction = forward ? AXIS_FORWARD[direction] : AXIS_BACKWARD[direction]);
            rotation = forward ? 0 : (shapeType == 4 ? 1 : 3);
        } else {
            rotation = shapeType == 4 ? (rotation == 0 ? 1 : 0) : SculptSettingsHelper.cycleData(rotation, forward, 4);
        }
        SculptSettingsHelper.setDirection(player, stack, direction += 6 * rotation);
        if (Configs.sculptDirection.shouldDisplayInChat()) {
            this.printChatMessageWithDeletion(SculptSettingsHelper.getDirectionText(direction, shapeType == 4 || shapeType == 5));
        }
    }

    private void cycleShapeType(EntityPlayer player, ItemStack stack, Item item) {
        boolean isCurved = ((ItemSculptingTool)item).isCurved();
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        int shapeType = SculptSettingsHelper.getShapeType(player, nbt, isCurved);
        shapeType = isCurved ? SHAPE_CURVED[shapeType] : SHAPE_FLAT[shapeType];
        SculptSettingsHelper.setShapeType(player, stack, isCurved, shapeType);
        if ((isCurved ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat).shouldDisplayInChat()) {
            this.printChatMessageWithDeletion(SculptSettingsHelper.getShapeTypeText(shapeType));
        }
    }

    private void toggleBitGridTargeted(EntityPlayer player, ItemStack stack) {
        boolean targetBitGrid = !SculptSettingsHelper.isBitGridTargeted(player, stack.func_77978_p());
        SculptSettingsHelper.setBitGridTargeted(player, stack, targetBitGrid);
        if (Configs.sculptTargetBitGridVertexes.shouldDisplayInChat()) {
            this.printChatMessageWithDeletion(SculptSettingsHelper.getBitGridTargetedText(targetBitGrid));
        }
    }

    private void cycleSemiDiameter(EntityPlayer player, ItemStack stack, boolean forward) {
        int semiDiameter = SculptSettingsHelper.cycleData(SculptSettingsHelper.getSemiDiameter(player, stack.func_77978_p()), forward, Configs.maxSemiDiameter);
        SculptSettingsHelper.setSemiDiameter(player, stack, semiDiameter);
        if (Configs.sculptSemiDiameter.shouldDisplayInChat()) {
            this.printChatMessageWithDeletion(SculptSettingsHelper.getSemiDiameterText(player, stack.func_77978_p(), semiDiameter));
        }
    }

    private void toggleHollowShape(EntityPlayer player, ItemStack stack, Item item) {
        boolean isWire = ((ItemSculptingTool)item).removeBits();
        boolean isHollowShape = !SculptSettingsHelper.isHollowShape(player, stack.func_77978_p(), isWire);
        SculptSettingsHelper.setHollowShape(player, stack, isWire, isHollowShape);
        if ((isWire ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade).shouldDisplayInChat()) {
            this.printChatMessageWithDeletion(SculptSettingsHelper.getHollowShapeText(isHollowShape));
        }
    }

    private void toggleOpenEnds(EntityPlayer player, ItemStack stack) {
        boolean areEndsOpen = !SculptSettingsHelper.areEndsOpen(player, stack.func_77978_p());
        SculptSettingsHelper.setEndsOpen(player, stack, areEndsOpen);
        if (Configs.sculptOpenEnds.shouldDisplayInChat()) {
            this.printChatMessageWithDeletion(SculptSettingsHelper.getOpenEndsText(areEndsOpen));
        }
    }

    private void cycleWallThickness(EntityPlayer player, ItemStack stack, boolean forward) {
        int wallThickness = SculptSettingsHelper.cycleData(SculptSettingsHelper.getWallThickness(player, stack.func_77978_p()), forward, Configs.maxWallThickness);
        SculptSettingsHelper.setWallThickness(player, stack, wallThickness);
        if (Configs.sculptWallThickness.shouldDisplayInChat()) {
            this.printChatMessageWithDeletion(SculptSettingsHelper.getWallThicknessText(wallThickness));
        }
    }

    private void printChatMessageWithDeletion(String text) {
        GuiNewChat chatGUI = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        chatGUI.func_146234_a((ITextComponent)new TextComponentString(text), 627250);
    }

    @SubscribeEvent
    public void cancelBoundingBoxDraw(DrawBlockHighlightEvent event) {
        Item item;
        ItemStack itemStack = event.getPlayer().field_71071_by.func_70448_g();
        if (itemStack != null && (item = itemStack.func_77973_b()) != null && item instanceof ItemSculptingTool && SculptSettingsHelper.getMode(event.getPlayer(), itemStack.func_77978_p()) == 1) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void renderBoxesSpheresAndOverlays(RenderWorldLastEvent event) {
        if (!Configs.disableOverlays) {
            RayTraceResult target;
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            World world = player.field_70170_p;
            ItemStack stack = player.func_184614_ca();
            if (stack != null && (target = Minecraft.func_71410_x().field_71476_x) != null && target.field_72313_a.equals((Object)RayTraceResult.Type.BLOCK) && stack.func_77973_b() instanceof ItemBitToolBase) {
                IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
                float ticks = event.getPartialTicks();
                double playerX = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)ticks;
                double playerY = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)ticks;
                double playerZ = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)ticks;
                EnumFacing dir = target.field_178784_b;
                Tessellator t = Tessellator.func_178181_a();
                VertexBuffer vb = t.func_178180_c();
                BlockPos pos = target.func_178782_a();
                int x = pos.func_177958_n();
                int y = pos.func_177956_o();
                int z = pos.func_177952_p();
                double diffX = playerX - (double)x;
                double diffY = playerY - (double)y;
                double diffZ = playerZ - (double)z;
                Vec3d hit = target.field_72307_f;
                if (stack.func_77973_b() instanceof ItemBitWrench && api.isBlockChiseled(world, target.func_178782_a())) {
                    boolean mirrorInversion;
                    double mirTravel;
                    int mode = !stack.func_77942_o() ? 0 : stack.func_77978_p().func_74762_e("mode");
                    ++this.frameCounter;
                    int side = dir.ordinal();
                    boolean upDown = side <= 1;
                    boolean eastWest = side >= 4;
                    boolean northSouth = !upDown && !eastWest;
                    AxisAlignedBB box = new AxisAlignedBB(eastWest ? hit.field_72450_a : (double)x, upDown ? hit.field_72448_b : (double)y, northSouth ? hit.field_72449_c : (double)z, eastWest ? hit.field_72450_a : (double)(x + 1), upDown ? hit.field_72448_b : (double)(y + 1), northSouth ? hit.field_72449_c : (double)(z + 1));
                    int offsetX = Math.abs(dir.func_82601_c());
                    int offsetY = Math.abs(dir.func_96559_d());
                    int offsetZ = Math.abs(dir.func_82599_e());
                    double invOffsetX = offsetX ^ 1;
                    double invOffsetY = offsetY ^ 1;
                    double invOffsetZ = offsetZ ^ 1;
                    boolean invertDirection = player.func_70093_af();
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179140_f();
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179147_l();
                    GlStateManager.func_179112_b((int)770, (int)771);
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179094_E();
                    double angle = this.getInitialAngle(mode);
                    if (mode == 3) {
                        if (side % 2 == 1) {
                            angle += 180.0;
                        }
                        if (side >= 4) {
                            angle -= 90.0;
                        }
                    } else {
                        if (mode == 0) {
                            if (side % 2 == (invertDirection ? 0 : 1)) {
                                angle *= -1.0;
                            }
                        } else if (side < 2 || side > 3) {
                            angle *= -1.0;
                        }
                        if (eastWest) {
                            angle += 90.0;
                        }
                        if (side == (mode == 1 ? 1 : 0) || side == 3 || side == 4) {
                            angle += 180.0;
                        }
                    }
                    double offsetX2 = 0.5 * invOffsetX;
                    double offsetY2 = 0.5 * invOffsetY;
                    double offsetZ2 = 0.5 * invOffsetZ;
                    double mirTravel1 = mirTravel = mode == 1 ? Configs.mirrorAmplitude * Math.cos(Math.PI * 2 * (double)this.frameCounter / Configs.mirrorPeriod) : 0.0;
                    double mirTravel2 = 0.0;
                    boolean bl = mirrorInversion = invertDirection && mode == 1;
                    if (mirrorInversion && side <= 1 && player.func_174811_aO().ordinal() > 3) {
                        angle += 90.0;
                        mirTravel1 = 0.0;
                        mirTravel2 = mirTravel;
                    }
                    this.translateAndRotateTexture(playerX, playerY, playerZ, dir, upDown, eastWest, offsetX, offsetY, offsetZ, angle, diffX, diffY, diffZ, offsetX2, offsetY2, offsetZ2, mirTravel1, mirTravel2);
                    Minecraft.func_71410_x().field_71446_o.func_110577_a(mode == 0 ? ARROW_CYCLICAL : (mode == 1 ? ARROW_BIDIRECTIONAL : (mode == 2 ? CIRCLE : INVERSION)));
                    float minU = 0.0f;
                    float maxU = 1.0f;
                    float minV = 0.0f;
                    float maxV = 1.0f;
                    if (mode == 0) {
                        if (invertDirection) {
                            float minU2 = minU;
                            minU = maxU;
                            maxU = minU2;
                        }
                    } else if (mode == 2) {
                        EnumFacing dir2 = side <= 1 ? EnumFacing.WEST : (side <= 3 ? EnumFacing.WEST : EnumFacing.DOWN);
                        box = this.contractBoxOrRenderArrows(true, t, vb, side, northSouth, dir2, box, invOffsetX, invOffsetY, invOffsetZ, invertDirection, minU, maxU, minV, maxV);
                    }
                    this.renderTexturedSide(t, vb, side, northSouth, box, minU, maxU, minV, maxV, 1.0);
                    GlStateManager.func_179121_F();
                    AxisAlignedBB box3 = world.func_180495_p(pos).func_185918_c(world, pos);
                    for (int s = 0; s < 6; ++s) {
                        if (s == side) continue;
                        GlStateManager.func_179094_E();
                        upDown = s <= 1;
                        eastWest = s >= 4;
                        northSouth = !upDown && !eastWest;
                        dir = EnumFacing.func_82600_a((int)s);
                        box = new AxisAlignedBB(eastWest ? (s == 5 ? box3.field_72336_d : box3.field_72340_a) : (double)x, upDown ? (s == 1 ? box3.field_72337_e : box3.field_72338_b) : (double)y, northSouth ? (s == 3 ? box3.field_72334_f : box3.field_72339_c) : (double)z, eastWest ? (s == 4 ? box3.field_72340_a : box3.field_72336_d) : (double)(x + 1), upDown ? (s == 0 ? box3.field_72338_b : box3.field_72337_e) : (double)(y + 1), northSouth ? (s == 2 ? box3.field_72339_c : box3.field_72334_f) : (double)(z + 1));
                        angle = this.getInitialAngle(mode);
                        boolean oppRotation = false;
                        int mode2 = mode;
                        if (mode != 3) {
                            boolean bl2 = oppRotation = dir == EnumFacing.func_82600_a((int)side).func_176734_d();
                            if (mode == 0) {
                                if (!oppRotation) {
                                    Minecraft.func_71410_x().field_71446_o.func_110577_a(ARROW_HEAD);
                                    angle = 90.0;
                                    if (side % 2 == 0) {
                                        angle += 180.0;
                                    }
                                    if (invertDirection) {
                                        angle += 180.0;
                                    }
                                    mode2 = 2;
                                } else {
                                    Minecraft.func_71410_x().field_71446_o.func_110577_a(ARROW_CYCLICAL);
                                    mode2 = 0;
                                }
                            } else if (mode == 2) {
                                if (!oppRotation) {
                                    Minecraft.func_71410_x().field_71446_o.func_110577_a(ARROW_HEAD);
                                    if (side == 0 ? s == 2 || s == 5 : (side == 1 ? s == 3 || s == 4 : (side == 2 ? s == 1 || s == 5 : (side == 3 ? s == 0 || s == 4 : (side == 4 ? s == 1 || s == 2 : s == 0 || s == 3))))) {
                                        angle += 180.0;
                                    }
                                    if (invertDirection) {
                                        angle += 180.0;
                                    }
                                } else {
                                    Minecraft.func_71410_x().field_71446_o.func_110577_a(CIRCLE);
                                }
                            }
                        }
                        mirTravel1 = mirTravel;
                        mirTravel2 = 0.0;
                        if (mode != 3 && ((side <= 1 && mirrorInversion ? side > 1 : side <= 1) && s > 1 || (mirrorInversion ? (oppRotation ? player.func_174811_aO().ordinal() > 3 : side > 3) : side == 2 || side == 3) && s <= 1)) {
                            angle += 90.0;
                            mirTravel1 = 0.0;
                            mirTravel2 = mirTravel;
                        }
                        if (mode == 3) {
                            if (s % 2 == 1) {
                                angle += 180.0;
                            }
                            if (s >= 4) {
                                angle -= 90.0;
                            }
                        } else {
                            if (mode2 == 0) {
                                if (s % 2 == (invertDirection ? 0 : 1)) {
                                    angle *= -1.0;
                                }
                                if (oppRotation) {
                                    angle *= -1.0;
                                }
                            } else if (s < 2 || s > 3) {
                                angle *= -1.0;
                            }
                            if (eastWest) {
                                angle -= 90.0;
                            }
                            if (s == (mode2 == 1 ? 1 : 0) || s == 3 || s == 5) {
                                angle += 180.0;
                            }
                        }
                        offsetX = Math.abs(dir.func_82601_c());
                        offsetY = Math.abs(dir.func_96559_d());
                        offsetZ = Math.abs(dir.func_82599_e());
                        invOffsetX = offsetX ^ 1;
                        invOffsetY = offsetY ^ 1;
                        invOffsetZ = offsetZ ^ 1;
                        offsetX2 = 0.5 * invOffsetX;
                        offsetY2 = 0.5 * invOffsetY;
                        offsetZ2 = 0.5 * invOffsetZ;
                        this.translateAndRotateTexture(playerX, playerY, playerZ, dir, upDown, eastWest, offsetX, offsetY, offsetZ, angle, diffX, diffY, diffZ, offsetX2, offsetY2, offsetZ2, mirTravel1, mirTravel2);
                        minU = 0.0f;
                        maxU = 1.0f;
                        minV = 0.0f;
                        maxV = 1.0f;
                        if (mode2 == 0) {
                            if (oppRotation) {
                                minU = 1.0f;
                                maxU = 0.0f;
                            }
                            if (invertDirection) {
                                float minU2 = minU;
                                minU = maxU;
                                maxU = minU2;
                            }
                        } else if (mode2 == 2) {
                            EnumFacing dir2 = side <= 1 ? (s == 2 || s == 3 ? EnumFacing.WEST : EnumFacing.DOWN) : (side >= 4 ? EnumFacing.WEST : (s <= 1 ? EnumFacing.WEST : EnumFacing.DOWN));
                            box = this.contractBoxOrRenderArrows(oppRotation, t, vb, side, northSouth, dir2, box, invOffsetX, invOffsetY, invOffsetZ, invertDirection, minU, maxU, minV, maxV);
                        }
                        if (mode2 != 2 || oppRotation) {
                            this.renderTexturedSide(t, vb, s, northSouth, box, minU, maxU, minV, maxV, 1.0);
                        }
                        GlStateManager.func_179121_F();
                    }
                    GlStateManager.func_179145_e();
                    GlStateManager.func_179084_k();
                    GlStateManager.func_179098_w();
                    GlStateManager.func_179121_F();
                } else if (stack.func_77973_b() instanceof ItemSculptingTool) {
                    float hitZ;
                    float hitY;
                    float hitX;
                    IBitLocation bitLoc;
                    ItemSculptingTool toolItem = (ItemSculptingTool)stack.func_77973_b();
                    boolean removeBits = toolItem.removeBits();
                    int mode = SculptSettingsHelper.getMode((EntityPlayer)player, stack.func_77978_p());
                    if ((!removeBits || mode > 0 || api.canBeChiseled(world, target.func_178782_a())) && (bitLoc = api.getBitPos(hitX = (float)hit.field_72450_a - (float)pos.func_177958_n(), hitY = (float)hit.field_72448_b - (float)pos.func_177956_o(), hitZ = (float)hit.field_72449_c - (float)pos.func_177952_p(), dir, pos, false)) != null) {
                        boolean isHollow;
                        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
                        int x2 = bitLoc.getBitX();
                        int y2 = bitLoc.getBitY();
                        int z2 = bitLoc.getBitZ();
                        if (!toolItem.removeBits()) {
                            x2 += dir.func_82601_c();
                            y2 += dir.func_96559_d();
                            z2 += dir.func_82599_e();
                        }
                        boolean isDrawn = this.drawnStartPoint != null;
                        boolean drawnBox = mode == 2 && isDrawn;
                        int shapeType = SculptSettingsHelper.getShapeType((EntityPlayer)player, nbt, toolItem.isCurved());
                        boolean fixedNotSym = !drawnBox && shapeType == 2 || shapeType > 4;
                        GlStateManager.func_179147_l();
                        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                        GlStateManager.func_179090_x();
                        GlStateManager.func_179132_a((boolean)false);
                        double r = (double)SculptSettingsHelper.getSemiDiameter((EntityPlayer)player, nbt) * 0.0625;
                        ConfigShapeRenderPair configPair = Configs.itemShapeMap.get((Object)toolItem);
                        ConfigShapeRender configBox = configPair.boundingBox;
                        AxisAlignedBB box = null;
                        AxisAlignedBB shapeBox = null;
                        double x3 = (double)x + (double)x2 * 0.0625;
                        double y3 = (double)y + (double)y2 * 0.0625;
                        double z3 = (double)z + (double)z2 * 0.0625;
                        if (configBox.renderInnerShape || configBox.renderOuterShape) {
                            GlStateManager.func_179094_E();
                            GL11.glLineWidth((float)configBox.lineWidth);
                            boolean inside = ItemSculptingTool.wasInsideClicked(dir, hit, pos);
                            if (drawnBox) {
                                double x4 = this.drawnStartPoint.field_72450_a;
                                double y4 = this.drawnStartPoint.field_72448_b;
                                double z4 = this.drawnStartPoint.field_72449_c;
                                if (Math.max(x3, x4) == x3) {
                                    x3 += 0.0625;
                                } else {
                                    x4 += 0.0625;
                                }
                                if (Math.max(y3, y4) == y3) {
                                    y3 += 0.0625;
                                } else {
                                    y4 += 0.0625;
                                }
                                if (Math.max(z3, z4) == z3) {
                                    z3 += 0.0625;
                                } else {
                                    z4 += 0.0625;
                                }
                                box = new AxisAlignedBB(x4, y4, z4, x3, y3, z3);
                            } else {
                                double f = 0.0;
                                float x4 = 0.0f;
                                float y4 = 0.0f;
                                float z4 = 0.0f;
                                boolean targetBitGrid = SculptSettingsHelper.isBitGridTargeted((EntityPlayer)player, nbt);
                                if (mode == 2) {
                                    r = 0.0;
                                } else if (targetBitGrid) {
                                    boolean su;
                                    f = 0.03125;
                                    x4 = hitX < (float)Math.round(hitX / 0.0625f) * 0.0625f ? 1.0f : -1.0f;
                                    y4 = hitY < (float)Math.round(hitY / 0.0625f) * 0.0625f ? 1.0f : -1.0f;
                                    z4 = hitZ < (float)Math.round(hitZ / 0.0625f) * 0.0625f ? 1.0f : -1.0f;
                                    double offsetX = Math.abs(dir.func_82601_c());
                                    double offsetY = Math.abs(dir.func_96559_d());
                                    double offsetZ = Math.abs(dir.func_82599_e());
                                    int s = dir.ordinal();
                                    if (s % 2 == 0) {
                                        if (offsetX > 0.0) {
                                            x4 *= -1.0f;
                                        }
                                        if (offsetY > 0.0) {
                                            y4 *= -1.0f;
                                        }
                                        if (offsetZ > 0.0) {
                                            z4 *= -1.0f;
                                        }
                                    }
                                    boolean bl = su = s == 1 || s == 3;
                                    if (removeBits ? !inside || !su : inside && su) {
                                        if (offsetX > 0.0) {
                                            x4 *= -1.0f;
                                        }
                                        if (offsetY > 0.0) {
                                            y4 *= -1.0f;
                                        }
                                        if (offsetZ > 0.0) {
                                            z4 *= -1.0f;
                                        }
                                    }
                                    r -= f;
                                }
                                box = new AxisAlignedBB((double)x - r, (double)y - r, (double)z - r, (double)x + r + 0.0625, (double)y + r + 0.0625, (double)z + r + 0.0625).func_72317_d((double)x2 * 0.0625 + f * (double)x4, (double)y2 * 0.0625 + f * (double)y4, (double)z2 * 0.0625 + f * (double)z4);
                                if (targetBitGrid && mode != 2) {
                                    x3 = (box.field_72336_d + box.field_72340_a) * 0.5 - f;
                                    y3 = (box.field_72337_e + box.field_72338_b) * 0.5 - f;
                                    z3 = (box.field_72334_f + box.field_72339_c) * 0.5 - f;
                                }
                            }
                            if (fixedNotSym) {
                                shapeBox = box.func_72314_b(0.0, 0.0, 0.0);
                            }
                            if (mode == 0) {
                                AxisAlignedBB box2;
                                BlockPos pos2 = !removeBits && !inside ? pos.func_177972_a(dir) : pos;
                                AxisAlignedBB axisAlignedBB = box2 = !removeBits ? new AxisAlignedBB(pos2) : world.func_180495_p(pos2).func_185918_c(world, pos2);
                                if ((int)Math.round(box2.field_72340_a) != pos2.func_177958_n() || (int)Math.round(box2.field_72338_b) != pos2.func_177956_o() || (int)Math.round(box2.field_72339_c) != pos2.func_177952_p()) {
                                    box2 = box2.func_186670_a(pos2);
                                }
                                box = this.limitBox(box, box2);
                            }
                            double f = 0.002f;
                            if (configBox.renderOuterShape) {
                                RenderGlobal.func_189697_a((AxisAlignedBB)box.func_72314_b(f, f, f).func_72317_d(-playerX, -playerY, -playerZ), (float)configBox.red, (float)configBox.green, (float)configBox.blue, (float)configBox.outerShapeAlpha);
                            }
                            if (configBox.renderInnerShape) {
                                GlStateManager.func_179143_c((int)516);
                                RenderGlobal.func_189697_a((AxisAlignedBB)box.func_72314_b(f, f, f).func_72317_d(-playerX, -playerY, -playerZ), (float)configBox.red, (float)configBox.green, (float)configBox.blue, (float)configBox.innerShapeAlpha);
                                GlStateManager.func_179143_c((int)515);
                            }
                            GlStateManager.func_179121_F();
                        }
                        if (!fixedNotSym) {
                            shapeBox = box.func_72314_b(0.0, 0.0, 0.0);
                        }
                        boolean isOpen = (isHollow = SculptSettingsHelper.isHollowShape((EntityPlayer)player, nbt, removeBits)) && SculptSettingsHelper.areEndsOpen((EntityPlayer)player, nbt);
                        this.renderEnvelopedShapes((EntityPlayer)player, shapeType, nbt, playerX, playerY, playerZ, isDrawn, drawnBox, r, configPair, shapeBox, x3, y3, z3, 0.0, isOpen);
                        float wallThickness = (float)SculptSettingsHelper.getWallThickness((EntityPlayer)player, nbt) * 0.0625f;
                        if (wallThickness > 0.0f && isHollow && (mode != 2 || drawnBox)) {
                            this.renderEnvelopedShapes((EntityPlayer)player, shapeType, nbt, playerX, playerY, playerZ, isDrawn, drawnBox, r, configPair, shapeBox, x3, y3, z3, wallThickness, isOpen);
                        }
                        GlStateManager.func_179132_a((boolean)true);
                        GlStateManager.func_179098_w();
                        GlStateManager.func_179084_k();
                    }
                }
            }
        }
    }

    private void renderEnvelopedShapes(EntityPlayer player, int shapeType, NBTTagCompound nbt, double playerX, double playerY, double playerZ, boolean isDrawn, boolean drawnBox, double r, ConfigShapeRenderPair configPair, AxisAlignedBB box, double x, double y, double z, double contraction, boolean isOpen) {
        ConfigShapeRender configShape = configPair.envelopedShape;
        if (configShape.renderInnerShape || configShape.renderOuterShape) {
            boolean openSym;
            double v;
            double a = 0.0;
            double b = 0.0;
            double c = 0.0;
            int dir = SculptSettingsHelper.getDirection(player, nbt);
            dir %= 6;
            boolean notFullSym = shapeType != 0 && shapeType != 3;
            boolean notSym = shapeType == 2 || shapeType > 4;
            double ri = r + 0.03125;
            r = Math.max(ri - contraction, 0.0);
            boolean drawnNotSym = notSym && drawnBox;
            double base = 0.0;
            if (drawnBox || notSym) {
                double f = 0.5;
                double minX = box.field_72340_a * f;
                double minY = box.field_72338_b * f;
                double minZ = box.field_72339_c * f;
                double maxX = box.field_72336_d * f;
                double maxY = box.field_72337_e * f;
                double maxZ = box.field_72334_f * f;
                double x2 = maxX - minX;
                double y2 = maxY - minY;
                double z2 = maxZ - minZ;
                if (drawnNotSym) {
                    if (dir == 2 || dir == 3) {
                        v = y2;
                        y2 = z2;
                        z2 = v;
                    } else if (dir > 3) {
                        v = y2;
                        y2 = x2;
                        x2 = v;
                    }
                }
                if (notSym && contraction > 0.0) {
                    if (!isOpen) {
                        base = contraction;
                    }
                    double y2sq = (y2 *= 2.0) * y2;
                    double aInset = Math.sqrt(x2 * x2 + y2sq) * contraction / x2 + base;
                    double cInset = Math.sqrt(z2 * z2 + y2sq) * contraction / z2 + base;
                    a = Math.max((y2 - aInset) * (x2 / y2), 0.0);
                    c = Math.max((y2 - cInset) * (z2 / y2), 0.0);
                    contraction = Math.min(aInset - base, cInset - base);
                    b = Math.max(y2 * 0.5 - contraction * 0.5 - base * 0.5, 0.0);
                } else {
                    a = Math.max(x2 - (!isOpen || !notFullSym || dir < 4 ? contraction : 0.0), 0.0);
                    c = Math.max(z2 - (!isOpen || !notFullSym || dir != 2 && dir != 3 ? contraction : 0.0), 0.0);
                    b = Math.max(y2 - (!isOpen || !notFullSym || dir > 1 ? contraction : 0.0), 0.0);
                }
                r = Math.max(Math.max(a, b), c);
                x = maxX + minX;
                y = maxY + minY;
                z = maxZ + minZ;
                if (drawnBox) {
                    if (notSym || !notFullSym) {
                        if (dir < 2 || dir > 3 || !notFullSym) {
                            v = b;
                            b = c;
                            c = v;
                        }
                    } else if (dir < 2) {
                        v = b;
                        b = c;
                        c = v;
                    } else if (dir > 3) {
                        v = a;
                        a = c;
                        c = v;
                    } else {
                        v = b;
                        b = a;
                        a = v;
                    }
                }
            } else {
                b = c = r;
                a = c;
                if (b > 0.0 && notFullSym && isOpen) {
                    b += contraction * (double)(!isDrawn ? 1 : 0);
                }
            }
            Prism shape = shapeType > 2 ? new Prism(shapeType > 4, shapeType == 4 || shapeType == 5) : (notFullSym ? new Cylinder() : new Sphere());
            shape.setDrawStyle(100011);
            Disk lid = new Disk();
            lid.setDrawStyle(100011);
            GlStateManager.func_179094_E();
            GL11.glLineWidth((float)configShape.lineWidth);
            double x2 = x - playerX;
            double y2 = y - playerY;
            double z2 = z - playerZ;
            if (!notSym && !isDrawn) {
                double hp = 0.03125;
                x2 += hp;
                y2 += hp;
                z2 += hp;
            }
            if (notFullSym && isOpen && contraction > 0.0 && !notSym) {
                double offset = contraction * (notSym ? 0.5 : (double)(drawnBox ? 0 : -1));
                if (dir != 3) {
                    y2 += dir == 0 ? offset : -offset;
                }
                if (dir > 2) {
                    x2 += dir == 5 ? -offset : offset;
                }
                if (dir == 2 || dir == 3) {
                    z2 += dir == 2 ? offset : -offset;
                }
            }
            GlStateManager.func_179137_b((double)x2, (double)y2, (double)z2);
            int rot2 = dir;
            if (!drawnNotSym || dir != 2) {
                if (notFullSym && rot2 != 1) {
                    int angle = 90;
                    if (rot2 == 3) {
                        rot2 = 0;
                        angle = 180;
                        if (!drawnNotSym || dir != 3) {
                            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                        }
                    } else {
                        rot2 = rot2 > 1 ? (rot2 %= 4) : (rot2 ^= 5);
                    }
                    Vec3i vec = EnumFacing.func_82600_a((int)rot2).func_176734_d().func_176730_m();
                    GlStateManager.func_179114_b((float)angle, (float)vec.func_177958_n(), (float)vec.func_177956_o(), (float)vec.func_177952_p());
                } else {
                    GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                }
            }
            boolean bl = openSym = notFullSym && !notSym && isOpen && !isDrawn;
            if (notFullSym) {
                double offset1 = 0.0;
                double offset2 = 0.0;
                double r2 = r;
                if (notSym) {
                    r2 -= contraction * 0.5 - base * 0.5;
                } else if (openSym) {
                    double m = -contraction;
                    if (dir == 0) {
                        m *= 2.0;
                    }
                    if (dir != 1) {
                        r -= m;
                    }
                    if (dir > 1) {
                        if (dir < 3) {
                            offset1 = m;
                        } else {
                            offset2 = m;
                        }
                    }
                }
                GlStateManager.func_179137_b((double)offset1, (double)offset2, (double)(-r2));
            }
            if (openSym) {
                v = b;
                b = c;
                c = v;
            }
            if (drawnNotSym) {
                if (dir == 2 || dir == 3) {
                    v = b;
                    b = c;
                    c = v;
                } else if (dir > 3) {
                    v = b;
                    b = a;
                    a = v;
                }
            }
            if (notFullSym && drawnBox) {
                if (b > c && b > a) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(b - c));
                } else if (a > c && a >= b) {
                    GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(a - c));
                }
            }
            GlStateManager.func_179139_a((double)(a / ri), (double)(b / ri), (double)(c / ri));
            if (configShape.renderOuterShape) {
                this.drawEnvelopedShapes(ri, configShape, shapeType, shape, (Quadric)lid, true, notSym, isOpen);
            }
            if (configShape.renderInnerShape) {
                GlStateManager.func_179143_c((int)516);
                this.drawEnvelopedShapes(ri, configShape, shapeType, shape, (Quadric)lid, false, notSym, isOpen);
                GlStateManager.func_179143_c((int)515);
            }
            GlStateManager.func_179121_F();
        }
    }

    private void drawEnvelopedShapes(double r, ConfigShapeRender configShape, int shapeType, Quadric shape, Quadric lid, boolean isOuter, boolean isCylinder, boolean isOpen) {
        GlStateManager.func_179094_E();
        this.drawEnvelopedShape(shape, r, isOuter, configShape, isCylinder, isOpen);
        if (shapeType > 0 && shapeType < 3 && !isOpen) {
            if (shapeType == 1) {
                this.drawEnvelopedShape(lid, r, isOuter, configShape, isCylinder, isOpen);
            }
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)(r * 2.0));
            this.drawEnvelopedShape(lid, r, isOuter, configShape, isCylinder, isOpen);
        }
        GlStateManager.func_179121_F();
    }

    private void drawEnvelopedShape(Quadric shape, double radius, boolean isOuter, ConfigShapeRender configShape, boolean isCone, boolean isOpen) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)configShape.red, (float)configShape.green, (float)configShape.blue, (float)(isOuter ? configShape.outerShapeAlpha : configShape.innerShapeAlpha));
        float r = (float)radius;
        if (shape instanceof Prism) {
            ((Prism)shape).draw(r, isOpen);
        } else if (shape instanceof Sphere) {
            ((Sphere)shape).draw(r, 32, 32);
        } else if (shape instanceof Cylinder) {
            ((Cylinder)shape).draw(isCone ? 0.0f : r, r, r * 2.0f, 32, 32);
        } else if (shape instanceof Disk) {
            ((Disk)shape).draw(0.0f, r, 32, 32);
        }
        GlStateManager.func_179121_F();
    }

    private AxisAlignedBB limitBox(AxisAlignedBB box, AxisAlignedBB mask) {
        double d0 = Math.max(box.field_72340_a, mask.field_72340_a);
        double d1 = Math.max(box.field_72338_b, mask.field_72338_b);
        double d2 = Math.max(box.field_72339_c, mask.field_72339_c);
        double d3 = Math.min(box.field_72336_d, mask.field_72336_d);
        double d4 = Math.min(box.field_72337_e, mask.field_72337_e);
        double d5 = Math.min(box.field_72334_f, mask.field_72334_f);
        return new AxisAlignedBB(d0, d1, d2, d3, d4, d5);
    }

    private double getInitialAngle(int mode) {
        return mode == 0 ? (double)this.frameCounter * (360.0 / Configs.rotationPeriod) % 360.0 : 0.0;
    }

    private void translateAndRotateTexture(double playerX, double playerY, double playerZ, EnumFacing dir, boolean upDown, boolean eastWest, int offsetX, int offsetY, int offsetZ, double angle, double diffX, double diffY, double diffZ, double offsetX2, double offsetY2, double offsetZ2, double mirTravel1, double mirTravel2) {
        double cos = Math.cos(Math.toRadians(angle));
        double sin = Math.sin(Math.toRadians(angle));
        if (upDown) {
            GL11.glTranslated((double)(diffX * cos + diffZ * sin - diffX + mirTravel1), (double)0.0, (double)(-diffX * sin + diffZ * cos - diffZ + mirTravel2));
        } else if (eastWest) {
            GL11.glTranslated((double)0.0, (double)(diffY * cos - diffZ * sin - diffY + mirTravel2), (double)(diffY * sin + diffZ * cos - diffZ + mirTravel1));
        } else {
            GL11.glTranslated((double)(diffX * cos - diffY * sin - diffX + mirTravel1), (double)(diffX * sin + diffY * cos - diffY + mirTravel2), (double)0.0);
        }
        GL11.glTranslated((double)offsetX2, (double)offsetY2, (double)offsetZ2);
        GL11.glRotated((double)angle, (double)offsetX, (double)offsetY, (double)offsetZ);
        GL11.glTranslated((double)(-offsetX2), (double)(-offsetY2), (double)(-offsetZ2));
        GL11.glTranslated((double)(-playerX + 0.002 * (double)dir.func_82601_c()), (double)(-playerY + 0.002 * (double)dir.func_96559_d()), (double)(-playerZ + 0.002 * (double)dir.func_82599_e()));
    }

    private AxisAlignedBB contractBoxOrRenderArrows(boolean contractBox, Tessellator t, VertexBuffer vb, int side, boolean northSouth, EnumFacing dir, AxisAlignedBB box, double invOffsetX, double invOffsetY, double invOffsetZ, boolean invertDirection, float minU, float maxU, float minV, float maxV) {
        if (contractBox) {
            double amount = (double)this.frameCounter % Configs.translationScalePeriod / Configs.translationScalePeriod;
            amount /= invertDirection ? -2.0 : 2.0;
            if (invertDirection && Configs.translationScalePeriod > 1.0) {
                amount += 0.5;
            }
            box = box.func_72314_b(-amount * invOffsetX, -amount * invOffsetY, -amount * invOffsetZ);
        } else if (Configs.translationDistance > 0.0) {
            int timeOffset;
            double distance = Configs.translationDistance;
            double fadeDistance = Configs.translationFadeDistance;
            double period = Configs.translationMovementPeriod;
            double offsetDistance = Configs.translationOffsetDistance;
            int n = timeOffset = offsetDistance > 0.0 ? (int)(period / (distance / offsetDistance)) : 0;
            if ((double)timeOffset > period / 3.0) {
                timeOffset = (int)(period / 3.0);
            }
            if (fadeDistance > distance / 2.0) {
                fadeDistance = distance / 2.0;
            }
            int n2 = offsetDistance == 0.0 || period == 1.0 ? 1 : 3;
            for (int i = 0; i < n2; ++i) {
                double amount = (double)(this.frameCounter + timeOffset * i) % period / (period / (distance * 100.0) * 100.0);
                double alpha = 1.0;
                if (period > 1.0) {
                    if (amount < fadeDistance) {
                        alpha = amount / fadeDistance;
                    } else if (amount > distance - fadeDistance) {
                        alpha = (distance - amount) / fadeDistance;
                    }
                    amount -= distance / 2.0;
                }
                AxisAlignedBB box2 = new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f).func_72317_d(amount * (double)dir.func_82601_c(), amount * (double)dir.func_96559_d(), amount * (double)dir.func_82599_e());
                this.renderTexturedSide(t, vb, side, northSouth, box2, minU, maxU, minV, maxV, alpha);
            }
        } else {
            this.renderTexturedSide(t, vb, side, northSouth, box, minU, maxU, minV, maxV, 1.0);
        }
        return box;
    }

    private void renderTexturedSide(Tessellator t, VertexBuffer vb, int side, boolean northSouth, AxisAlignedBB box, float minU, float maxU, float minV, float maxV, double alpha) {
        GL11.glColor4d((double)1.0, (double)1.0, (double)1.0, (double)alpha);
        if (side == 1 || side == 3 || side == 4) {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)maxU, (double)minV).func_181675_d();
            vb.func_181662_b(box.field_72336_d, northSouth ? box.field_72338_b : box.field_72337_e, box.field_72334_f).func_187315_a((double)minU, (double)minV).func_181675_d();
            vb.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)minU, (double)maxV).func_181675_d();
            vb.func_181662_b(box.field_72340_a, northSouth ? box.field_72337_e : box.field_72338_b, box.field_72339_c).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            t.func_78381_a();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(box.field_72336_d, northSouth ? box.field_72338_b : box.field_72337_e, box.field_72334_f).func_187315_a((double)minU, (double)minV).func_181675_d();
            vb.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)maxU, (double)minV).func_181675_d();
            vb.func_181662_b(box.field_72340_a, northSouth ? box.field_72337_e : box.field_72338_b, box.field_72339_c).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            vb.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)minU, (double)maxV).func_181675_d();
            t.func_78381_a();
        } else {
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(box.field_72340_a, northSouth ? box.field_72337_e : box.field_72338_b, box.field_72339_c).func_187315_a((double)maxU, (double)minV).func_181675_d();
            vb.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)minU, (double)minV).func_181675_d();
            vb.func_181662_b(box.field_72336_d, northSouth ? box.field_72338_b : box.field_72337_e, box.field_72334_f).func_187315_a((double)minU, (double)maxV).func_181675_d();
            vb.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            t.func_78381_a();
            vb.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vb.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_187315_a((double)minU, (double)minV).func_181675_d();
            vb.func_181662_b(box.field_72340_a, northSouth ? box.field_72337_e : box.field_72338_b, box.field_72339_c).func_187315_a((double)maxU, (double)minV).func_181675_d();
            vb.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_187315_a((double)maxU, (double)maxV).func_181675_d();
            vb.func_181662_b(box.field_72336_d, northSouth ? box.field_72338_b : box.field_72337_e, box.field_72334_f).func_187315_a((double)minU, (double)maxV).func_181675_d();
            t.func_78381_a();
        }
    }
}

