/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.helper;

import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.shape.Shape;
import java.util.HashMap;
import java.util.Set;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBag;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import mod.chiselsandbits.api.ItemType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BitStackHelper {
    public static int countInventoryBits(IChiselAndBitsAPI api, EntityPlayer player, ItemStack setBitStack) {
        int count = 0;
        InventoryPlayer inventoy = player.field_71071_by;
        for (int i = 0; i < inventoy.func_70302_i_(); ++i) {
            ItemStack stack = inventoy.func_70301_a(i);
            if (stack == null) continue;
            count += BitStackHelper.getBitCountFromStack(api, setBitStack, stack);
            if (api.getItemType(stack) != ItemType.BIT_BAG) continue;
            IBitBag bitBag = api.getBitbag(stack);
            for (int j = 0; j < bitBag.getSlots(); ++j) {
                ItemStack bagStack = bitBag.getStackInSlot(j);
                count += BitStackHelper.getBitCountFromStack(api, setBitStack, bagStack);
            }
        }
        return count;
    }

    private static int getBitCountFromStack(IChiselAndBitsAPI api, ItemStack setBitStack, ItemStack stack) {
        return BitStackHelper.areBitStacksEqual(api, setBitStack, stack) ? stack.field_77994_a : 0;
    }

    private static boolean areBitStacksEqual(IChiselAndBitsAPI api, ItemStack bitStack, ItemStack putativeBitStack) {
        return putativeBitStack != null && api.getItemType(putativeBitStack) == ItemType.CHISLED_BIT && ItemStack.func_77970_a((ItemStack)putativeBitStack, (ItemStack)bitStack);
    }

    public static void removeOrAddInventoryBits(IChiselAndBitsAPI api, EntityPlayer player, ItemStack setBitStack, int quota, boolean addBits) {
        if (quota > 0) {
            InventoryPlayer inventoy = player.field_71071_by;
            for (int i = 0; i < inventoy.func_70302_i_(); ++i) {
                ItemStack stack = inventoy.func_70301_a(i);
                if (!addBits) {
                    quota = BitStackHelper.removeBitsFromStack(api, setBitStack, quota, inventoy, null, i, stack);
                }
                if (api.getItemType(stack) == ItemType.BIT_BAG) {
                    IBitBag bitBag = api.getBitbag(stack);
                    for (int j = 0; j < bitBag.getSlots(); ++j) {
                        ItemStack bagStack = bitBag.getStackInSlot(j);
                        int n = quota = addBits ? BitStackHelper.addBitsToBag(quota, bitBag, j, setBitStack) : BitStackHelper.removeBitsFromStack(api, setBitStack, quota, null, bitBag, j, bagStack);
                        if (quota <= 0) break;
                    }
                }
                if (quota <= 0) break;
            }
        }
    }

    private static int addBitsToBag(int quota, IBitBag bitBag, int index, ItemStack stack) {
        if (stack != null) {
            int size = stack.field_77994_a;
            ItemStack remainingStack = bitBag.insertItem(index, stack, false);
            int reduction = size - (remainingStack != null ? remainingStack.field_77994_a : 0);
            quota -= reduction;
            stack.field_77994_a -= reduction;
        }
        return quota;
    }

    private static int removeBitsFromStack(IChiselAndBitsAPI api, ItemStack setBitStack, int quota, InventoryPlayer inventoy, IBitBag bitBag, int index, ItemStack stack) {
        if (BitStackHelper.areBitStacksEqual(api, setBitStack, stack)) {
            int size = stack.field_77994_a;
            if (size > quota) {
                if (bitBag != null) {
                    bitBag.extractItem(index, quota, false);
                } else {
                    stack.field_77994_a = size - quota;
                }
                quota = 0;
            } else {
                if (bitBag != null) {
                    bitBag.extractItem(index, size, false);
                } else if (inventoy != null) {
                    inventoy.func_70299_a(index, null);
                }
                quota -= size;
            }
        }
        return quota;
    }

    public static void giveOrDropStacks(EntityPlayer player, World world, BlockPos pos, Shape shape, IChiselAndBitsAPI api, HashMap<IBlockState, Integer> bitTypes) {
        if (bitTypes != null) {
            Set<IBlockState> keySet = bitTypes.keySet();
            for (IBlockState state : keySet) {
                IBitBrush bit;
                ItemStack bitStack;
                try {
                    bitStack = api.getBitItem(state);
                }
                catch (APIExceptions.InvalidBitItem e) {
                    continue;
                }
                if (bitStack.func_77973_b() == null) continue;
                try {
                    bit = api.createBrush(bitStack);
                }
                catch (APIExceptions.InvalidBitItem e) {
                    continue;
                }
                int totalBits = bitTypes.get(state);
                if (Configs.dropBitsAsFullChiseledBlocks && totalBits >= 4096) {
                    IBitAccess bitAccess = api.createBitItem(null);
                    BitStackHelper.setAllBits(bitAccess, bit);
                    int blockCount = totalBits / 4096;
                    totalBits -= blockCount * 4096;
                    while (blockCount > 0) {
                        int stackSize = blockCount > 64 ? 64 : blockCount;
                        ItemStack stack2 = bitAccess.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
                        if (stack2 != null) {
                            stack2.field_77994_a = stackSize;
                            BitStackHelper.givePlayerStackOrDropOnGround(player, world, api, pos, shape, stack2);
                        }
                        blockCount -= stackSize;
                    }
                }
                while (totalBits > 0) {
                    int quota = totalBits > 64 ? 64 : totalBits;
                    ItemStack bitStack2 = bit.getItemStack(quota);
                    BitStackHelper.givePlayerStackOrDropOnGround(player, world, api, pos, shape, bitStack2);
                    totalBits -= quota;
                }
            }
            bitTypes.clear();
            if (Configs.placeBitsInInventory) {
                player.field_71069_bz.func_75142_b();
            }
        }
    }

    private static void givePlayerStackOrDropOnGround(EntityPlayer player, World world, IChiselAndBitsAPI api, BlockPos pos, Shape shape, ItemStack stack) {
        if (Configs.placeBitsInInventory) {
            BitStackHelper.removeOrAddInventoryBits(api, player, stack, stack.field_77994_a, true);
            if (stack.field_77994_a > 0) {
                player.field_71071_by.func_70441_a(stack);
            }
        }
        if (stack.field_77994_a > 0) {
            if (Configs.dropBitsInBlockspace) {
                BitStackHelper.spawnStacksInShape(world, pos, shape, stack);
            } else {
                player.func_146097_a(stack, false, false);
            }
        }
    }

    private static void spawnStacksInShape(World world, BlockPos pos, Shape shape, ItemStack stack) {
        if (!world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops") && !world.restoringBlockSnapshots) {
            Vec3d spawnPoint = shape.getRandomInternalPoint(world, pos);
            EntityItem entityitem = new EntityItem(world, spawnPoint.field_72450_a, spawnPoint.field_72448_b - 0.25, spawnPoint.field_72449_c, stack);
            entityitem.func_174869_p();
            world.func_72838_d((Entity)entityitem);
        }
    }

    private static void setAllBits(IBitAccess bitAccess, IBitBrush bit) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    try {
                        bitAccess.setBitAt(i, j, k, bit);
                        continue;
                    }
                    catch (APIExceptions.SpaceOccupied e) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

