/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.helper;

import com.phylogeny.extrabitmanipulation.ExtraBitManipulation;
import com.phylogeny.extrabitmanipulation.capability.ISculptSettingsHandler;
import com.phylogeny.extrabitmanipulation.capability.SculptSettingsHandler;
import com.phylogeny.extrabitmanipulation.config.ConfigSculptSettingBitStack;
import com.phylogeny.extrabitmanipulation.config.ConfigSculptSettingBoolean;
import com.phylogeny.extrabitmanipulation.config.ConfigSculptSettingInt;
import com.phylogeny.extrabitmanipulation.helper.ItemStackHelper;
import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import com.phylogeny.extrabitmanipulation.packet.PacketSetBitStack;
import com.phylogeny.extrabitmanipulation.packet.PacketSetDirection;
import com.phylogeny.extrabitmanipulation.packet.PacketSetEndsOpen;
import com.phylogeny.extrabitmanipulation.packet.PacketSetHollowShape;
import com.phylogeny.extrabitmanipulation.packet.PacketSetMode;
import com.phylogeny.extrabitmanipulation.packet.PacketSetSemiDiameter;
import com.phylogeny.extrabitmanipulation.packet.PacketSetShapeType;
import com.phylogeny.extrabitmanipulation.packet.PacketSetTargetBitGridVertexes;
import com.phylogeny.extrabitmanipulation.packet.PacketSetWallThickness;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.shape.Shape;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SculptSettingsHelper {
    public static NBTTagCompound initNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        return nbt;
    }

    private static int getInt(NBTTagCompound nbt, int intValue, String key) {
        if (nbt != null && nbt.func_74764_b(key)) {
            intValue = nbt.func_74762_e(key);
        }
        return intValue;
    }

    private static void setInt(EntityPlayer player, ItemStack stack, int intValue, String key) {
        NBTTagCompound nbt = SculptSettingsHelper.initNBT(stack);
        nbt.func_74768_a(key, intValue);
        player.field_71069_bz.func_75142_b();
    }

    private static boolean getBoolean(NBTTagCompound nbt, boolean booleanValue, String key) {
        if (nbt != null && nbt.func_74764_b(key)) {
            booleanValue = nbt.func_74767_n(key);
        }
        return booleanValue;
    }

    private static void setBoolean(EntityPlayer player, ItemStack stack, boolean booleanValue, String key) {
        NBTTagCompound nbt = SculptSettingsHelper.initNBT(stack);
        nbt.func_74757_a(key, booleanValue);
        player.field_71069_bz.func_75142_b();
    }

    private static ItemStack getStack(NBTTagCompound nbt, ItemStack stackToGet, String key) {
        if (nbt != null && nbt.func_74764_b(key)) {
            stackToGet = ItemStackHelper.loadStackFromNBT(nbt, key);
        }
        return stackToGet;
    }

    private static void setStack(EntityPlayer player, ItemStack stack, ItemStack stackToSet, String key) {
        NBTTagCompound nbt = SculptSettingsHelper.initNBT(stack);
        ItemStackHelper.saveStackToNBT(nbt, stackToSet, key);
        player.field_71069_bz.func_75142_b();
    }

    public static int getMode(EntityPlayer player, NBTTagCompound nbt) {
        int mode = Configs.sculptMode.getDefaultValue();
        if (Configs.sculptMode.isPerTool()) {
            mode = SculptSettingsHelper.getInt(nbt, mode, "mode");
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                mode = cap.getMode();
            }
        }
        return mode;
    }

    public static void setMode(EntityPlayer player, ItemStack stack, int mode) {
        World world = player.field_70170_p;
        if (Configs.sculptMode.isPerTool()) {
            if (!world.field_72995_K) {
                SculptSettingsHelper.setInt(player, stack, mode, "mode");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                cap.setMode(mode);
            }
        }
        if (world.field_72995_K) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetMode(mode));
        }
    }

    public static int getDirection(EntityPlayer player, NBTTagCompound nbt) {
        int direction = Configs.sculptDirection.getDefaultValue();
        if (Configs.sculptDirection.isPerTool()) {
            direction = SculptSettingsHelper.getInt(nbt, direction, "direction");
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                direction = cap.getDirection();
            }
        }
        return direction;
    }

    public static void setDirection(EntityPlayer player, ItemStack stack, int direction) {
        World world = player.field_70170_p;
        if (Configs.sculptDirection.isPerTool()) {
            if (!world.field_72995_K) {
                SculptSettingsHelper.setInt(player, stack, direction, "direction");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                cap.setDirection(direction);
            }
        }
        if (world.field_72995_K) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetDirection(direction));
        }
    }

    public static int getShapeType(EntityPlayer player, NBTTagCompound nbt, boolean isCurved) {
        ConfigSculptSettingInt shapeTypeConfig = isCurved ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat;
        int shapeType = shapeTypeConfig.getDefaultValue();
        if (shapeTypeConfig.isPerTool()) {
            shapeType = SculptSettingsHelper.getInt(nbt, shapeType, "shapeType");
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                int n = shapeType = isCurved ? cap.getShapeTypeCurved() : cap.getShapeTypeFlat();
            }
        }
        return isCurved && shapeType > 2 ? Configs.sculptShapeTypeCurved.getDefaultValue() : (!isCurved && shapeType < 3 ? Configs.sculptShapeTypeFlat.getDefaultValue() : shapeType);
    }

    public static void setShapeType(EntityPlayer player, ItemStack stack, boolean isCurved, int shapeType) {
        World world = player.field_70170_p;
        if ((isCurved ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat).isPerTool()) {
            if (!world.field_72995_K) {
                SculptSettingsHelper.setInt(player, stack, shapeType, "shapeType");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                if (isCurved) {
                    cap.setShapeTypeCurved(shapeType);
                } else {
                    cap.setShapeTypeFlat(shapeType);
                }
            }
        }
        if (world.field_72995_K) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetShapeType(isCurved, shapeType));
        }
    }

    public static boolean isBitGridTargeted(EntityPlayer player, NBTTagCompound nbt) {
        boolean targetBitGridVertexes = Configs.sculptTargetBitGridVertexes.getDefaultValue();
        if (Configs.sculptTargetBitGridVertexes.isPerTool()) {
            targetBitGridVertexes = SculptSettingsHelper.getBoolean(nbt, targetBitGridVertexes, "targetBitGridVertexes");
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                targetBitGridVertexes = cap.isBitGridTargeted();
            }
        }
        return targetBitGridVertexes;
    }

    public static void setBitGridTargeted(EntityPlayer player, ItemStack stack, boolean targetBitGridVertexes) {
        World world = player.field_70170_p;
        if (Configs.sculptTargetBitGridVertexes.isPerTool()) {
            if (!world.field_72995_K) {
                SculptSettingsHelper.setBoolean(player, stack, targetBitGridVertexes, "targetBitGridVertexes");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                cap.setBitGridTargeted(targetBitGridVertexes);
            }
        }
        if (world.field_72995_K) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetTargetBitGridVertexes(targetBitGridVertexes));
        }
    }

    public static int getSemiDiameter(EntityPlayer player, NBTTagCompound nbt) {
        int semiDiameter = Configs.sculptSemiDiameter.getDefaultValue();
        if (Configs.sculptSemiDiameter.isPerTool()) {
            if (nbt != null && nbt.func_74764_b("sculptSemiDiameter")) {
                semiDiameter = nbt.func_74762_e("sculptSemiDiameter");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                semiDiameter = cap.getSculptSemiDiameter();
            }
        }
        return semiDiameter;
    }

    public static void setSemiDiameter(EntityPlayer player, ItemStack stack, int semiDiameter) {
        World world = player.field_70170_p;
        if (Configs.sculptSemiDiameter.isPerTool()) {
            if (!world.field_72995_K) {
                SculptSettingsHelper.setInt(player, stack, semiDiameter, "sculptSemiDiameter");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                cap.setSculptSemiDiameter(semiDiameter);
            }
        }
        if (world.field_72995_K) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetSemiDiameter(semiDiameter));
        }
    }

    public static boolean isHollowShape(EntityPlayer player, NBTTagCompound nbt, boolean isWire) {
        ConfigSculptSettingBoolean hollowShapeConfig = isWire ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade;
        boolean hollowShape = hollowShapeConfig.getDefaultValue();
        if (hollowShapeConfig.isPerTool()) {
            hollowShape = SculptSettingsHelper.getBoolean(nbt, hollowShape, "sculptHollowShape");
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                hollowShape = isWire ? cap.isShapeHollowWire() : cap.isShapeHollowSpade();
            }
        }
        return hollowShape;
    }

    public static void setHollowShape(EntityPlayer player, ItemStack stack, boolean isWire, boolean hollowShape) {
        World world = player.field_70170_p;
        if ((isWire ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade).isPerTool()) {
            if (!world.field_72995_K) {
                SculptSettingsHelper.setBoolean(player, stack, hollowShape, "sculptHollowShape");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                if (isWire) {
                    cap.setShapeHollowWire(hollowShape);
                } else {
                    cap.setShapeHollowSpade(hollowShape);
                }
            }
        }
        if (world.field_72995_K) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetHollowShape(hollowShape, isWire));
        }
    }

    public static boolean areEndsOpen(EntityPlayer player, NBTTagCompound nbt) {
        boolean openEnds = Configs.sculptOpenEnds.getDefaultValue();
        if (Configs.sculptOpenEnds.isPerTool()) {
            openEnds = SculptSettingsHelper.getBoolean(nbt, openEnds, "openEnds");
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                openEnds = cap.areEndsOpen();
            }
        }
        return openEnds;
    }

    public static void setEndsOpen(EntityPlayer player, ItemStack stack, boolean openEnds) {
        World world = player.field_70170_p;
        if (Configs.sculptOpenEnds.isPerTool()) {
            if (!world.field_72995_K) {
                SculptSettingsHelper.setBoolean(player, stack, openEnds, "openEnds");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                cap.setEndsOpen(openEnds);
            }
        }
        if (world.field_72995_K) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetEndsOpen(openEnds));
        }
    }

    public static int getWallThickness(EntityPlayer player, NBTTagCompound nbt) {
        int wallThickness = Configs.sculptWallThickness.getDefaultValue();
        if (Configs.sculptWallThickness.isPerTool()) {
            wallThickness = SculptSettingsHelper.getInt(nbt, wallThickness, "wallThickness");
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                wallThickness = cap.getWallThickness();
            }
        }
        return wallThickness;
    }

    public static void setWallThickness(EntityPlayer player, ItemStack stack, int wallThickness) {
        World world = player.field_70170_p;
        if (Configs.sculptWallThickness.isPerTool()) {
            if (!world.field_72995_K) {
                SculptSettingsHelper.setInt(player, stack, wallThickness, "wallThickness");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                cap.setWallThickness(wallThickness);
            }
        }
        if (world.field_72995_K) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetWallThickness(wallThickness));
        }
    }

    public static ItemStack getBitStack(EntityPlayer player, NBTTagCompound nbt, boolean isWire) {
        ConfigSculptSettingBitStack bitStackConfig = isWire ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade;
        ItemStack bitStack = bitStackConfig.getDefaultValue();
        if (bitStackConfig.isPerTool()) {
            bitStack = SculptSettingsHelper.getStack(nbt, bitStack, "setBit");
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                bitStack = isWire ? cap.getBitStackWire() : cap.getBitStackSpade();
            }
        }
        return bitStack;
    }

    public static void setBitStack(EntityPlayer player, ItemStack stack, boolean isWire, ItemStack bitStack) {
        World world = player.field_70170_p;
        if ((isWire ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade).isPerTool()) {
            if (!world.field_72995_K) {
                SculptSettingsHelper.setStack(player, stack, bitStack, "setBit");
            }
        } else {
            ISculptSettingsHandler cap = SculptSettingsHandler.getCapability(player);
            if (cap != null) {
                if (isWire) {
                    cap.setBitStackWire(bitStack);
                } else {
                    cap.setBitStackSpade(bitStack);
                }
            }
        }
        if (world.field_72995_K) {
            ExtraBitManipulation.packetNetwork.sendToServer((IMessage)new PacketSetBitStack(isWire, bitStack));
        }
    }

    public static String getModeText(EntityPlayer player, NBTTagCompound nbt) {
        return SculptSettingsHelper.getModeText(SculptSettingsHelper.getMode(player, nbt));
    }

    public static String getModeText(int mode) {
        return "Mode: " + ItemSculptingTool.MODE_TITLES[mode].toLowerCase();
    }

    public static String getDirectionText(EntityPlayer player, NBTTagCompound nbt, boolean showRotation) {
        return SculptSettingsHelper.getDirectionText(SculptSettingsHelper.getDirection(player, nbt), showRotation);
    }

    public static String getDirectionText(int direction, boolean showRotation) {
        int rotation;
        String text = "Direction: " + EnumFacing.func_82600_a((int)(direction % 6)).func_176610_l().toLowerCase();
        if (showRotation && (rotation = direction / 6) > 0) {
            text = text + " (rotation " + rotation * 90 + "\u00b0)";
        }
        return text;
    }

    public static String getShapeTypeText(EntityPlayer player, NBTTagCompound nbt, ItemSculptingTool item) {
        return SculptSettingsHelper.getShapeTypeText(SculptSettingsHelper.getShapeType(player, nbt, item.isCurved()));
    }

    public static String getShapeTypeText(int shapeType) {
        return "Shape: " + Shape.SHAPE_NAMES[shapeType].toLowerCase();
    }

    public static String getBitGridTargetedText(EntityPlayer player, NBTTagCompound nbt) {
        return SculptSettingsHelper.getBitGridTargetedText(SculptSettingsHelper.isBitGridTargeted(player, nbt));
    }

    public static String getBitGridTargetedText(boolean targetBitGrid) {
        return "Targeting: " + (targetBitGrid ? "bit grid vertiecies" : "bits");
    }

    public static String getSemiDiameterText(EntityPlayer player, NBTTagCompound nbt) {
        return SculptSettingsHelper.getSemiDiameterText(player, nbt, SculptSettingsHelper.getSemiDiameter(player, nbt));
    }

    public static String getSemiDiameterText(EntityPlayer player, NBTTagCompound nbt, int semiDiameter) {
        double size = semiDiameter;
        boolean targetBitGrid = SculptSettingsHelper.isBitGridTargeted(player, nbt);
        String diameterText = "Semi-Diameter: ";
        if (Configs.displayNameDiameter) {
            size *= 2.0;
            if (!targetBitGrid) {
                size += 1.0;
            }
            diameterText = diameterText.substring(5);
        } else if (!targetBitGrid) {
            size += 0.5;
        }
        diameterText = Configs.displayNameUseMeterUnits ? diameterText + (double)Math.round(size * 0.0625 * 100.0) / 100.0 + " meters" : SculptSettingsHelper.addBitLengthString(size, diameterText);
        return diameterText;
    }

    public static String getHollowShapeText(EntityPlayer player, NBTTagCompound nbt, ItemSculptingTool item) {
        return SculptSettingsHelper.getHollowShapeText(SculptSettingsHelper.isHollowShape(player, nbt, item.removeBits()));
    }

    public static String getHollowShapeText(boolean isHollowShape) {
        return "Interior: " + (isHollowShape ? "hollow" : "solid");
    }

    public static String getOpenEndsText(EntityPlayer player, NBTTagCompound nbt) {
        return SculptSettingsHelper.getOpenEndsText(SculptSettingsHelper.areEndsOpen(player, nbt));
    }

    public static String getOpenEndsText(boolean areEndsOpen) {
        return "Ends: " + (areEndsOpen ? "open" : "closed");
    }

    public static String getWallThicknessText(EntityPlayer player, NBTTagCompound nbt) {
        return SculptSettingsHelper.getWallThicknessText(SculptSettingsHelper.getWallThickness(player, nbt));
    }

    public static String getWallThicknessText(int wallThickness) {
        return SculptSettingsHelper.addBitLengthString(wallThickness, "Wall Thickness: ");
    }

    private static String addBitLengthString(double size, String diameterText) {
        if (size >= 16.0) {
            int size2 = (int)size / 16;
            diameterText = diameterText + size2 + " meter";
            if (size2 > 1) {
                diameterText = diameterText + "s";
            }
            if ((size %= 16.0) > 0.0) {
                diameterText = diameterText + " & ";
            }
        }
        if (size > 0.0) {
            diameterText = size == (double)((int)size) ? diameterText + (int)size : diameterText + size;
            diameterText = diameterText + " bits";
        }
        return diameterText;
    }

    public static int cycleData(int intValue, boolean forward, int max) {
        return (intValue + (forward ? 1 : max - 1)) % max;
    }
}

