/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.item;

import com.phylogeny.extrabitmanipulation.api.ChiselsAndBitsAPIAccess;
import com.phylogeny.extrabitmanipulation.config.ConfigProperty;
import com.phylogeny.extrabitmanipulation.config.ConfigSculptSettingBase;
import com.phylogeny.extrabitmanipulation.helper.BitStackHelper;
import com.phylogeny.extrabitmanipulation.helper.SculptSettingsHelper;
import com.phylogeny.extrabitmanipulation.item.ItemBitToolBase;
import com.phylogeny.extrabitmanipulation.reference.Configs;
import com.phylogeny.extrabitmanipulation.shape.AsymmetricalShape;
import com.phylogeny.extrabitmanipulation.shape.Cone;
import com.phylogeny.extrabitmanipulation.shape.ConeElliptic;
import com.phylogeny.extrabitmanipulation.shape.Cube;
import com.phylogeny.extrabitmanipulation.shape.Cuboid;
import com.phylogeny.extrabitmanipulation.shape.Cylinder;
import com.phylogeny.extrabitmanipulation.shape.CylinderElliptic;
import com.phylogeny.extrabitmanipulation.shape.Ellipsoid;
import com.phylogeny.extrabitmanipulation.shape.PrismIsoscelesTriangular;
import com.phylogeny.extrabitmanipulation.shape.PyramidIsoscelesTriangular;
import com.phylogeny.extrabitmanipulation.shape.PyramidRectangular;
import com.phylogeny.extrabitmanipulation.shape.PyramidSquare;
import com.phylogeny.extrabitmanipulation.shape.Shape;
import com.phylogeny.extrabitmanipulation.shape.Sphere;
import com.phylogeny.extrabitmanipulation.shape.SymmetricalShape;
import java.util.HashMap;
import java.util.List;
import mod.chiselsandbits.api.APIExceptions;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.IBitBrush;
import mod.chiselsandbits.api.IBitLocation;
import mod.chiselsandbits.api.IChiselAndBitsAPI;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemSculptingTool
extends ItemBitToolBase {
    public static final String[] MODE_TITLES = new String[]{"Local", "Global", "Drawn"};
    private boolean curved;
    private boolean removeBits;

    public ItemSculptingTool(boolean curved, boolean removeBits, String name) {
        super(name);
        this.curved = curved;
        this.removeBits = removeBits;
    }

    public boolean isCurved() {
        return this.curved;
    }

    public boolean removeBits() {
        return this.removeBits;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        ConfigProperty config = (ConfigProperty)Configs.itemPropertyMap.get((Object)this);
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("remainingUses") && stack.func_77978_p().func_74762_e("remainingUses") < config.maxDamage;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        ConfigProperty config = (ConfigProperty)Configs.itemPropertyMap.get((Object)this);
        int damage = stack.func_77942_o() ? stack.func_77978_p().func_74762_e("remainingUses") : 0;
        return 1.0 - (double)damage / (double)config.maxDamage;
    }

    @Override
    public boolean initialize(ItemStack stack) {
        ItemStack bitStack;
        super.initialize(stack);
        NBTTagCompound nbt = stack.func_77978_p();
        this.initInt(nbt, "remainingUses", ((ConfigProperty)Configs.itemPropertyMap.get((Object)((Object)this))).maxDamage);
        this.initInt(nbt, "mode", Configs.sculptMode.getDefaultValue());
        this.initInt(nbt, "sculptSemiDiameter", Configs.sculptSemiDiameter.getDefaultValue());
        this.initInt(nbt, "direction", Configs.sculptDirection.getDefaultValue());
        this.initBoolean(nbt, "targetBitGridVertexes", Configs.sculptTargetBitGridVertexes.getDefaultValue());
        this.initInt(nbt, "shapeType", (this.curved ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat).getDefaultValue());
        this.initBoolean(nbt, "sculptHollowShape", (this.removeBits ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade).getDefaultValue());
        this.initBoolean(nbt, "openEnds", Configs.sculptOpenEnds.getDefaultValue());
        this.initInt(nbt, "wallThickness", Configs.sculptWallThickness.getDefaultValue());
        if (!nbt.func_74764_b("setBit") && (bitStack = (this.removeBits ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade).getDefaultValue()) != null) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            bitStack.func_77955_b(nbt2);
            nbt.func_74782_a("setBit", (NBTBase)nbt2);
        }
        return true;
    }

    private void initInt(NBTTagCompound nbt, String nbtKey, int initInt) {
        if (!nbt.func_74764_b(nbtKey)) {
            nbt.func_74768_a(nbtKey, initInt);
        }
    }

    private void initBoolean(NBTTagCompound nbt, String nbtKey, boolean initBoolean) {
        if (!nbt.func_74764_b(nbtKey)) {
            nbt.func_74757_a(nbtKey, initBoolean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sculptBlocks(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, Vec3d hit, Vec3d drawnStartPoint) {
        block55: {
            AxisAlignedBB box;
            Shape shape;
            float hitZ;
            float hitY;
            float hitX;
            IBitLocation bitLoc;
            NBTTagCompound nbt;
            boolean globalMode;
            this.initialize(stack);
            IChiselAndBitsAPI api = ChiselsAndBitsAPIAccess.apiInstance;
            boolean inside = ItemSculptingTool.wasInsideClicked(side, hit, pos);
            if (!this.removeBits && !inside) {
                pos = pos.func_177972_a(side);
            }
            boolean bl = globalMode = SculptSettingsHelper.getMode(player, nbt = stack.func_77978_p()) == 1;
            if (drawnStartPoint == null && !globalMode && !this.isValidBlock(api, world, pos) || (bitLoc = api.getBitPos(hitX = (float)hit.field_72450_a - (float)pos.func_177958_n(), hitY = (float)hit.field_72448_b - (float)pos.func_177956_o(), hitZ = (float)hit.field_72449_c - (float)pos.func_177952_p(), side, pos, false)) == null) break block55;
            int sculptSemiDiameter = SculptSettingsHelper.getSemiDiameter(player, nbt);
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            float x2 = (float)x + (float)bitLoc.getBitX() * 0.0625f;
            float y2 = (float)y + (float)bitLoc.getBitY() * 0.0625f;
            float z2 = (float)z + (float)bitLoc.getBitZ() * 0.0625f;
            if (!this.removeBits) {
                x2 += (float)side.func_82601_c() * 0.0625f;
                y2 += (float)side.func_96559_d() * 0.0625f;
                z2 += (float)side.func_82599_e() * 0.0625f;
            }
            int shapeType = SculptSettingsHelper.getShapeType(player, nbt, this.curved);
            int direction = SculptSettingsHelper.getDirection(player, nbt);
            if (shapeType != 4 && shapeType != 5) {
                direction %= 6;
            }
            boolean sculptHollowShape = SculptSettingsHelper.isHollowShape(player, nbt, this.removeBits);
            float wallThickness = (float)SculptSettingsHelper.getWallThickness(player, nbt) * 0.0625f;
            boolean openEnds = SculptSettingsHelper.areEndsOpen(player, nbt);
            if (drawnStartPoint != null) {
                switch (shapeType) {
                    case 1: {
                        shape = new CylinderElliptic();
                        break;
                    }
                    case 2: {
                        shape = new ConeElliptic();
                        break;
                    }
                    case 3: {
                        shape = new Cuboid();
                        break;
                    }
                    case 4: {
                        shape = new PrismIsoscelesTriangular();
                        break;
                    }
                    case 5: {
                        shape = new PyramidIsoscelesTriangular();
                        break;
                    }
                    case 6: {
                        shape = new PyramidRectangular();
                        break;
                    }
                    default: {
                        shape = new Ellipsoid();
                    }
                }
                float x3 = (float)drawnStartPoint.field_72450_a;
                float y3 = (float)drawnStartPoint.field_72448_b;
                float z3 = (float)drawnStartPoint.field_72449_c;
                float minX = this.addPaddingToMin(x2, x3);
                float minY = this.addPaddingToMin(y2, y3);
                float minZ = this.addPaddingToMin(z2, z3);
                float maxX = this.addPaddingToMax(x2, x3);
                float maxY = this.addPaddingToMax(y2, y3);
                float maxZ = this.addPaddingToMax(z2, z3);
                box = new AxisAlignedBB(Math.floor(minX), Math.floor(minY), Math.floor(minZ), Math.ceil(maxX), Math.ceil(maxY), Math.ceil(maxZ));
                float f = 0.5f;
                ((AsymmetricalShape)shape).init((maxX *= f) + (minX *= f), (maxY *= f) + (minY *= f), (maxZ *= f) + (minZ *= f), maxX - minX, maxY - minY, maxZ - minZ, direction, sculptHollowShape, wallThickness, openEnds);
            } else {
                switch (shapeType) {
                    case 1: {
                        shape = new Cylinder();
                        break;
                    }
                    case 2: {
                        shape = new Cone();
                        break;
                    }
                    case 3: {
                        shape = new Cube();
                        break;
                    }
                    case 4: {
                        shape = new PrismIsoscelesTriangular();
                        break;
                    }
                    case 5: {
                        shape = new PyramidIsoscelesTriangular();
                        break;
                    }
                    case 6: {
                        shape = new PyramidSquare();
                        break;
                    }
                    default: {
                        shape = new Sphere();
                    }
                }
                int blockSemiDiameter = globalMode ? (int)Math.ceil((double)sculptSemiDiameter / 16.0) : 0;
                box = new AxisAlignedBB((double)(x - blockSemiDiameter), (double)(y - blockSemiDiameter), (double)(z - blockSemiDiameter), (double)(x + blockSemiDiameter), (double)(y + blockSemiDiameter), (double)(z + blockSemiDiameter));
                float f = 0.0f;
                float x3 = 0.0f;
                float y3 = 0.0f;
                float z3 = 0.0f;
                if (SculptSettingsHelper.isBitGridTargeted(player, nbt)) {
                    boolean su;
                    f = 0.03125f;
                    x3 = hitX < (float)Math.round(hitX / 0.0625f) * 0.0625f ? 1.0f : -1.0f;
                    y3 = hitY < (float)Math.round(hitY / 0.0625f) * 0.0625f ? 1.0f : -1.0f;
                    z3 = hitZ < (float)Math.round(hitZ / 0.0625f) * 0.0625f ? 1.0f : -1.0f;
                    int s = side.ordinal();
                    double offsetX = Math.abs(side.func_82601_c());
                    double offsetY = Math.abs(side.func_96559_d());
                    double offsetZ = Math.abs(side.func_82599_e());
                    if (s % 2 == 0) {
                        if (offsetX > 0.0) {
                            x3 *= -1.0f;
                        }
                        if (offsetY > 0.0) {
                            y3 *= -1.0f;
                        }
                        if (offsetZ > 0.0) {
                            z3 *= -1.0f;
                        }
                    }
                    boolean bl2 = su = s == 1 || s == 3;
                    if (this.removeBits ? !inside || !su : inside && su) {
                        if (offsetX > 0.0) {
                            x3 *= -1.0f;
                        }
                        if (offsetY > 0.0) {
                            y3 *= -1.0f;
                        }
                        if (offsetZ > 0.0) {
                            z3 *= -1.0f;
                        }
                    }
                }
                if (shapeType == 4 || shapeType == 5) {
                    AsymmetricalShape asymmetricalShape = shape;
                    asymmetricalShape.setEquilateral(true);
                    float radius = this.addPadding(sculptSemiDiameter) - f;
                    asymmetricalShape.init(x2 + f * x3, y2 + f * y3, z2 + f * z3, radius, radius, radius, direction, sculptHollowShape, wallThickness, openEnds);
                } else {
                    ((SymmetricalShape)shape).init(x2 + f * x3, y2 + f * y3, z2 + f * z3, this.addPadding(sculptSemiDiameter) - f, direction, sculptHollowShape, wallThickness, openEnds);
                }
            }
            boolean creativeMode = player.field_71075_bZ.field_75098_d;
            HashMap<IBlockState, Integer> bitTypes = null;
            if (this.removeBits && !world.field_72995_K && !creativeMode) {
                bitTypes = new HashMap<IBlockState, Integer>();
            }
            int initialpossibleUses = Integer.MAX_VALUE;
            ItemStack setBitStack = SculptSettingsHelper.getBitStack(player, nbt, this.removeBits);
            IBitBrush setBit = null;
            try {
                setBit = api.createBrush(setBitStack);
                if (!this.removeBits && !creativeMode) {
                    initialpossibleUses = BitStackHelper.countInventoryBits(api, player, setBitStack);
                }
            }
            catch (APIExceptions.InvalidBitItem e) {
                // empty catch block
            }
            int remainingUses = nbt.func_74762_e("remainingUses");
            if (!creativeMode && initialpossibleUses > remainingUses) {
                initialpossibleUses = remainingUses;
            }
            int possibleUses = initialpossibleUses;
            boolean changed = false;
            try {
                api.beginUndoGroup(player);
                int i = (int)box.field_72340_a;
                while ((double)i <= box.field_72336_d) {
                    int j = (int)box.field_72338_b;
                    while ((double)j <= box.field_72337_e) {
                        int k = (int)box.field_72339_c;
                        while ((double)k <= box.field_72334_f) {
                            if (possibleUses > 0) {
                                possibleUses = this.sculptBlock(api, player, world, new BlockPos(i, j, k), shape, bitTypes, possibleUses, Configs.dropBitsPerBlock, setBit);
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Throwable throwable) {
                api.endUndoGroup(player);
                if (!Configs.dropBitsPerBlock) {
                    BitStackHelper.giveOrDropStacks(player, world, pos, shape, api, bitTypes);
                }
                int change = initialpossibleUses - possibleUses;
                ConfigProperty config = (ConfigProperty)Configs.itemPropertyMap.get((Object)this);
                int newRemainingUses = remainingUses - (config.takesDamage ? change : 0);
                if (!world.field_72995_K && !creativeMode) {
                    nbt.func_74768_a("remainingUses", newRemainingUses);
                    if (!this.removeBits) {
                        BitStackHelper.removeOrAddInventoryBits(api, player, setBitStack, change, false);
                    }
                    if (newRemainingUses <= 0) {
                        player.func_70669_a(stack);
                        player.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)null);
                    }
                    player.field_71069_bz.func_75142_b();
                }
                if (!creativeMode && newRemainingUses <= 0) {
                    player.func_70669_a(stack);
                }
                boolean bl3 = changed = possibleUses < initialpossibleUses;
                if (changed) {
                    SoundType sound = Blocks.field_150348_b.func_185467_w();
                    world.func_184133_a(player, pos, sound.func_185841_e(), SoundCategory.BLOCKS, sound.func_185843_a() / 8.0f, sound.func_185847_b() * 0.8f);
                }
                throw throwable;
            }
            api.endUndoGroup(player);
            if (!Configs.dropBitsPerBlock) {
                BitStackHelper.giveOrDropStacks(player, world, pos, shape, api, bitTypes);
            }
            int change = initialpossibleUses - possibleUses;
            ConfigProperty config = (ConfigProperty)Configs.itemPropertyMap.get((Object)this);
            int newRemainingUses = remainingUses - (config.takesDamage ? change : 0);
            if (!world.field_72995_K && !creativeMode) {
                nbt.func_74768_a("remainingUses", newRemainingUses);
                if (!this.removeBits) {
                    BitStackHelper.removeOrAddInventoryBits(api, player, setBitStack, change, false);
                }
                if (newRemainingUses <= 0) {
                    player.func_70669_a(stack);
                    player.func_184611_a(EnumHand.MAIN_HAND, (ItemStack)null);
                }
                player.field_71069_bz.func_75142_b();
            }
            if (!creativeMode && newRemainingUses <= 0) {
                player.func_70669_a(stack);
            }
            boolean bl4 = changed = possibleUses < initialpossibleUses;
            if (changed) {
                SoundType sound = Blocks.field_150348_b.func_185467_w();
                world.func_184133_a(player, pos, sound.func_185841_e(), SoundCategory.BLOCKS, sound.func_185843_a() / 8.0f, sound.func_185847_b() * 0.8f);
            }
            return changed;
        }
        return false;
    }

    private float addPadding(float value) {
        return (value + Configs.semiDiameterPadding) * 0.0625f;
    }

    private float addPaddingToMin(float value1, float value2) {
        return Math.min(value1, value2) - Configs.semiDiameterPadding * 0.0625f;
    }

    private float addPaddingToMax(float value1, float value2) {
        return Math.max(value1, value2) + Configs.semiDiameterPadding * 0.0625f;
    }

    public static boolean wasInsideClicked(EnumFacing dir, Vec3d hit, BlockPos pos) {
        if (hit != null) {
            switch (dir.ordinal()) {
                case 0: {
                    return hit.field_72448_b > (double)pos.func_177956_o();
                }
                case 1: {
                    return hit.field_72448_b < (double)(pos.func_177956_o() + 1);
                }
                case 2: {
                    return hit.field_72449_c > (double)pos.func_177952_p();
                }
                case 3: {
                    return hit.field_72449_c < (double)(pos.func_177952_p() + 1);
                }
                case 4: {
                    return hit.field_72450_a > (double)pos.func_177958_n();
                }
                case 5: {
                    return hit.field_72450_a < (double)(pos.func_177958_n() + 1);
                }
            }
        }
        return false;
    }

    private int sculptBlock(IChiselAndBitsAPI api, EntityPlayer player, World world, BlockPos pos, Shape shape, HashMap<IBlockState, Integer> bitTypes, int remainingUses, boolean dropsPerBlock, IBitBrush setBit) {
        if (this.isValidBlock(api, world, pos)) {
            IBitAccess bitAccess;
            try {
                bitAccess = api.getBitAccess(world, pos);
            }
            catch (APIExceptions.CannotBeChiseled e) {
                e.printStackTrace();
                return remainingUses;
            }
            boolean byPassBitChecks = shape.isBlockInsideShape(pos);
            int initialRemainingUses = remainingUses;
            for (int i = 0; i < 16; ++i) {
                for (int j = 0; j < 16; ++j) {
                    for (int k = 0; k < 16; ++k) {
                        IBitBrush bit = bitAccess.getBitAt(i, j, k);
                        if (!(this.removeBits ? !bit.isAir() && (setBit == null || setBit.isAir() || setBit.getState().equals(bit.getState())) : bit.isAir()) || !byPassBitChecks && !shape.isPointInsideShape(pos, i, j, k)) continue;
                        if (bitTypes != null) {
                            IBlockState state = bit.getState();
                            if (!bitTypes.containsKey(state)) {
                                bitTypes.put(state, 1);
                            } else {
                                bitTypes.put(state, bitTypes.get(state) + 1);
                            }
                        }
                        try {
                            bitAccess.setBitAt(i, j, k, this.removeBits ? null : setBit);
                            --remainingUses;
                        }
                        catch (APIExceptions.SpaceOccupied e) {
                            // empty catch block
                        }
                        if (remainingUses != 0) continue;
                        bitAccess.commitChanges(true);
                        return remainingUses;
                    }
                }
            }
            if (dropsPerBlock) {
                BitStackHelper.giveOrDropStacks(player, world, pos, shape, api, bitTypes);
            }
            if (remainingUses < initialRemainingUses) {
                bitAccess.commitChanges(true);
            }
        }
        return remainingUses;
    }

    private boolean isValidBlock(IChiselAndBitsAPI api, World world, BlockPos pos) {
        return api.canBeChiseled(world, pos) && (!this.removeBits || !world.func_175623_d(pos));
    }

    @Override
    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
        super.func_77622_d(stack, world, player);
        this.initialize(stack);
    }

    private String colorSculptSettingText(String text, ConfigSculptSettingBase setting) {
        return (setting.isPerTool() ? TextFormatting.GREEN : TextFormatting.BLUE) + text;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List tooltip, boolean advanced) {
        boolean shiftDown = GuiScreen.func_146272_n();
        boolean ctrlDown = GuiScreen.func_146271_m();
        if (shiftDown) {
            tooltip.add("");
            tooltip.add(TextFormatting.BLUE + "Blue = data stored/accessed per player");
            tooltip.add(TextFormatting.GREEN + "Green = data stored/accessed per tool");
            tooltip.add("");
        }
        NBTTagCompound nbt = stack.func_77978_p();
        int mode = SculptSettingsHelper.getMode(player, nbt);
        if (shiftDown) {
            tooltip.add(this.colorSculptSettingText(SculptSettingsHelper.getModeText(mode), Configs.sculptMode));
        }
        ItemStack setBitStack = SculptSettingsHelper.getBitStack(player, nbt, this.removeBits);
        if (!ctrlDown || shiftDown) {
            String unspecifiedBit;
            String bitType = "Bit Type To " + (this.removeBits ? "Remove" : "Add") + ": ";
            String string = unspecifiedBit = this.removeBits ? "any" : "none";
            if (setBitStack != null) {
                String stackName = setBitStack.func_82833_r();
                bitType = bitType + (stackName.length() == 12 ? unspecifiedBit : stackName.substring(15));
            } else {
                bitType = bitType + unspecifiedBit;
            }
            if (shiftDown) {
                bitType = this.colorSculptSettingText(bitType, this.removeBits ? Configs.sculptSetBitWire : Configs.sculptSetBitSpade);
            }
            tooltip.add(bitType);
        }
        if (shiftDown) {
            int shapeType = SculptSettingsHelper.getShapeType(player, nbt, this.curved);
            tooltip.add(this.colorSculptSettingText(SculptSettingsHelper.getDirectionText(player, nbt, shapeType == 4 || shapeType == 5), Configs.sculptDirection));
            tooltip.add(this.colorSculptSettingText(SculptSettingsHelper.getShapeTypeText(shapeType), this.removeBits ? Configs.sculptShapeTypeCurved : Configs.sculptShapeTypeFlat));
            boolean targetBits = SculptSettingsHelper.isBitGridTargeted(player, nbt);
            tooltip.add(this.colorSculptSettingText(SculptSettingsHelper.getBitGridTargetedText(targetBits), Configs.sculptTargetBitGridVertexes) + (targetBits ? " (corners)" : " (centers)"));
            tooltip.add(this.colorSculptSettingText(SculptSettingsHelper.getSemiDiameterText(player, nbt), Configs.sculptSemiDiameter));
            tooltip.add(this.colorSculptSettingText(SculptSettingsHelper.getHollowShapeText(player, nbt, this), this.removeBits ? Configs.sculptHollowShapeWire : Configs.sculptHollowShapeSpade));
            tooltip.add(this.colorSculptSettingText("  - " + SculptSettingsHelper.getOpenEndsText(player, nbt), Configs.sculptOpenEnds));
            tooltip.add(this.colorSculptSettingText("  - " + SculptSettingsHelper.getWallThicknessText(player, nbt), Configs.sculptWallThickness));
        } else if (ctrlDown) {
            String toFromText;
            tooltip.add("");
            String removeAddText = this.removeBits ? "remove" : "add";
            String string = toFromText = this.removeBits ? "from" : "to";
            if (!this.removeBits) {
                tooltip.add("Shift left click bit to set bit type.");
            }
            if (mode == 2) {
                tooltip.add("Left click point on block, drag");
                tooltip.add("    to another point, then");
                tooltip.add("    release to " + removeAddText + " bits " + toFromText);
                tooltip.add("    all intersecting blocks.");
            } else {
                String shapeControlText = "Left click block to " + removeAddText + " bits";
                if (mode == 0) {
                    shapeControlText = shapeControlText + ".";
                }
                tooltip.add(shapeControlText);
                if (mode != 0) {
                    String areaText = toFromText;
                    tooltip.add("    " + areaText + " all intersecting blocks.");
                }
            }
            tooltip.add("Right click to cycle modes.");
            tooltip.add("Shift mouse wheel to change");
            tooltip.add("    " + (this.removeBits ? "removal" : "addition") + (Configs.displayNameDiameter ? " " : " semi-") + "diameter.");
            tooltip.add("");
            tooltip.add("Control right click to");
            tooltip.add("    change shape.");
            tooltip.add("Control left click to toggle");
            tooltip.add("    target between");
            tooltip.add("    bits & vertecies.");
            tooltip.add("Control mouse wheel to");
            tooltip.add("    change direction.");
            tooltip.add("");
            tooltip.add("Alt right click to toggle");
            tooltip.add("    shapes solid or hollow.");
            tooltip.add("Alt left click to toggle hollow");
            tooltip.add("    shapes open or closed.");
            tooltip.add("Alt mouse wheel to change hollow");
            tooltip.add("    shape wall thickness.");
        } else {
            tooltip.add("Hold SHIFT for settings.");
            tooltip.add("Hold CONTROL for controls.");
        }
    }
}

