/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.packet;

import com.phylogeny.extrabitmanipulation.item.ItemSculptingTool;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSculpt
implements IMessage {
    private BlockPos pos;
    private EnumFacing side;
    private Vec3d hit;
    private Vec3d drawnStartPoint;

    public PacketSculpt() {
    }

    public PacketSculpt(BlockPos pos, EnumFacing side, Vec3d hit, Vec3d drawnStartPoint) {
        this.pos = pos;
        this.side = side;
        this.hit = hit;
        this.drawnStartPoint = drawnStartPoint;
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeInt(this.pos.func_177958_n());
        buffer.writeInt(this.pos.func_177956_o());
        buffer.writeInt(this.pos.func_177952_p());
        buffer.writeInt(this.side.ordinal());
        buffer.writeDouble(this.hit.field_72450_a);
        buffer.writeDouble(this.hit.field_72448_b);
        buffer.writeDouble(this.hit.field_72449_c);
        boolean notNull = this.drawnStartPoint != null;
        buffer.writeBoolean(notNull);
        if (notNull) {
            buffer.writeDouble(this.drawnStartPoint.field_72450_a);
            buffer.writeDouble(this.drawnStartPoint.field_72448_b);
            buffer.writeDouble(this.drawnStartPoint.field_72449_c);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        this.pos = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        this.side = EnumFacing.func_82600_a((int)buffer.readInt());
        this.hit = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        if (buffer.readBoolean()) {
            this.drawnStartPoint = new Vec3d(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSculpt, IMessage> {
        public IMessage onMessage(final PacketSculpt message, final MessageContext ctx) {
            WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
            mainThread.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
                    ItemStack stack = player.func_184614_ca();
                    if (stack != null && stack.func_77973_b() instanceof ItemSculptingTool && (!player.func_70093_af() || message.drawnStartPoint != null)) {
                        ((ItemSculptingTool)stack.func_77973_b()).sculptBlocks(stack, (EntityPlayer)player, player.field_70170_p, message.pos, message.side, message.hit, message.drawnStartPoint);
                    }
                }
            });
            return null;
        }
    }
}

