/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.shape;

import com.phylogeny.extrabitmanipulation.shape.SymmetricalShape;
import net.minecraft.util.math.BlockPos;

public class Cylinder
extends SymmetricalShape {
    private float diameterSq;
    private float diameterInsetSq;

    @Override
    public void init(float centerX, float centerY, float centerZ, float radius, int direction, boolean sculptHollowShape, float wallThickness, boolean openEnds) {
        super.init(centerX, centerY, centerZ, radius, direction, sculptHollowShape, wallThickness, openEnds);
        this.diameterSq = this.semiDiameter * this.semiDiameter;
        this.diameterInsetSq = this.semiDiameterInset * this.semiDiameterInset;
    }

    @Override
    public boolean isPointInsideShape(BlockPos pos, int i, int j, int k) {
        float y = this.getBitPosY(pos, i, j, k);
        if (this.isPointOffLine(y, this.centerY, this.semiDiameter)) {
            return false;
        }
        float dx = this.getBitPosDiffX(pos, i, j, this.centerX);
        float dz = this.getBitPosDiffZ(pos, j, k, this.centerZ);
        float dist = dx * dx + dz * dz;
        boolean inShape = this.isPointInCircle(this.diameterSq, dist);
        return this.sculptHollowShape ? inShape && (!this.isPointInCircle(this.diameterInsetSq, dist) || !this.openEnds && this.isPointOffLine(y, this.centerY, this.semiDiameterInset)) : inShape;
    }

    private boolean isPointInCircle(float semiDiameter, float dist) {
        return dist <= semiDiameter;
    }
}

