/*
 * Decompiled with CFR 0.152.
 */
package com.phylogeny.extrabitmanipulation.shape;

import com.phylogeny.extrabitmanipulation.shape.AsymmetricalShape;
import net.minecraft.util.math.BlockPos;

public class SlopedAsymmetricalShape
extends AsymmetricalShape {
    protected float height;
    protected float aInset2;
    protected float cInset2;
    private float insetMin;
    private float insetMax;
    private float insetMin2;
    private float insetMax2;

    @Override
    public void init(float centerX, float centerY, float centerZ, float a, float b, float c, int direction, boolean sculptHollowShape, float wallThickness, boolean openEnds) {
        super.init(centerX, centerY, centerZ, a, b, c, direction, sculptHollowShape, wallThickness, openEnds);
        this.height = this.b * 2.0f;
        float hsq = this.height * this.height;
        this.aInset2 = this.b - (float)(Math.sqrt(this.a * this.a + hsq) * (double)wallThickness / (double)this.a);
        this.cInset2 = this.b - (float)(Math.sqrt(this.c * this.c + hsq) * (double)wallThickness / (double)this.c);
        float bInset2 = Math.max(this.aInset2, this.cInset2);
        this.insetMax = this.centerY + this.bInset;
        this.insetMin = this.centerY - this.bInset;
        this.insetMax2 = this.centerY + bInset2;
        this.insetMin2 = this.centerY - bInset2;
    }

    @Override
    public boolean isPointInsideShape(BlockPos pos, int i, int j, int k) {
        float y = this.getBitPosY(pos, i, j, k);
        if (this.isPointOffLine(y, this.centerY, this.b)) {
            return false;
        }
        float dx = this.getBitPosDiffX(pos, i, j, this.centerX);
        float dz = this.getBitPosDiffZ(pos, j, k, this.centerZ);
        boolean inShape = this.isPointIn2DShape(y, this.b, this.b, dx, dz);
        return this.sculptHollowShape ? inShape && (!this.isPointIn2DShape(y, this.aInset2, this.cInset2, dx, dz) || this.isPointOffLine(y)) : inShape;
    }

    protected boolean isPointOffLine(float val) {
        return this.inverted ? !this.openEnds && val > this.insetMax || val < this.insetMin2 : !this.openEnds && val < this.insetMin || val > this.insetMax2;
    }

    protected boolean isPointIn2DShape(float val, float semiDiameter1, float semiDiameter2, float dv1, float dv2) {
        return false;
    }
}

