/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.api.part;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.MatrixHelpers;
import org.cyclops.cyclopscore.init.IInitListener;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkEventListener;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPartNetworkElement;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainerFacade;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.PartTarget;

public interface IPartType<P extends IPartType<P, S>, S extends IPartState<P>>
extends INetworkEventListener<IPartNetwork, IPartNetworkElement<P, S>> {
    public Class<? super P> getPartTypeClass();

    public String getName();

    public String getUnlocalizedNameBase();

    public String getUnlocalizedName();

    public ResourceLocation getBlockModelPath();

    public ResourceLocation getItemModelPath();

    public Item getItem();

    public boolean isSolid(S var1);

    public RenderPosition getRenderPosition();

    public void onInit(IInitListener.Step var1);

    public void toNBT(NBTTagCompound var1, S var2);

    public S fromNBT(NBTTagCompound var1);

    public S getDefaultState();

    public void setUpdateInterval(S var1, int var2);

    public int getUpdateInterval(S var1);

    public boolean isUpdate(S var1);

    public void update(IPartNetwork var1, PartTarget var2, S var3);

    public void beforeNetworkKill(IPartNetwork var1, PartTarget var2, S var3);

    public void afterNetworkAlive(IPartNetwork var1, PartTarget var2, S var3);

    public void afterNetworkReAlive(IPartNetwork var1, PartTarget var2, S var3);

    public ItemStack getItemStack(S var1);

    public ItemStack getPickBlock(World var1, BlockPos var2, S var3);

    public S getState(ItemStack var1);

    public void addDrops(PartTarget var1, S var2, List<ItemStack> var3, boolean var4);

    public void onNetworkAddition(IPartNetwork var1, PartTarget var2, S var3);

    public void onNetworkRemoval(IPartNetwork var1, PartTarget var2, S var3);

    public INetworkElement<IPartNetwork> createNetworkElement(IPartContainerFacade var1, DimPos var2, EnumFacing var3);

    public boolean onPartActivated(World var1, BlockPos var2, S var3, EntityPlayer var4, EnumHand var5, ItemStack var6, EnumFacing var7, float var8, float var9, float var10);

    public IBlockState getBlockState(IPartContainer var1, EnumFacing var2);

    public BlockStateContainer getBaseBlockState();

    public void onPreRemoved(IPartNetwork var1, PartTarget var2, S var3);

    public void onPostRemoved(IPartNetwork var1, PartTarget var2, S var3);

    public void onBlockNeighborChange(IPartNetwork var1, PartTarget var2, S var3, IBlockAccess var4, Block var5);

    public int getConsumptionRate(S var1);

    public void postUpdate(IPartNetwork var1, PartTarget var2, S var3, boolean var4);

    public boolean isEnabled(S var1);

    public void setEnabled(S var1, boolean var2);

    public void loadTooltip(S var1, List<String> var2);

    public boolean shouldTriggerBlockRenderUpdate(@Nullable S var1, @Nullable S var2);

    public static class RenderPosition {
        public static final RenderPosition NONE = new RenderPosition(-1.0f, -1.0f, -1.0f, -1.0f);
        private final float depthFactor;
        private final float widthFactor;
        private final float heightFactor;
        private final EnumFacingMap<AxisAlignedBB> sidedCableCollisionBoxes;
        private final EnumFacingMap<AxisAlignedBB> collisionBoxes;

        public RenderPosition(float selectionDepthFactor, float depthFactor, float widthFactor, float heightFactor) {
            this.depthFactor = depthFactor;
            this.widthFactor = widthFactor;
            this.heightFactor = heightFactor;
            float[][] sidedCableCollisionBoxesRaw = new float[][]{{0.375f, selectionDepthFactor, 0.375f, 0.625f, 0.375f, 0.625f}, {0.375f, 0.625f, 0.375f, 0.625f, 1.0f - selectionDepthFactor, 0.625f}, {0.375f, 0.375f, selectionDepthFactor, 0.625f, 0.625f, 0.375f}, {0.375f, 0.625f, 0.625f, 0.625f, 0.375f, 1.0f - selectionDepthFactor}, {selectionDepthFactor, 0.375f, 0.375f, 0.375f, 0.625f, 0.625f}, {0.625f, 0.375f, 0.375f, 1.0f - selectionDepthFactor, 0.625f, 0.625f}};
            this.sidedCableCollisionBoxes = EnumFacingMap.newMap();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                float[] b = sidedCableCollisionBoxesRaw[side.ordinal()];
                this.sidedCableCollisionBoxes.put((Enum)side, (Object)new AxisAlignedBB((double)b[0], (double)b[1], (double)b[2], (double)b[3], (double)b[4], (double)b[5]));
            }
            float[][] collisionBoxesRaw = new float[][]{{0.19f, 0.81f}, {0.005f, selectionDepthFactor}, {0.19f, 0.81f}};
            this.collisionBoxes = EnumFacingMap.newMap();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                float[][] bounds = new float[collisionBoxesRaw.length][collisionBoxesRaw[0].length];
                for (int i = 0; i < bounds.length; ++i) {
                    bounds[i] = Arrays.copyOf(collisionBoxesRaw[i], collisionBoxesRaw[i].length);
                }
                MatrixHelpers.transform((float[][])bounds, (EnumFacing)side);
                this.collisionBoxes.put((Enum)side, (Object)new AxisAlignedBB((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]));
            }
        }

        public float getDepthFactor() {
            return this.depthFactor;
        }

        public float getWidthFactor() {
            return this.widthFactor;
        }

        public float getHeightFactor() {
            return this.heightFactor;
        }

        public AxisAlignedBB getSidedCableBoundingBox(EnumFacing side) {
            return (AxisAlignedBB)this.sidedCableCollisionBoxes.get((Object)side);
        }

        public AxisAlignedBB getBoundingBox(EnumFacing side) {
            return (AxisAlignedBB)this.collisionBoxes.get((Object)side);
        }
    }
}

