/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core;

import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.core.network.diagnostics.NetworkDiagnostics;
import org.cyclops.integrateddynamics.core.persist.world.NetworkWorldStorage;

public final class TickHandler {
    private static TickHandler INSTANCE;
    private int tick = 0;
    private boolean shouldCrash = false;

    private TickHandler() {
    }

    public static TickHandler getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new TickHandler();
        }
        return INSTANCE;
    }

    public void setShouldCrash() {
        this.shouldCrash = true;
    }

    @SubscribeEvent
    public void onTick(TickEvent event) {
        if (this.shouldCrash) {
            throw new RuntimeException("Forcefully crashed the server.");
        }
        if (event.type == TickEvent.Type.SERVER && event.phase == TickEvent.Phase.END) {
            boolean isBeingDiagnozed = NetworkDiagnostics.getInstance().isBeingDiagnozed();
            if (isBeingDiagnozed) {
                this.tick = (this.tick + 1) % 20;
            }
            boolean shouldSendTickDurationInfo = isBeingDiagnozed && this.tick == 0;
            for (INetwork<?> network : NetworkWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getNetworks()) {
                if (isBeingDiagnozed && (shouldSendTickDurationInfo || network.hasChanged())) {
                    NetworkDiagnostics.getInstance().sendNetworkUpdate(network);
                    network.resetLastSecondDurations();
                }
                try {
                    if (network.isCrashed()) continue;
                    network.update();
                }
                catch (RuntimeException e) {
                    network.setCrashed(true);
                    throw e;
                }
            }
        }
    }
}

