/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.client.gui.container;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.container.GuiContainerExtended;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.container.ExtendedInventoryContainer;
import org.cyclops.cyclopscore.inventory.container.button.IButtonActionClient;
import org.cyclops.integrateddynamics.api.client.gui.subgui.IGuiInputElement;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectPropertyTypeInstance;
import org.cyclops.integrateddynamics.core.client.gui.subgui.SubGuiHolder;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeGuiElement;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeSubGuiRenderPattern;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerAspectSettings;
import org.cyclops.integrateddynamics.core.logicprogrammer.SubGuiConfigRenderPattern;

public class GuiAspectSettings
extends GuiContainerExtended {
    private static final int ERROR_WIDTH = 13;
    private static final int ERROR_HEIGHT = 13;
    private static final int OK_WIDTH = 14;
    private static final int OK_HEIGHT = 12;
    private static final int BUTTON_SAVE = 0;
    private static final int BUTTON_LEFT = 1;
    private static final int BUTTON_RIGHT = 2;
    public static final int BUTTON_EXIT = 3;
    private final PartTarget target;
    private final IPartContainer partContainer;
    private final IPartType partType;
    private final IAspect aspect;
    private final List<IAspectPropertyTypeInstance> propertyTypes;
    protected final SubGuiHolder subGuiHolder = new SubGuiHolder();
    protected ValueTypeGuiElement<GuiAspectSettings, ContainerAspectSettings> guiElement = null;
    protected int activePropertyIndex = 0;
    protected ValueTypeSubGuiRenderPattern propertyConfigPattern = null;
    protected SubGuiValueTypeInfo propertyInfo = null;
    private GuiButtonText buttonLeft = null;
    private GuiButtonText buttonRight = null;
    private GuiButtonText buttonExit = null;
    private L10NHelpers.UnlocalizedString lastError;

    public GuiAspectSettings(EntityPlayer player, PartTarget target, IPartContainer partContainer, IPartType partType, IAspect aspect) {
        super((ExtendedInventoryContainer)new ContainerAspectSettings(player, target, partContainer, partType, aspect));
        this.target = target;
        this.partContainer = partContainer;
        this.partType = partType;
        this.aspect = aspect;
        aspect.getProperties(this.getPartType(), this.getTarget(), ((ContainerAspectSettings)this.container).getPartState());
        this.propertyTypes = Lists.newArrayList(aspect.getDefaultProperties().getTypes());
        this.putButtonAction(0, (IButtonActionClient)new IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>(){

            public void onAction(int buttonId, GuiContainerExtended gui, ExtendedInventoryContainer container) {
                if (GuiAspectSettings.this.guiElement != null && GuiAspectSettings.this.lastError == null) {
                    ContainerAspectSettings aspectContainer = (ContainerAspectSettings)container;
                    aspectContainer.setValue(GuiAspectSettings.this.getActiveProperty(), (IValue)GuiAspectSettings.this.guiElement.getValueType().deserialize(GuiAspectSettings.this.guiElement.getInputString()));
                    try {
                        GuiAspectSettings.this.func_146284_a((GuiButton)GuiAspectSettings.this.buttonExit);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.putButtonAction(1, (IButtonActionClient)new IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>(){

            public void onAction(int buttonId, GuiContainerExtended gui, ExtendedInventoryContainer container) {
                if (GuiAspectSettings.this.getActivePropertyIndex() > 0) {
                    GuiAspectSettings.this.setActiveProperty(GuiAspectSettings.this.getActivePropertyIndex() - 1);
                    GuiAspectSettings.this.refreshButtonEnabled();
                }
            }
        });
        this.putButtonAction(2, (IButtonActionClient)new IButtonActionClient<GuiContainerExtended, ExtendedInventoryContainer>(){

            public void onAction(int buttonId, GuiContainerExtended gui, ExtendedInventoryContainer container) {
                if (GuiAspectSettings.this.getActivePropertyIndex() < GuiAspectSettings.this.propertyTypes.size()) {
                    GuiAspectSettings.this.setActiveProperty(GuiAspectSettings.this.getActivePropertyIndex() + 1);
                    GuiAspectSettings.this.refreshButtonEnabled();
                }
            }
        });
    }

    protected void refreshButtonEnabled() {
        this.buttonLeft.field_146124_l = this.getActivePropertyIndex() > 0;
        this.buttonRight.field_146124_l = this.getActivePropertyIndex() < this.propertyTypes.size() - 1;
    }

    protected int getBaseYSize() {
        return 213;
    }

    public String getGuiTexture() {
        return (String)this.getContainer().getGuiProvider().getMod().getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_GUI) + "aspectSettings.png";
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.subGuiHolder.initGui(this.field_147003_i, this.field_147009_r);
        GuiButtonText buttonSave = new GuiButtonText(0, this.field_147003_i, this.field_147009_r + 88, L10NHelpers.localize((String)"item.items.integrateddynamics.labeller.button.write"));
        this.field_146292_n.add(buttonSave);
        buttonSave.field_146128_h += this.getBaseXSize() - buttonSave.field_146120_f - 9;
        this.buttonExit = new GuiButtonText(3, this.field_147003_i + 7, this.field_147009_r + 5, 12, 10, "<<", true);
        this.field_146292_n.add(this.buttonExit);
        this.buttonLeft = new GuiButtonText(1, this.field_147003_i + 21, this.field_147009_r + 5, 10, 10, "<", true);
        this.field_146292_n.add(this.buttonLeft);
        this.buttonRight = new GuiButtonText(2, this.field_147003_i + 159, this.field_147009_r + 5, 10, 10, ">", true);
        this.field_146292_n.add(this.buttonRight);
        this.refreshButtonEnabled();
        this.setActiveProperty(this.activePropertyIndex);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        this.subGuiHolder.drawGuiContainerBackgroundLayer(this.field_147003_i, this.field_147009_r, this.field_146297_k.field_71446_o, this.field_146289_q, partialTicks, mouseX, mouseY);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        this.subGuiHolder.drawGuiContainerForegroundLayer(this.field_147003_i, this.field_147009_r, this.field_146297_k.field_71446_o, this.field_146289_q, mouseX, mouseY);
        IAspectPropertyTypeInstance activeProperty = this.getActiveProperty();
        if (activeProperty != null) {
            String label = L10NHelpers.localize((String)activeProperty.getUnlocalizedName());
            RenderHelpers.drawScaledCenteredString((FontRenderer)this.field_146289_q, (String)label, (int)88, (int)10, (int)0, (float)1.0f, (int)140, (int)Helpers.RGBToInt((int)10, (int)10, (int)10));
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.subGuiHolder.keyTyped(this.func_146983_a(keyCode), typedChar, keyCode)) {
            super.func_73869_a(typedChar, keyCode);
        } else if (this.guiElement != null) {
            this.onValueChanged();
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        this.subGuiHolder.mouseClicked(mouseX, mouseY, mouseButton);
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void onValueChanged() {
        this.lastError = this.guiElement.validate();
    }

    protected IAspectPropertyTypeInstance getActiveProperty() {
        return this.propertyTypes.get(Math.max(0, Math.min(this.propertyTypes.size() - 1, this.activePropertyIndex)));
    }

    protected void setActiveProperty(int index) {
        this.activePropertyIndex = index;
        this.onActivateElement(this.propertyTypes.get(this.activePropertyIndex));
    }

    protected void onActivateElement(IAspectPropertyTypeInstance property) {
        if (this.guiElement != null) {
            this.guiElement.deactivate();
            this.subGuiHolder.removeSubGui(this.propertyConfigPattern);
            this.subGuiHolder.removeSubGui(this.propertyInfo);
        }
        this.guiElement = new ValueTypeGuiElement((IValueType)property.getType(), IConfigRenderPattern.NONE);
        this.propertyConfigPattern = this.guiElement.createSubGui(8, 17, 160, 91, (Gui)this, (Container)((ContainerAspectSettings)this.getContainer()));
        this.subGuiHolder.addSubGui(this.propertyConfigPattern);
        this.propertyInfo = new SubGuiValueTypeInfo(this.guiElement);
        this.subGuiHolder.addSubGui(this.propertyInfo);
        this.propertyConfigPattern.initGui(this.field_147003_i, this.field_147009_r);
        this.guiElement.activate();
        this.syncInputValue();
        this.lastError = this.guiElement.validate();
    }

    protected void syncInputValue() {
        IAspectPropertyTypeInstance property = this.getActiveProperty();
        Object value = ((ContainerAspectSettings)this.container).getPropertyValue(property);
        if (value != null) {
            this.guiElement.setInputString(property.getType().toCompactString(value), this.propertyConfigPattern);
        }
    }

    public void onUpdate(int valueId, NBTTagCompound value) {
        super.onUpdate(valueId, value);
        IAspectPropertyTypeInstance property = (IAspectPropertyTypeInstance)((ContainerAspectSettings)this.container).getPropertyIds().get((Object)valueId);
        if (property != null && this.getActiveProperty() == property) {
            this.syncInputValue();
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GuiAspectSettings)) {
            return false;
        }
        GuiAspectSettings other = (GuiAspectSettings)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        PartTarget this$target = this.getTarget();
        PartTarget other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)this$target).equals(other$target)) {
            return false;
        }
        IPartContainer this$partContainer = this.getPartContainer();
        IPartContainer other$partContainer = other.getPartContainer();
        if (this$partContainer == null ? other$partContainer != null : !this$partContainer.equals(other$partContainer)) {
            return false;
        }
        IPartType this$partType = this.getPartType();
        IPartType other$partType = other.getPartType();
        if (this$partType == null ? other$partType != null : !this$partType.equals(other$partType)) {
            return false;
        }
        IAspect this$aspect = this.getAspect();
        IAspect other$aspect = other.getAspect();
        if (this$aspect == null ? other$aspect != null : !this$aspect.equals(other$aspect)) {
            return false;
        }
        List<IAspectPropertyTypeInstance> this$propertyTypes = this.getPropertyTypes();
        List<IAspectPropertyTypeInstance> other$propertyTypes = other.getPropertyTypes();
        if (this$propertyTypes == null ? other$propertyTypes != null : !((Object)this$propertyTypes).equals(other$propertyTypes)) {
            return false;
        }
        SubGuiHolder this$subGuiHolder = this.getSubGuiHolder();
        SubGuiHolder other$subGuiHolder = other.getSubGuiHolder();
        if (this$subGuiHolder == null ? other$subGuiHolder != null : !this$subGuiHolder.equals(other$subGuiHolder)) {
            return false;
        }
        ValueTypeGuiElement<GuiAspectSettings, ContainerAspectSettings> this$guiElement = this.getGuiElement();
        ValueTypeGuiElement<GuiAspectSettings, ContainerAspectSettings> other$guiElement = other.getGuiElement();
        if (this$guiElement == null ? other$guiElement != null : !((Object)this$guiElement).equals(other$guiElement)) {
            return false;
        }
        if (this.getActivePropertyIndex() != other.getActivePropertyIndex()) {
            return false;
        }
        ValueTypeSubGuiRenderPattern this$propertyConfigPattern = this.getPropertyConfigPattern();
        ValueTypeSubGuiRenderPattern other$propertyConfigPattern = other.getPropertyConfigPattern();
        if (this$propertyConfigPattern == null ? other$propertyConfigPattern != null : !this$propertyConfigPattern.equals(other$propertyConfigPattern)) {
            return false;
        }
        SubGuiValueTypeInfo this$propertyInfo = this.getPropertyInfo();
        SubGuiValueTypeInfo other$propertyInfo = other.getPropertyInfo();
        if (this$propertyInfo == null ? other$propertyInfo != null : !((Object)this$propertyInfo).equals(other$propertyInfo)) {
            return false;
        }
        GuiButtonText this$buttonLeft = this.getButtonLeft();
        GuiButtonText other$buttonLeft = other.getButtonLeft();
        if (this$buttonLeft == null ? other$buttonLeft != null : !this$buttonLeft.equals(other$buttonLeft)) {
            return false;
        }
        GuiButtonText this$buttonRight = this.getButtonRight();
        GuiButtonText other$buttonRight = other.getButtonRight();
        if (this$buttonRight == null ? other$buttonRight != null : !this$buttonRight.equals(other$buttonRight)) {
            return false;
        }
        GuiButtonText this$buttonExit = this.getButtonExit();
        GuiButtonText other$buttonExit = other.getButtonExit();
        if (this$buttonExit == null ? other$buttonExit != null : !this$buttonExit.equals(other$buttonExit)) {
            return false;
        }
        L10NHelpers.UnlocalizedString this$lastError = this.getLastError();
        L10NHelpers.UnlocalizedString other$lastError = other.getLastError();
        return !(this$lastError == null ? other$lastError != null : !this$lastError.equals(other$lastError));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GuiAspectSettings;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartTarget $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)$target).hashCode());
        IPartContainer $partContainer = this.getPartContainer();
        result = result * 59 + ($partContainer == null ? 43 : $partContainer.hashCode());
        IPartType $partType = this.getPartType();
        result = result * 59 + ($partType == null ? 43 : $partType.hashCode());
        IAspect $aspect = this.getAspect();
        result = result * 59 + ($aspect == null ? 43 : $aspect.hashCode());
        List<IAspectPropertyTypeInstance> $propertyTypes = this.getPropertyTypes();
        result = result * 59 + ($propertyTypes == null ? 43 : ((Object)$propertyTypes).hashCode());
        SubGuiHolder $subGuiHolder = this.getSubGuiHolder();
        result = result * 59 + ($subGuiHolder == null ? 43 : $subGuiHolder.hashCode());
        ValueTypeGuiElement<GuiAspectSettings, ContainerAspectSettings> $guiElement = this.getGuiElement();
        result = result * 59 + ($guiElement == null ? 43 : ((Object)$guiElement).hashCode());
        result = result * 59 + this.getActivePropertyIndex();
        ValueTypeSubGuiRenderPattern $propertyConfigPattern = this.getPropertyConfigPattern();
        result = result * 59 + ($propertyConfigPattern == null ? 43 : $propertyConfigPattern.hashCode());
        SubGuiValueTypeInfo $propertyInfo = this.getPropertyInfo();
        result = result * 59 + ($propertyInfo == null ? 43 : ((Object)$propertyInfo).hashCode());
        GuiButtonText $buttonLeft = this.getButtonLeft();
        result = result * 59 + ($buttonLeft == null ? 43 : $buttonLeft.hashCode());
        GuiButtonText $buttonRight = this.getButtonRight();
        result = result * 59 + ($buttonRight == null ? 43 : $buttonRight.hashCode());
        GuiButtonText $buttonExit = this.getButtonExit();
        result = result * 59 + ($buttonExit == null ? 43 : $buttonExit.hashCode());
        L10NHelpers.UnlocalizedString $lastError = this.getLastError();
        result = result * 59 + ($lastError == null ? 43 : $lastError.hashCode());
        return result;
    }

    public PartTarget getTarget() {
        return this.target;
    }

    public IPartContainer getPartContainer() {
        return this.partContainer;
    }

    public IPartType getPartType() {
        return this.partType;
    }

    public IAspect getAspect() {
        return this.aspect;
    }

    public List<IAspectPropertyTypeInstance> getPropertyTypes() {
        return this.propertyTypes;
    }

    public SubGuiHolder getSubGuiHolder() {
        return this.subGuiHolder;
    }

    public ValueTypeGuiElement<GuiAspectSettings, ContainerAspectSettings> getGuiElement() {
        return this.guiElement;
    }

    public int getActivePropertyIndex() {
        return this.activePropertyIndex;
    }

    public ValueTypeSubGuiRenderPattern getPropertyConfigPattern() {
        return this.propertyConfigPattern;
    }

    public SubGuiValueTypeInfo getPropertyInfo() {
        return this.propertyInfo;
    }

    public GuiButtonText getButtonLeft() {
        return this.buttonLeft;
    }

    public GuiButtonText getButtonRight() {
        return this.buttonRight;
    }

    public GuiButtonText getButtonExit() {
        return this.buttonExit;
    }

    public L10NHelpers.UnlocalizedString getLastError() {
        return this.lastError;
    }

    public void setGuiElement(ValueTypeGuiElement<GuiAspectSettings, ContainerAspectSettings> guiElement) {
        this.guiElement = guiElement;
    }

    public void setActivePropertyIndex(int activePropertyIndex) {
        this.activePropertyIndex = activePropertyIndex;
    }

    public void setPropertyConfigPattern(ValueTypeSubGuiRenderPattern propertyConfigPattern) {
        this.propertyConfigPattern = propertyConfigPattern;
    }

    public void setPropertyInfo(SubGuiValueTypeInfo propertyInfo) {
        this.propertyInfo = propertyInfo;
    }

    public void setButtonLeft(GuiButtonText buttonLeft) {
        this.buttonLeft = buttonLeft;
    }

    public void setButtonRight(GuiButtonText buttonRight) {
        this.buttonRight = buttonRight;
    }

    public void setButtonExit(GuiButtonText buttonExit) {
        this.buttonExit = buttonExit;
    }

    public void setLastError(L10NHelpers.UnlocalizedString lastError) {
        this.lastError = lastError;
    }

    public String toString() {
        return "GuiAspectSettings(target=" + this.getTarget() + ", partContainer=" + this.getPartContainer() + ", partType=" + this.getPartType() + ", aspect=" + this.getAspect() + ", propertyTypes=" + this.getPropertyTypes() + ", subGuiHolder=" + this.getSubGuiHolder() + ", guiElement=" + this.getGuiElement() + ", activePropertyIndex=" + this.getActivePropertyIndex() + ", propertyConfigPattern=" + this.getPropertyConfigPattern() + ", propertyInfo=" + this.getPropertyInfo() + ", buttonLeft=" + this.getButtonLeft() + ", buttonRight=" + this.getButtonRight() + ", buttonExit=" + this.getButtonExit() + ", lastError=" + this.getLastError() + ")";
    }

    public class SubGuiValueTypeInfo
    extends ValueTypeGuiElement.SubGuiValueTypeInfo<SubGuiConfigRenderPattern, GuiAspectSettings, ContainerAspectSettings> {
        public SubGuiValueTypeInfo(IGuiInputElement<SubGuiConfigRenderPattern, GuiAspectSettings, ContainerAspectSettings> element) {
            super(GuiAspectSettings.this, (ContainerAspectSettings)GuiAspectSettings.this.container, element, 8, 105, 160, 20);
        }

        @Override
        protected boolean showError() {
            return true;
        }

        @Override
        protected L10NHelpers.UnlocalizedString getLastError() {
            return GuiAspectSettings.this.lastError;
        }

        @Override
        protected ResourceLocation getTexture() {
            return GuiAspectSettings.this.texture;
        }
    }
}

