/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.operator;

import java.util.Arrays;
import java.util.List;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.EvaluationException;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;

public class CurriedOperator
implements IOperator {
    private final IOperator baseOperator;
    private final IVariable appliedVariable;

    public CurriedOperator(IOperator baseOperator, IVariable appliedVariable) {
        this.baseOperator = baseOperator;
        this.appliedVariable = appliedVariable;
    }

    protected String getAppliedSymbol() {
        return this.appliedVariable.getType().getTypeName();
    }

    @Override
    public String getSymbol() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseOperator.getSymbol());
        sb.append(" [");
        sb.append(this.getAppliedSymbol());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getUniqueName() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.baseOperator.getUniqueName());
        sb.append("[");
        sb.append(this.getAppliedSymbol());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getUnlocalizedName() {
        return this.baseOperator.getUnlocalizedName();
    }

    @Override
    public String getUnlocalizedCategoryName() {
        return this.baseOperator.getUnlocalizedCategoryName();
    }

    @Override
    public String getLocalizedNameFull() {
        return L10NHelpers.localize((String)"operator.integrateddynamics.applied.operatorName", (Object[])new Object[]{this.baseOperator.getLocalizedNameFull(), this.getAppliedSymbol()});
    }

    @Override
    public void loadTooltip(List<String> lines, boolean appendOptionalInfo) {
        this.baseOperator.loadTooltip(lines, appendOptionalInfo);
        lines.add(L10NHelpers.localize((String)"operator.integrateddynamics.applied.type", (Object[])new Object[]{this.getAppliedSymbol()}));
    }

    @Override
    public IValueType[] getInputTypes() {
        IValueType[] baseInputTypes = this.baseOperator.getInputTypes();
        return Arrays.copyOfRange(baseInputTypes, 1, baseInputTypes.length);
    }

    @Override
    public IValueType getOutputType() {
        return this.baseOperator.getOutputType();
    }

    protected IVariable[] deriveFullInputVariables(IVariable[] partialInput) {
        IVariable[] fullInput = new IVariable[Math.min(this.baseOperator.getRequiredInputLength(), partialInput.length + 1)];
        fullInput[0] = this.appliedVariable;
        System.arraycopy(partialInput, 0, fullInput, 1, fullInput.length - 1);
        return fullInput;
    }

    protected IValueType[] deriveFullInputTypes(IValueType[] partialInput) {
        IValueType[] fullInput = new IValueType[Math.min(this.baseOperator.getRequiredInputLength(), partialInput.length + 1)];
        fullInput[0] = this.appliedVariable.getType();
        System.arraycopy(partialInput, 0, fullInput, 1, fullInput.length - 1);
        return fullInput;
    }

    @Override
    public IValueType getConditionalOutputType(IVariable[] input) {
        return this.baseOperator.getConditionalOutputType(this.deriveFullInputVariables(input));
    }

    @Override
    public IValue evaluate(IVariable[] input) throws EvaluationException {
        return this.baseOperator.evaluate(this.deriveFullInputVariables(input));
    }

    @Override
    public int getRequiredInputLength() {
        return this.baseOperator.getRequiredInputLength() - 1;
    }

    @Override
    public L10NHelpers.UnlocalizedString validateTypes(IValueType[] input) {
        return this.baseOperator.validateTypes(this.deriveFullInputTypes(input));
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE;
    }
}

